/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.entity.base;

import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidType;
import ru.astemir.astemirlib.common.math.MathUtils;
import ru.xishnikus.thedawnera.common.entity.data.MobOrder;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseSleepingAnimal;
import ru.xishnikus.thedawnera.common.entity.properties.MobProperties;
import ru.xishnikus.thedawnera.common.entity.properties.misc.NumberProperty;
import ru.xishnikus.thedawnera.common.io.json.TDEJsonUtils;

public abstract class BaseRideableAnimal<T extends Properties>
extends BaseSleepingAnimal<T> {
    protected BaseRideableAnimal(EntityType<? extends BaseSleepingAnimal> type, Level level) {
        super((EntityType<? extends BaseAnimal>)type, level);
        if (((Properties)this.getProperties()).isCanBreakLeaves()) {
            this.m_21441_(BlockPathTypes.LEAVES, 0.0f);
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_20069_() && !this.isSleepingOrResting()) {
            this.breakLeavesDropTrees();
        }
    }

    protected int m_5639_(float distance, float multiplier) {
        if (distance > this.m_20206_() * 1.5f) {
            return Mth.m_14167_((float)((distance * 0.5f - this.m_20206_() * 1.5f) * multiplier));
        }
        return 0;
    }

    protected Vec3 m_274312_(Player player, Vec3 vec) {
        float f = player.f_20902_ < 0.0f ? 0.0f : 1.0f;
        return new Vec3((double)(player.f_20900_ * 0.35f), 0.0, (double)(player.f_20902_ * 0.8f * f));
    }

    protected void m_274498_(Player player, Vec3 vec) {
        if (this.getMovementOrderType() != MobOrder.Movement.WAIT) {
            this.standOrWakeUp(true);
        }
        if (!this.isSleepingOrResting()) {
            if (this.m_20069_() && this.m_204036_(FluidTags.f_13131_) > this.m_20204_() || this.m_20077_() || this.isInFluidType((fluidType, height) -> this.canSwimInFluidType((FluidType)fluidType) && height > this.m_20204_())) {
                this.m_20334_(this.m_20184_().f_82479_, 0.01f, this.m_20184_().f_82481_);
            }
            if (player.f_20902_ != 0.0f || player.f_20900_ != 0.0f) {
                this.f_20883_ = this.f_20885_ = Mth.m_14189_((float)0.15f, (float)this.f_19859_, (float)player.m_146908_());
                this.f_19859_ = this.f_20885_;
                this.m_19915_(Mth.m_14189_((float)0.1f, (float)this.m_146908_(), (float)player.m_146908_()), Mth.m_14189_((float)0.1f, (float)this.m_146909_(), (float)MathUtils.clamp((float)player.m_146909_(), (float)-40.0f, (float)40.0f)));
            }
        }
    }

    protected float m_245547_(Player rider) {
        float movementSpeed = (float)this.m_21133_(Attributes.f_22279_);
        return (float)(rider.m_20142_() ? (double)movementSpeed * ((Properties)this.getProperties()).getRidingSprintSpeed().getDouble() : (double)movementSpeed * ((Properties)this.getProperties()).getRidingSpeed().getDouble());
    }

    public double m_6048_() {
        return (double)this.m_20206_() * 0.765;
    }

    @Override
    public LivingEntity m_6688_() {
        Entity entity = this.m_146895_();
        if (entity instanceof Player) {
            return (Player)entity;
        }
        return null;
    }

    public AABB getTreeFallBoundingBox() {
        return this.m_20191_().m_82377_(2.0, 0.0, 2.0);
    }

    public AABB getLeavesBreakBoundingBox() {
        return this.m_20191_().m_82400_(1.0);
    }

    public float getPassengerEyeScale() {
        return 1.0f;
    }

    public Vec3 m_7688_(LivingEntity passenger) {
        return new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
    }

    public boolean m_264410_() {
        return ((Properties)this.getProperties()).isCanSprint();
    }

    public static class Properties
    extends MobProperties {
        private NumberProperty ridingSpeed = NumberProperty.uniform(0.1f);
        private NumberProperty ridingSprintSpeed = NumberProperty.uniform(0.2f);
        private NumberProperty passengerZoom = NumberProperty.uniform(0.0);
        private boolean canBreakLeaves = true;
        private boolean canDropTrees = false;
        private boolean canSprint = false;

        public Properties(ResourceLocation configPath) {
            super(configPath);
        }

        @Override
        public void deserialize(JsonObject jsonObject) {
            super.deserialize(jsonObject);
            if (jsonObject.has("CanDropTrees")) {
                this.canDropTrees = jsonObject.get("CanDropTrees").getAsBoolean();
            }
            if (jsonObject.has("CanBreakLeaves")) {
                this.canBreakLeaves = jsonObject.get("CanBreakLeaves").getAsBoolean();
            }
            if (jsonObject.has("CanSprint")) {
                this.canSprint = jsonObject.get("CanSprint").getAsBoolean();
            }
            if (jsonObject.has("RidingSpeed")) {
                this.ridingSpeed = TDEJsonUtils.parseNumber(jsonObject, "RidingSpeed");
            }
            if (jsonObject.has("RidingSprintSpeed")) {
                this.ridingSprintSpeed = TDEJsonUtils.parseNumber(jsonObject, "RidingSprintSpeed");
            }
            if (jsonObject.has("PassengerZoom")) {
                this.passengerZoom = TDEJsonUtils.parseNumber(jsonObject, "PassengerZoom");
            }
        }

        public NumberProperty getRidingSpeed() {
            return this.ridingSpeed;
        }

        public NumberProperty getRidingSprintSpeed() {
            return this.ridingSprintSpeed;
        }

        public NumberProperty getPassengerZoom() {
            return this.passengerZoom;
        }

        public boolean isCanBreakLeaves() {
            return this.canBreakLeaves;
        }

        public boolean isCanDropTrees() {
            return this.canDropTrees;
        }

        public boolean isCanSprint() {
            return this.canSprint;
        }
    }
}

