/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.entity.base;

import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import ru.astemir.astemirlib.common.action.ActionState;
import ru.astemir.astemirlib.common.math.RandomUtils;
import ru.xishnikus.thedawnera.common.entity.ai.goal.attack.GoalSenseNearestDanger;
import ru.xishnikus.thedawnera.common.entity.data.MobOrder;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.properties.MobProperties;

public abstract class BaseSleepingAnimal<T extends MobProperties>
extends BaseAnimal<T> {
    public ActionState actionDown = this.actionController.getActionByName("down");
    public ActionState actionStartSleeping;
    public ActionState actionWakeUp;
    public ActionState actionUp = this.actionController.getActionByName("up");
    public ActionState actionRest;
    public ActionState actionSleep;
    private int sleepActionCooldown = 0;

    protected BaseSleepingAnimal(EntityType<? extends BaseAnimal> type, Level level) {
        super(type, level);
        this.actionStartSleeping = this.actionController.getActionByName("fall_asleep");
        this.actionWakeUp = this.actionController.getActionByName("wake_up");
        this.actionRest = this.stateController.getActionByName("rest");
        this.actionSleep = this.stateController.getActionByName("sleep");
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, new GoalSenseNearestDanger<BaseSleepingAnimal>(this));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.isTamed()) {
            if (this.getMovementOrderType() == MobOrder.Movement.WAIT) {
                this.sleepActionCooldown = 0;
                this.lieDownOrSleep(false);
            } else if (this.isSleepingOrResting() && this.getMovementOrderType() == MobOrder.Movement.FOLLOW) {
                this.sleepActionCooldown = 0;
                this.standOrWakeUp(true);
            }
        }
        if (this.sleepActionCooldown > 0) {
            --this.sleepActionCooldown;
        } else if (this.m_5803_()) {
            this.m_6710_(null);
        }
        if (this.canSleep() && !this.m_9236_().f_46443_) {
            ((MobProperties)this.getProperties()).getMobSchedule().tick((Mob)this);
        }
    }

    public void delaySleeping(int min, int max) {
        this.sleepActionCooldown = RandomUtils.randomInt((RandomSource)this.f_19796_, (int)min, (int)max);
    }

    public void wakeUpOthers(int radius) {
        for (BaseSleepingAnimal other : this.m_9236_().m_45976_(BaseSleepingAnimal.class, this.m_20191_().m_82400_((double)radius))) {
            other.sleepActionCooldown = 0;
            other.standOrWakeUp(true);
            other.delaySleeping(100, 200);
        }
    }

    public boolean lieDownOrSleep(boolean shouldSleep) {
        if (this.isTamed() && this.getMovementOrderType() == MobOrder.Movement.FOLLOW) {
            return false;
        }
        if (this.sleepActionCooldown <= 0 && this.m_20096_() && this.actionController.isNoAction()) {
            if (this.stateController.isNoAction()) {
                this.delaySleeping(20, 40);
                this.m_20334_(0.0, 0.0, 0.0);
                this.actionController.playAction(this.actionDown);
                return true;
            }
            if (this.stateController.is(this.actionRest) && shouldSleep) {
                this.delaySleeping(20, 40);
                this.m_20334_(0.0, 0.0, 0.0);
                this.actionController.playAction(this.actionStartSleeping);
                return true;
            }
        }
        return false;
    }

    public boolean standOrWakeUp(boolean shouldStandUp) {
        if (!this.stateController.isNoAction() && this.sleepActionCooldown <= 0 && this.actionController.isNoAction()) {
            if (this.stateController.is(this.actionSleep)) {
                this.delaySleeping(20, 40);
                this.m_20334_(0.0, 0.0, 0.0);
                this.actionController.playAction(this.actionWakeUp);
                return true;
            }
            if (this.stateController.is(this.actionRest) && shouldStandUp) {
                this.delaySleeping(200, 400);
                this.m_20334_(0.0, 0.0, 0.0);
                this.actionController.playAction(this.actionUp);
                return true;
            }
        }
        return false;
    }

    public boolean m_6469_(DamageSource damageSource, float damage) {
        this.delaySleeping(90, 120);
        if (this.isSleepingOrResting()) {
            this.stateController.setNoState();
            this.actionController.setNoState();
        }
        return super.m_6469_(damageSource, damage);
    }

    @Override
    public void m_7334_(Entity entity) {
        super.m_7334_(entity);
        if (entity.getClass() != ((Object)((Object)this)).getClass()) {
            this.standOrWakeUp(false);
            this.sleepActionCooldown = 100;
        }
    }

    protected boolean m_20073_() {
        if (super.m_20073_()) {
            this.standOrWakeUp(true);
            this.sleepActionCooldown = 100;
        }
        return false;
    }

    @Override
    public void sensedExplosionOrLightning(BlockPos pos) {
        this.standOrWakeUp(false);
    }

    public void m_7023_(Vec3 motion) {
        if (this.isSleepingOrResting()) {
            motion = motion.m_82542_(0.0, 1.0, 0.0);
        }
        super.m_7023_(motion);
    }

    @Override
    public void onActionEnd(ActionState state) {
        if (state == this.actionDown) {
            this.stateController.playAction(this.actionRest);
        } else if (state == this.actionUp) {
            this.stateController.setNoState();
        } else if (state == this.actionWakeUp) {
            this.stateController.playAction(this.actionRest);
        } else if (state == this.actionStartSleeping) {
            this.stateController.playAction(this.actionSleep);
        }
    }

    @Override
    public boolean canLook() {
        if (this.isSleepingOrResting()) {
            return false;
        }
        return super.canLook();
    }

    @Override
    public boolean isSleepingOrResting() {
        return this.actionController.is(new ActionState[]{this.actionUp, this.actionDown, this.actionWakeUp, this.actionStartSleeping}) || this.stateController.is(new ActionState[]{this.actionSleep, this.actionRest});
    }

    @Override
    public boolean m_5803_() {
        return this.actionController.is(this.actionStartSleeping) || this.stateController.is(this.actionSleep);
    }

    @Override
    public boolean isResting() {
        return this.actionController.is(new ActionState[]{this.actionUp, this.actionDown, this.actionWakeUp}) || this.stateController.is(this.actionRest);
    }

    public boolean canSleep() {
        return !this.m_146898_() && (!this.isTamed() || this.getMovementOrderType() != MobOrder.Movement.FOLLOW);
    }
}

