/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.entity.base;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import ru.astemir.astemirlib.common.math.AVector3f;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;

public interface ClimberMob {
    public static final Direction[] POSSIBLE_DIRECTIONS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};

    default public void climbTick(float distance, float climbSpeed) {
        Direction attachmentFacing;
        BaseAnimal mob = (BaseAnimal)((Object)this);
        if (mob.m_21224_()) {
            return;
        }
        Vec3 deltaMovement = mob.m_20184_();
        if (!mob.m_9236_().f_46443_) {
            if (this.getClimbDelayTicks() == 0) {
                if (this.canClimb()) {
                    this.setBesideClimbableBlock(mob.f_19862_ || mob.f_19863_ && !mob.m_20096_());
                    if (mob.m_20096_()) {
                        this.setAttachmentDirection(Direction.DOWN);
                    } else if (!mob.f_19863_) {
                        Direction closestDirection = Direction.DOWN;
                        double closestDistance = distance;
                        for (Direction dir : POSSIBLE_DIRECTIONS) {
                            BlockPos mobPos = new BlockPos(Mth.m_14107_((double)mob.m_20185_()), Mth.m_14107_((double)mob.m_20186_()), Mth.m_14107_((double)mob.m_20189_()));
                            BlockPos offsetPos = mobPos.m_121945_(dir);
                            if (!this.isBlockAttachable(mob.m_9236_().m_8055_(offsetPos))) continue;
                            Vec3 offset = Vec3.m_82512_((Vec3i)offsetPos);
                            if (!(closestDistance > mob.m_20182_().m_82554_(offset)) || !mob.m_9236_().m_46578_(offsetPos, (Entity)mob, dir.m_122424_())) continue;
                            closestDistance = mob.m_20182_().m_82554_(offset);
                            closestDirection = dir;
                        }
                        this.setAttachmentDirection(closestDirection);
                        this.setClimbDelayTicks(10);
                    }
                }
            } else {
                this.setClimbDelayTicks(this.getClimbDelayTicks() - 1);
            }
        }
        if ((attachmentFacing = this.getAttachmentFacing()) != Direction.DOWN) {
            float yRot = this.getAttachmentFacing().m_122435_();
            float yDelta = (float)deltaMovement.f_82480_;
            AVector3f vec3 = new AVector3f((float)attachmentFacing.m_122429_() * 0.5f * climbSpeed, yDelta, (float)attachmentFacing.m_122431_() * 0.5f * climbSpeed).normalize().mul(0.5f);
            mob.m_146922_(yRot);
            mob.m_5616_(yRot);
            mob.m_5618_(yRot);
            mob.m_20334_(vec3.x, vec3.y * climbSpeed, vec3.z);
            mob.m_20242_(true);
        } else {
            mob.m_20242_(false);
        }
    }

    default public boolean isClimbing() {
        return this.getAttachmentFacing() != Direction.DOWN;
    }

    default public boolean canClimb() {
        return true;
    }

    default public boolean isBlockAttachable(BlockState state) {
        return true;
    }

    public boolean isBesideClimbableBlock();

    public Direction getAttachmentFacing();

    public Direction getPreviousAttachmentDirection();

    public int getClimbDelayTicks();

    public void setClimbDelayTicks(int var1);

    public void setBesideClimbableBlock(boolean var1);

    public void setAttachmentDirection(Direction var1);

    public void setPreviousAttachmentDirection(Direction var1);
}

