/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.entity.base;

import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseSubpart;

public interface MultipartMob {
    public BaseSubpart<?>[] initializeParts();

    default public BaseSubpart createPart(float sizeX, float sizeY) {
        LivingEntity living = (LivingEntity)this;
        return new BaseSubpart<LivingEntity>(living, sizeX, sizeY);
    }

    default public BaseSubpart[] collectParts(BaseSubpart ... parts) {
        return parts;
    }

    default public void offsetPart(BaseSubpart part, double offsetX, double offsetY, double offsetZ) {
        LivingEntity living = (LivingEntity)this;
        part.m_6034_(living.m_20185_() + offsetX * (double)part.scale, living.m_20186_() + offsetY * (double)part.scale, living.m_20189_() + offsetZ * (double)part.scale);
    }

    default public Vec3[] preparePartPositions() {
        LivingEntity living = (LivingEntity)this;
        PartEntity[] parts = living.getParts();
        Vec3[] partPoses = new Vec3[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            partPoses[i] = new Vec3(parts[i].m_20185_(), parts[i].m_20186_(), parts[i].m_20189_());
        }
        return partPoses;
    }

    default public void applyPartPositions(Vec3[] partPoses) {
        LivingEntity living = (LivingEntity)this;
        PartEntity[] parts = living.getParts();
        for (int i = 0; i < parts.length; ++i) {
            parts[i].f_19854_ = partPoses[i].f_82479_;
            parts[i].f_19855_ = partPoses[i].f_82480_;
            parts[i].f_19856_ = partPoses[i].f_82481_;
            parts[i].f_19790_ = partPoses[i].f_82479_;
            parts[i].f_19791_ = partPoses[i].f_82480_;
            parts[i].f_19792_ = partPoses[i].f_82481_;
        }
    }

    default public Vec3 getOffsetForPart() {
        LivingEntity living = (LivingEntity)this;
        float yaw = living.m_146908_() * ((float)Math.PI / 180);
        float pitch = living.m_146909_() * ((float)Math.PI / 180);
        float offsetX = Mth.m_14031_((float)yaw) * (1.0f - Math.abs(living.m_146909_() / 90.0f));
        float offsetY = -pitch;
        float offsetZ = -Mth.m_14089_((float)yaw) * (1.0f - Math.abs(living.m_146909_() / 90.0f));
        return new Vec3((double)offsetX, (double)offsetY, (double)offsetZ);
    }

    default public void scaleParts(float scale) {
        LivingEntity living = (LivingEntity)this;
        for (PartEntity part : living.getParts()) {
            if (!(part instanceof BaseSubpart)) continue;
            BaseSubpart baseMultiPart = (BaseSubpart)part;
            float prev = baseMultiPart.scale;
            baseMultiPart.scale = scale;
            if (prev == baseMultiPart.scale) continue;
            baseMultiPart.m_6210_();
        }
    }

    default public boolean hurtFromPart(BaseSubpart part, DamageSource source, float amount) {
        LivingEntity living = (LivingEntity)this;
        return living.m_6469_(source, amount);
    }
}

