/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.entity.ground;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import ru.astemir.astemirlib.client.SmoothValue;
import ru.astemir.astemirlib.common.action.ActionState;
import ru.astemir.astemirlib.common.entity.EntityUtils;
import ru.astemir.astemirlib.common.math.InterpolationType;
import ru.xishnikus.thedawnera.common.entity.ai.controller.GiantDinoBodyControl;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseRideableAnimal;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseSleepingAnimal;
import ru.xishnikus.thedawnera.common.entity.input.InputKey;
import ru.xishnikus.thedawnera.common.entity.input.KeyInputMob;
import ru.xishnikus.thedawnera.common.entity.misc.MobStepHandler;
import ru.xishnikus.thedawnera.common.entity.misc.RandomTickAction;
import ru.xishnikus.thedawnera.common.misc.TDESoundEvents;
import ru.xishnikus.thedawnera.common.utils.TDEUtils;

public class EntityCeratosaurus
extends BaseRideableAnimal<BaseRideableAnimal.Properties>
implements KeyInputMob {
    private MobStepHandler stepHandler = new MobStepHandler().addListener(0.7f, 0.8f, (livingEntity, stepTick) -> (stepTick == 6 || stepTick == 14) && !this.isSleepingOrResting()).addListener(0.1f, 1.92f, (livingEntity, stepTick) -> (stepTick == 11 || stepTick == 30) && !this.isSleepingOrResting());
    public SmoothValue<Double> clientNeckRot = SmoothValue.valDouble((InterpolationType)InterpolationType.LINEAR, (double)0.0);
    private RandomTickAction randomRoar = new RandomTickAction("roar", 200, 5.0f, mob -> this.m_5448_() == null && !this.isSleepingOrResting() && !this.m_20069_());
    public ActionState actionAttack = this.actionController.getActionByName("attack");
    public ActionState actionRoar = this.actionController.getActionByName("roar");
    public ActionState actionEat = this.actionController.getActionByName("eat");

    public EntityCeratosaurus(EntityType<? extends BaseSleepingAnimal> type, Level level) {
        super(type, level);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.isSleepingOrResting() && !this.m_217005_()) {
            this.randomRoar.tick(this);
        }
        this.clientNeckRot.update(0.05f);
        this.stepHandler.tick((LivingEntity)this);
    }

    @Override
    public void onActionBegin(ActionState state) {
        if (state == this.actionEat) {
            this.m_5496_((SoundEvent)TDESoundEvents.EAT_MEAT.get(), 1.0f, this.m_6100_() * 0.8f);
        }
        if (state == this.actionAttack) {
            this.m_5496_((SoundEvent)TDESoundEvents.CERATOSAURUS_ATTACK.get(), 1.0f, this.m_6100_());
        }
    }

    @Override
    public void onActionTick(ActionState state, int ticks) {
        if (this.actionController.isActionAt(this.actionDown, 15)) {
            TDEUtils.shakeScreen(this, 14, 20, 2.0);
        }
        if (this.actionController.isActionAt(this.actionAttack, 10)) {
            LivingEntity lastTarget = this.getLastAttackTarget();
            TDEUtils.attackFrontEntities(this, 6.0f);
            if (lastTarget != null && this.m_217066_(lastTarget)) {
                EntityUtils.damageEntity((LivingEntity)this, (Entity)lastTarget, (float)1.0f);
            }
        }
        if (this.actionController.isActionAt(this.actionRoar, 10)) {
            this.wakeUpOthers(14);
            if (this.m_217005_()) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 400, 2));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 400, 1));
            }
            if (this.getHunger() == 0.0f) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 400, 2));
                this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 400, 1));
                TDEUtils.shakeScreen(this, 14, 300, 7.0);
                this.m_5496_((SoundEvent)TDESoundEvents.CERATOSAURUS_ROAR_STRONG.get(), 3.0f, this.m_6100_());
            } else {
                TDEUtils.shakeScreen(this, 14, 300, 5.0);
                this.m_5496_((SoundEvent)TDESoundEvents.CERATOSAURUS_ROAR.get(), 3.0f, this.m_6100_());
            }
        }
    }

    @Override
    public void m_7023_(Vec3 motion) {
        if (this.actionController.is(new ActionState[]{this.actionRoar, this.actionEat})) {
            motion = motion.m_82542_(0.0, 1.0, 0.0);
        }
        super.m_7023_(motion);
    }

    @Override
    public void onInputHandle(InputKey inputKey) {
        if (this.tickControlled >= 20 && this.actionController.isNoAction() && !this.isSleepingOrResting() && !this.m_20069_()) {
            if (inputKey.is("attack") && this.consumeEnergy(20.0f)) {
                this.actionController.playAction(this.actionAttack);
            }
            if (inputKey.is("roar") && this.consumeEnergy(50.0f)) {
                this.actionController.playAction(this.actionRoar);
            }
        }
    }

    @Override
    public void onServerMobStep(float stepPower) {
        if (!this.m_6162_()) {
            MobStepHandler.playStepSound((LivingEntity)this, (SoundEvent)TDESoundEvents.CERATOSAURUS_STEP.get());
        }
    }

    @Override
    public float getPassengerEyeScale() {
        if (this.m_20069_()) {
            return 0.4f;
        }
        if (this.stateController.is(this.actionDown)) {
            float p = (float)this.actionController.getTicks() / (float)this.actionDown.getLength();
            return Math.max(0.5f, 1.0f * p);
        }
        if (this.actionController.is(this.actionUp)) {
            float p = (float)this.actionController.getTicks() / (float)this.actionUp.getLength();
            return Math.max(0.5f, 1.0f * (1.0f - p));
        }
        if (this.stateController.is(this.actionRest) || this.stateController.is(this.actionSleep)) {
            return 0.5f;
        }
        return 1.0f;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        if (this.m_5803_()) {
            return (SoundEvent)TDESoundEvents.CERATOSAURUS_SLEEP.get();
        }
        return (SoundEvent)TDESoundEvents.CERATOSAURUS_IDLE.get();
    }

    public int m_8100_() {
        return 200;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)TDESoundEvents.CERATOSAURUS_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)TDESoundEvents.CERATOSAURUS_DEATH.get();
    }

    public int m_8085_() {
        return 60;
    }

    public int m_21529_() {
        return 5;
    }

    @Override
    protected BodyRotationControl m_7560_() {
        return new GiantDinoBodyControl((Mob)this);
    }

    @Override
    public AABB getTreeFallBoundingBox() {
        return this.m_20191_().m_82400_(1.0);
    }

    @Override
    public AABB getLeavesBreakBoundingBox() {
        return this.m_20191_().m_82400_(1.0);
    }
}

