/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.entity.ground;

import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import ru.astemir.astemirlib.common.action.ActionState;
import ru.astemir.astemirlib.common.entity.EntityUtils;
import ru.astemir.astemirlib.common.handler.EntityEventMap;
import ru.astemir.astemirlib.common.handler.LevelEvent;
import ru.astemir.astemirlib.common.math.AVector3f;
import ru.astemir.astemirlib.common.math.MathUtils;
import ru.astemir.astemirlib.common.math.RandomUtils;
import ru.astemir.astemirlib.common.network.PacketArgument;
import ru.xishnikus.thedawnera.common.TDELevelEvents;
import ru.xishnikus.thedawnera.common.entity.ai.goal.CustomGoal;
import ru.xishnikus.thedawnera.common.entity.ai.goal.move.GoalOpenDoor;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseSleepingAnimal;
import ru.xishnikus.thedawnera.common.entity.entity.base.PackMob;
import ru.xishnikus.thedawnera.common.entity.misc.RandomTickAction;
import ru.xishnikus.thedawnera.common.entity.properties.MobProperties;
import ru.xishnikus.thedawnera.common.entity.properties.ai.CustomGoalFactory;
import ru.xishnikus.thedawnera.common.entity.properties.misc.NumberProperty;
import ru.xishnikus.thedawnera.common.io.json.JsonField;
import ru.xishnikus.thedawnera.common.misc.TDESoundEvents;

public class EntityDeinonychus
extends BaseSleepingAnimal<MobProperties>
implements PackMob {
    private static final EntityDataAccessor<Byte> JUMPING = SynchedEntityData.m_135353_(EntityDeinonychus.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public final ActionState actionAttackBite;
    public final ActionState actionAttackClaw;
    public final ActionState actionAttackLeg;
    public final ActionState actionScream;
    public final ActionState actionCall;
    public final ActionState actionEat;
    public final ActionState actionOpen;
    public final ActionState actionClean;
    public final ActionState actionJump;
    public final ActionState actionLand;
    private RandomTickAction randomCall = new RandomTickAction("call", 200, 20.0f, mob -> this.m_5448_() == null && !this.isSleepingOrResting() && !this.m_20069_());
    private RandomTickAction randomClean = new RandomTickAction("clean", 200, 5.0f, mob -> this.m_5448_() == null && !this.isSleepingOrResting() && !this.m_20069_());
    public float hangOffsetYaw;
    public float hangOffsetPitch;
    private EntityDeinonychus priorPackMember;
    private EntityDeinonychus afterPackMember;
    private BlockPos doorPos;
    private static final LevelEvent eventHangOffset = LevelEvent.create();
    private static final EntityEventMap<EntityDeinonychus> eventMap = EntityEventMap.create().registerEvent(eventHangOffset, (entity, pos, level, args) -> {
        entity.hangOffsetYaw = args[0].asFloat();
        entity.hangOffsetPitch = args[1].asFloat();
    });

    public EntityDeinonychus(EntityType<? extends BaseSleepingAnimal> type, Level level) {
        super((EntityType<? extends BaseAnimal>)type, level);
        this.actionAttackBite = this.actionController.getActionByName("attack1");
        this.actionAttackClaw = this.actionController.getActionByName("attack2");
        this.actionAttackLeg = this.actionController.getActionByName("attack3");
        this.actionScream = this.actionController.getActionByName("scream");
        this.actionEat = this.actionController.getActionByName("eat");
        this.actionCall = this.actionController.getActionByName("call");
        this.actionOpen = this.actionController.getActionByName("open");
        this.actionClean = this.actionController.getActionByName("clean");
        this.actionJump = this.actionController.getActionByName("jump");
        this.actionLand = this.actionController.getActionByName("land");
    }

    @Override
    protected PathNavigation m_6037_(Level level) {
        GroundPathNavigation pathNavigator = (GroundPathNavigation)super.m_6037_(level);
        pathNavigator.m_26477_(true);
        return pathNavigator;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(JUMPING, (Object)0);
    }

    @Override
    public void m_7023_(Vec3 motion) {
        if (this.actionController.is(new ActionState[]{this.actionScream, this.actionEat, this.actionOpen, this.actionJump, this.actionAttackClaw, this.actionAttackLeg, this.actionAttackBite, this.actionScream, this.actionLand, this.actionClean, this.actionCall})) {
            motion = motion.m_82542_(0.0, 1.0, 0.0);
        }
        super.m_7023_(motion);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_20202_() == null) {
            if (!this.m_20069_() && !this.isSleepingOrResting()) {
                this.randomCall.tick(this);
                this.randomClean.tick(this);
            }
            if (this.isJumpState() && !this.m_21224_()) {
                if (this.m_20096_()) {
                    this.actionController.playAction(this.actionLand);
                } else {
                    LivingEntity target = this.m_5448_();
                    if (target != null && this.m_6779_(target)) {
                        Vec3 vec3 = this.m_20184_();
                        double d0 = vec3.m_165924_();
                        float xRot = (float)(Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 57.2957763671875);
                        this.m_146926_(MathUtils.lerp((float)this.m_146909_(), (float)(-xRot), (float)0.4f));
                        this.m_146922_(MathUtils.deg((float)MathUtils.atan2((float)((float)(-vec3.f_82479_)), (float)((float)vec3.f_82481_))));
                        if (!this.m_6162_() && !target.m_21254_() && this.sqrDistanceToEntityCenter((Entity)target) <= this.getReachDistanceTo((Entity)target, 1.0)) {
                            if (target.m_20206_() / this.m_20206_() >= 0.75f) {
                                this.hangOffsetYaw = 180.0f - this.m_146908_();
                                this.hangOffsetPitch = -xRot;
                                this.playClientEvent(eventHangOffset, new PacketArgument[]{PacketArgument.valFloat((float)this.hangOffsetYaw), PacketArgument.valFloat((float)this.hangOffsetPitch)});
                                TDELevelEvents.mount((Entity)this, (Entity)target);
                            } else {
                                this.m_7327_((Entity)target);
                                this.setJumpState(false);
                            }
                        }
                    }
                }
            }
        } else {
            Entity entity = this.m_20202_();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (livingEntity.m_21224_()) {
                    TDELevelEvents.unmount((Entity)this);
                }
                if (this.f_19797_ % 20 == 0 && this.m_6779_(livingEntity)) {
                    this.m_7327_((Entity)livingEntity);
                }
            }
        }
    }

    public double sqrDistanceToEntityCenter(Entity entity) {
        if (entity != null) {
            double d0 = this.m_20185_() - entity.m_20185_();
            double d1 = this.m_20186_() - (entity.m_20186_() + (double)(entity.m_20206_() / 2.0f));
            double d2 = this.m_20189_() - entity.m_20189_();
            return d0 * d0 + d1 * d1 + d2 * d2;
        }
        return -1.0;
    }

    @Override
    public boolean m_6469_(DamageSource damageSource, float damage) {
        if (this.m_20202_() != null && !this.m_9236_().f_46443_ && RandomUtils.doWithChance((RandomSource)this.f_19796_, (float)30.0f)) {
            this.setJumpState(false);
            TDELevelEvents.unmount((Entity)this);
        }
        return super.m_6469_(damageSource, damage);
    }

    @Override
    public void onActionBegin(ActionState state) {
        if (state == this.actionCall) {
            this.m_5496_((SoundEvent)TDESoundEvents.DEINONYCHUS_CALL.get(), 1.0f, this.m_6100_());
            EntityDeinonychus leader = (EntityDeinonychus)this.getPackLeader();
            if (leader != null && leader.equals(this)) {
                PackMob prev = this;
                while (prev.getAfterPackMember() != null && prev.getAfterPackMember() != this) {
                    if (((BaseAnimal)((Object)(prev = prev.getAfterPackMember()))).isTamed()) continue;
                    ((EntityDeinonychus)prev).m_21573_().m_5624_((Entity)leader, (double)1.4f);
                }
            }
        }
        if (state == this.actionAttackBite) {
            this.m_5496_((SoundEvent)TDESoundEvents.DEINONYCHUS_BITE.get(), 1.0f, this.m_6100_());
        }
        if (state == this.actionAttackClaw || state == this.actionAttackLeg) {
            this.m_5496_((SoundEvent)TDESoundEvents.DEINONYCHUS_ATTACK.get(), 1.0f, this.m_6100_());
        }
        if (state == this.actionEat) {
            this.m_5496_((SoundEvent)TDESoundEvents.EAT_GRASS.get(), this.m_6121_(), this.m_6100_() * 1.5f);
        }
    }

    @Override
    public void onActionTick(ActionState state, int ticks) {
        LivingEntity lastTarget;
        if (this.actionController.isActionAt(this.actionAttackClaw, 7) && (lastTarget = this.getLastAttackTarget()) != null && this.m_217066_(lastTarget)) {
            EntityUtils.damageEntity((LivingEntity)this, (Entity)lastTarget, (float)1.25f);
        }
        if (this.actionController.isActionAt(this.actionAttackLeg, 7) && (lastTarget = this.getLastAttackTarget()) != null && this.m_217066_(lastTarget)) {
            EntityUtils.damageEntity((LivingEntity)this, (Entity)lastTarget, (float)1.75f);
        }
        if (this.actionController.isActionAt(this.actionAttackBite, 7) && (lastTarget = this.getLastAttackTarget()) != null && this.m_217066_(lastTarget)) {
            EntityUtils.damageEntity((LivingEntity)this, (Entity)lastTarget, (float)1.5f);
        }
        if (this.actionController.isActionAt(this.actionScream, 10)) {
            this.wakeUpOthers(10);
            this.m_5496_((SoundEvent)TDESoundEvents.DEINONYCHUS_SCREAM.get(), 1.0f, this.m_6100_());
        }
    }

    @Override
    public void onActionEnd(ActionState state) {
        super.onActionEnd(state);
        if (state == this.actionOpen && this.doorPos != null && this.m_20275_(this.doorPos.m_123341_(), this.doorPos.m_123342_(), this.doorPos.m_123343_()) < this.getReachDistance(2.0)) {
            GoalOpenDoor.setDoorState(this.m_9236_(), (Entity)this, this.doorPos, true);
        }
        if (state == this.actionJump) {
            LivingEntity target = this.m_5448_();
            Vec3 vec = this.m_20252_(0.0f);
            if (target != null) {
                AVector3f myPos = AVector3f.from((Vec3)this.m_20182_());
                AVector3f targetPos = AVector3f.from((Vec3)target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0).m_82549_(target.m_20184_()));
                vec = myPos.direction(targetPos).toVec3().m_82541_().m_82490_(this.m_6162_() ? 0.25 : 2.0);
            }
            this.m_20334_(vec.f_82479_, vec.f_82480_ * 0.5 + (double)0.3f, vec.f_82481_);
            this.setJumpState(true);
            if (!this.m_6162_()) {
                this.m_5496_((SoundEvent)TDESoundEvents.DEINONYCHUS_JUMP.get(), this.m_6121_(), this.m_6100_());
            }
        }
        if (state == this.actionLand) {
            this.setJumpState(false);
        }
    }

    public double m_6049_() {
        if (this.m_20202_() != null) {
            return -this.m_20202_().m_20206_() / 2.0f;
        }
        return super.m_6049_();
    }

    public void setJumpState(boolean value) {
        byte b0 = (Byte)this.f_19804_.m_135370_(JUMPING);
        b0 = value ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(JUMPING, (Object)b0);
    }

    public boolean isJumpState() {
        return ((Byte)this.f_19804_.m_135370_(JUMPING) & 1) != 0;
    }

    protected SoundEvent m_7515_() {
        if (this.isSleepingOrResting()) {
            return null;
        }
        return (SoundEvent)TDESoundEvents.DEINONYCHUS_IDLE.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)TDESoundEvents.DEINONYCHUS_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)TDESoundEvents.DEINONYCHUS_DEATH.get();
    }

    public int m_8085_() {
        return 40;
    }

    public int m_21529_() {
        return 40;
    }

    @Override
    public PackMob getPriorPackMember() {
        return this.priorPackMember;
    }

    @Override
    public PackMob getAfterPackMember() {
        return this.afterPackMember;
    }

    @Override
    public void setPriorPackMember(PackMob mob) {
        this.priorPackMember = (EntityDeinonychus)mob;
    }

    @Override
    public void setAfterPackMember(PackMob mob) {
        this.afterPackMember = (EntityDeinonychus)mob;
    }

    public EntityEventMap getClientLevelEventMap() {
        return eventMap;
    }

    public static class Goals {

        public static class OpenDoor
        extends GoalOpenDoor {
            public OpenDoor(BaseAnimal mob) {
                super(mob);
                if (mob instanceof EntityDeinonychus) {
                    EntityDeinonychus deinonychus = (EntityDeinonychus)mob;
                    this.setTriggerOpenDoor((mob1, pos) -> {
                        deinonychus.doorPos = pos;
                        deinonychus.actionController.playAction(deinonychus.actionOpen);
                    });
                }
            }

            public static class Builder
            extends CustomGoalFactory {
                public CustomGoal<? extends BaseAnimal> create(BaseAnimal animal) {
                    return new OpenDoor(animal);
                }
            }
        }

        public static class JumpOnTarget
        extends CustomGoal {
            private EntityDeinonychus deinonychus;
            private long lastCanUseCheck;
            private int interval;

            public JumpOnTarget(BaseAnimal mob, int interval) {
                super(mob);
                this.interval = interval;
                if (mob instanceof EntityDeinonychus) {
                    EntityDeinonychus deinonychus;
                    this.deinonychus = deinonychus = (EntityDeinonychus)mob;
                }
            }

            public boolean m_8036_() {
                LivingEntity target = this.mob.m_5448_();
                if (this.mob.m_20069_() || !this.mob.m_20096_()) {
                    return false;
                }
                if (this.deinonychus.isSleepingOrResting()) {
                    return false;
                }
                if (target == null) {
                    return false;
                }
                if (!this.mob.m_6779_(target)) {
                    return false;
                }
                long i = this.mob.m_9236_().m_46467_();
                if (i - this.lastCanUseCheck < (long)this.interval) {
                    return false;
                }
                this.lastCanUseCheck = i;
                double d0 = this.mob.m_20270_((Entity)target);
                return d0 >= 2.5 && d0 <= 10.0 && this.mob.m_142582_((Entity)target);
            }

            public boolean m_8045_() {
                return false;
            }

            public void m_8056_() {
                this.deinonychus.m_7618_(EntityAnchorArgument.Anchor.EYES, this.mob.m_5448_().m_20182_().m_82549_(this.mob.m_5448_().m_20184_()));
                this.deinonychus.actionController.playAction(this.deinonychus.actionJump);
            }

            public static class Builder
            extends CustomGoalFactory {
                @JsonField(value="Interval")
                private NumberProperty interval = NumberProperty.uniform(80.0);

                public CustomGoal<? extends BaseAnimal> create(BaseAnimal animal) {
                    return new JumpOnTarget(animal, this.interval.getInt());
                }
            }
        }
    }
}

