/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.entity.ground;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import ru.astemir.astemirlib.common.action.ActionState;
import ru.astemir.astemirlib.common.entity.EntityUtils;
import ru.astemir.astemirlib.common.math.AVector3f;
import ru.astemir.astemirlib.common.misc.MiscUtils;
import ru.xishnikus.thedawnera.common.effect.TDEMobEffects;
import ru.xishnikus.thedawnera.common.entity.ai.controller.GiantDinoBodyControl;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseRideableAnimal;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseSleepingAnimal;
import ru.xishnikus.thedawnera.common.entity.input.InputKey;
import ru.xishnikus.thedawnera.common.entity.input.KeyInputMob;
import ru.xishnikus.thedawnera.common.entity.misc.MobStepHandler;
import ru.xishnikus.thedawnera.common.misc.TDESoundEvents;
import ru.xishnikus.thedawnera.common.utils.TDEUtils;

public class EntityDiabloceratops
extends BaseRideableAnimal<BaseRideableAnimal.Properties>
implements KeyInputMob {
    private MobStepHandler stepHandler = new MobStepHandler().addListener(0.4f, 0.64f, (livingEntity, stepTick) -> (stepTick == 1 || stepTick == 7) && !this.isSleepingOrResting()).addListener(0.1f, 1.44f, (livingEntity, stepTick) -> (stepTick == 8 || stepTick == 28) && !this.isSleepingOrResting());
    public ActionState actionAttack = this.actionController.getActionByName("attack");
    public ActionState actionScream = this.actionController.getActionByName("scream");
    public ActionState actionEat = this.actionController.getActionByName("eat");

    public EntityDiabloceratops(EntityType<? extends BaseRideableAnimal> type, Level level) {
        super((EntityType<? extends BaseSleepingAnimal>)type, level);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.stepHandler.tick((LivingEntity)this);
    }

    @Override
    public void m_7023_(Vec3 motion) {
        if (this.actionController.is(new ActionState[]{this.actionScream, this.actionEat})) {
            motion = motion.m_82542_(0.0, 1.0, 0.0);
        }
        super.m_7023_(motion);
    }

    @Override
    public void onActionBegin(ActionState state) {
        if (state == this.actionEat) {
            this.m_5496_((SoundEvent)TDESoundEvents.EAT_GRASS.get(), 1.0f, this.m_6100_());
        }
        if (state == this.actionAttack) {
            this.m_5496_((SoundEvent)TDESoundEvents.DIABLOCERATOPS_ATTACK.get(), 1.0f, this.m_6100_());
        }
    }

    @Override
    public void onActionTick(ActionState state, int ticks) {
        if (this.actionController.isActionAt(this.actionAttack, 8)) {
            TDEUtils.attackFrontEntities(this, 6.0f);
            LivingEntity lastTarget = this.getLastAttackTarget();
            if (lastTarget != null && this.m_217066_(lastTarget)) {
                EntityUtils.damageEntity((LivingEntity)this, (Entity)lastTarget, (float)1.5f);
                lastTarget.m_7292_(new MobEffectInstance((MobEffect)TDEMobEffects.BLEEDING.get(), 240, 0, false, false));
            }
        }
        if (this.actionController.isActionAt(this.actionDown, 15)) {
            TDEUtils.shakeScreen(this, 14, 20, 2.0);
        }
        if (this.actionController.isActionAt(this.actionScream, 10)) {
            this.wakeUpOthers(20);
            TDEUtils.shakeScreen(this, 8, 150, 1.0);
            this.m_5496_((SoundEvent)TDESoundEvents.DIABLOCERATOPS_SCREAM.get(), 2.0f, this.m_6100_());
        }
    }

    @Override
    public void onActionEnd(ActionState state) {
        super.onActionEnd(state);
    }

    @Override
    public void onInputHandle(InputKey inputKey) {
        if (this.tickControlled >= 20 && this.actionController.isNoAction() && !this.isSleepingOrResting()) {
            if (inputKey.is("attack") && this.consumeEnergy(10.0f)) {
                this.actionController.playAction(this.actionAttack);
            }
            if (inputKey.is("roar") && this.consumeEnergy(10.0f)) {
                this.actionController.playAction(this.actionScream);
            }
        }
    }

    @Override
    public void onServerMobStep(float stepPower) {
        if (!this.m_6162_()) {
            MobStepHandler.playStepSound((LivingEntity)this, (SoundEvent)TDESoundEvents.DIABLOCERATOPS_STEP.get());
            if (stepPower == 0.4f) {
                AVector3f dir = EntityUtils.getDirection((Entity)this);
                for (LivingEntity entity : this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82386_((double)(dir.x * 1.5f), 0.0, (double)(dir.z * 1.5f)), MiscUtils.withoutEntity((Entity)this))) {
                    if (!this.m_6779_(entity) || entity instanceof EntityDiabloceratops) continue;
                    float knockbackResistance = (float)entity.m_21133_(Attributes.f_22278_);
                    entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)(this.m_21133_(Attributes.f_22281_) / 2.0));
                    entity.m_20334_((double)(dir.x * (1.0f - knockbackResistance)), (double)(1.0f - knockbackResistance), (double)(dir.z * (1.0f - knockbackResistance)));
                    entity.f_19812_ = true;
                }
            }
        }
    }

    protected SoundEvent m_7515_() {
        if (this.isSleepingOrResting()) {
            return null;
        }
        return (SoundEvent)TDESoundEvents.DIABLOCERATOPS_IDLE.get();
    }

    @Override
    public boolean canLook() {
        if (this.actionController.is(new ActionState[]{this.actionEat, this.actionScream})) {
            return false;
        }
        return super.canLook();
    }

    @Override
    protected BodyRotationControl m_7560_() {
        return new GiantDinoBodyControl((Mob)this);
    }

    @Override
    public float getPassengerEyeScale() {
        if (this.m_20069_()) {
            return 0.5f;
        }
        if (this.actionController.is(this.actionDown)) {
            float p = (float)this.actionController.getTicks() / (float)this.actionDown.getLength();
            return Math.max(0.85f, 1.0f * p);
        }
        if (this.actionController.is(this.actionUp)) {
            float p = (float)this.actionController.getTicks() / (float)this.actionUp.getLength();
            return Math.max(0.85f, 1.0f * (1.0f - p));
        }
        if (this.stateController.is(this.actionRest) || this.stateController.is(this.actionSleep)) {
            return 0.85f;
        }
        return 1.0f;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_21239_) {
        return (SoundEvent)TDESoundEvents.DIABLOCERATOPS_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)TDESoundEvents.DIABLOCERATOPS_DEATH.get();
    }

    public int m_8085_() {
        return 60;
    }

    public int m_21529_() {
        return 10;
    }

    @Override
    public AABB getTreeFallBoundingBox() {
        return this.m_20191_().m_82377_(1.0, 0.0, 1.0);
    }

    @Override
    public AABB getLeavesBreakBoundingBox() {
        return this.m_20191_().m_82377_(1.0, 1.0, 1.0);
    }
}

