/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.entity.ground;

import java.util.EnumSet;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import ru.astemir.astemirlib.client.SmoothValue;
import ru.astemir.astemirlib.common.action.ActionState;
import ru.astemir.astemirlib.common.entity.EntityUtils;
import ru.astemir.astemirlib.common.math.AVector3f;
import ru.astemir.astemirlib.common.math.InterpolationType;
import ru.astemir.astemirlib.common.math.MathUtils;
import ru.astemir.astemirlib.common.math.RandomUtils;
import ru.xishnikus.thedawnera.common.entity.ai.controller.PathNavigationClimber;
import ru.xishnikus.thedawnera.common.entity.ai.goal.CustomGoal;
import ru.xishnikus.thedawnera.common.entity.ai.goal.move.GoalMoveToBlock;
import ru.xishnikus.thedawnera.common.entity.data.MobOrder;
import ru.xishnikus.thedawnera.common.entity.data.MobVariation;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseSleepingAnimal;
import ru.xishnikus.thedawnera.common.entity.entity.base.ClimberMob;
import ru.xishnikus.thedawnera.common.entity.properties.MobProperties;
import ru.xishnikus.thedawnera.common.entity.properties.ai.CustomGoalFactory;
import ru.xishnikus.thedawnera.common.misc.TDESoundEvents;

public class EntityDimorphodon
extends BaseSleepingAnimal<MobProperties>
implements ClimberMob {
    public static final EntityDataAccessor<Boolean> DANCING = SynchedEntityData.m_135353_(EntityDimorphodon.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.m_135353_(EntityDimorphodon.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Direction> ATTACHED_FACE = SynchedEntityData.m_135353_(EntityDimorphodon.class, (EntityDataSerializer)EntityDataSerializers.f_135040_);
    private static final EntityDataAccessor<Direction> PREV_ATTACHED_FACE = SynchedEntityData.m_135353_(EntityDimorphodon.class, (EntityDataSerializer)EntityDataSerializers.f_135040_);
    private static final EntityDataAccessor<Byte> CLIMBING = SynchedEntityData.m_135353_(EntityDimorphodon.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private SmoothValue<Double> eyesAlpha = SmoothValue.valDouble((InterpolationType)InterpolationType.LINEAR, (double)0.0);
    private final DynamicGameEventListener<JukeboxListener> dynamicJukeboxListener = new DynamicGameEventListener((GameEventListener)new JukeboxListener((PositionSource)new EntityPositionSource((Entity)this, this.m_20192_()), GameEvent.f_238690_.m_157827_()));
    public ActionState actionAttack = this.actionController.getActionByName("attack");
    public ActionState actionScream = this.actionController.getActionByName("scream");
    public ActionState actionEat = this.actionController.getActionByName("eat");
    private int climbTicks = 0;
    private int climbDelayTicks = 0;
    private BlockPos jukeboxPos;

    public EntityDimorphodon(EntityType<? extends BaseSleepingAnimal> type, Level level) {
        super((EntityType<? extends BaseAnimal>)type, level);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficultyInstance, MobSpawnType type, @Nullable SpawnGroupData groupData, @Nullable CompoundTag compoundTag) {
        Holder biome = level.m_204166_(this.m_20183_());
        if (biome.m_203565_(Biomes.f_48157_) || biome.m_203565_(Biomes.f_48158_) || biome.m_203565_(Biomes.f_186768_)) {
            this.setVariation(MobVariation.DESERT);
        }
        return super.m_6518_(level, difficultyInstance, type, groupData, compoundTag);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DANCING, (Object)false);
        this.f_19804_.m_135372_(FLYING, (Object)false);
        this.f_19804_.m_135372_(CLIMBING, (Object)0);
        this.f_19804_.m_135372_(ATTACHED_FACE, (Object)Direction.DOWN);
        this.f_19804_.m_135372_(PREV_ATTACHED_FACE, (Object)Direction.DOWN);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("IsFlying", this.isFlying());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setFlying(compound.m_128471_("Flying"));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        Player player = this.m_9236_().m_45930_((Entity)this, 32.0);
        if (player != null) {
            this.m_21566_().m_6849_(player.m_20185_(), player.m_20186_(), player.m_20189_(), 1.0);
        }
        if (!(this.m_6162_() || this.isFlying() || !this.actionController.isNoAction() || this.isSleepingOrResting() || this.m_20069_())) {
            this.climbTick(100.0f, 0.5f);
        }
        this.climbTicks = this.isClimbing() && !this.isSleepingOrResting() ? ++this.climbTicks : 0;
        this.eyesAlpha.update(0.1f);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_ && this.isDancing() && this.shouldStopDancing() && this.f_19797_ % 20 == 0) {
            this.setDancing(false);
            this.jukeboxPos = null;
        }
        if (this.m_20096_() && this.isFlying() || this.m_20069_()) {
            this.setFlying(false);
        }
        if (this.isFlying() && this.m_5448_() == null) {
            AVector3f flyDir = EntityUtils.getDirection((Entity)this);
            this.m_146922_(this.m_146908_() + MathUtils.sin((float)((float)this.f_19797_ / 10.0f)) * 10.0f);
            this.m_20256_(this.m_20184_().m_82520_((double)(flyDir.x * 0.1f), (double)(flyDir.y - 0.25f), (double)(flyDir.z * 0.1f)).m_82542_((double)0.9f, (double)0.3f, (double)0.9f));
        }
    }

    public void m_213651_(BiConsumer<DynamicGameEventListener<?>, ServerLevel> consumer) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            consumer.accept(this.dynamicJukeboxListener, serverlevel);
        }
    }

    @Override
    public void m_7023_(Vec3 motion) {
        if (this.actionController.is(new ActionState[]{this.actionAttack, this.actionEat, this.actionScream}) || this.isDancing() && this.m_5448_() == null) {
            motion = motion.m_82542_(0.0, 1.0, 0.0);
        }
        super.m_7023_(motion);
    }

    @Override
    public void onActionBegin(ActionState state) {
        if (state == this.actionEat) {
            this.m_5496_((SoundEvent)TDESoundEvents.EAT_MEAT.get(), 1.0f, this.m_6100_() * 1.3f);
        }
        if (state == this.actionScream) {
            this.m_5496_((SoundEvent)TDESoundEvents.DIMORPHODON_SCREAM.get(), 1.0f, 1.0f);
        }
    }

    @Override
    public void onActionTick(ActionState state, int ticks) {
        if (this.actionController.isActionAt(this.actionAttack, 8)) {
            LivingEntity lastTarget = this.getLastAttackTarget();
            this.m_216990_((SoundEvent)TDESoundEvents.DIMORPHODON_ATTACK.get());
            if (lastTarget != null && this.m_217066_(lastTarget)) {
                EntityUtils.damageEntity((LivingEntity)this, (Entity)lastTarget, (float)1.0f);
            }
        }
        if (this.actionController.isActionAt(this.actionScream, 10)) {
            this.wakeUpOthers(10);
        }
    }

    public void m_267651_(boolean flying) {
        float f1 = (float)Mth.m_184648_((double)(this.m_20185_() - this.f_19854_), (double)(0.5 * (this.m_20186_() - this.f_19855_)), (double)(this.m_20189_() - this.f_19856_));
        float f2 = Math.min(f1 * 16.0f, 1.0f);
        this.f_267362_.m_267566_(f2, 0.4f);
    }

    @Override
    public boolean m_6469_(DamageSource damageSource, float amount) {
        this.f_19804_.m_135381_(CLIMBING, (Object)0);
        this.f_19804_.m_135381_(ATTACHED_FACE, (Object)Direction.DOWN);
        return super.m_6469_(damageSource, amount);
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    protected void m_6763_(BlockState state) {
    }

    @Override
    protected PathNavigation m_6037_(Level level) {
        return new PathNavigationClimber((Mob)this, level);
    }

    public double m_6048_() {
        return (double)this.m_20206_() * 0.1;
    }

    @Override
    public boolean isBlockAttachable(BlockState state) {
        return state.m_204336_(BlockTags.f_13106_) || state.m_204336_(BlockTags.f_13035_);
    }

    @Override
    public boolean canClimb() {
        return true;
    }

    @Override
    public boolean canLook() {
        return !this.isClimbing() && !super.canLook();
    }

    public boolean canTrample(BlockState state, BlockPos pos, float fallDistance) {
        return false;
    }

    public boolean m_6673_(DamageSource source) {
        return source.m_276093_(DamageTypes.f_268612_) || super.m_6673_(source);
    }

    public boolean m_6147_() {
        if (this.isFlying() || this.isSleepingOrResting()) {
            return false;
        }
        return this.isBesideClimbableBlock();
    }

    @Override
    public boolean isBesideClimbableBlock() {
        return ((Byte)this.f_19804_.m_135370_(CLIMBING) & 1) != 0 && this.getAttachmentFacing() != Direction.DOWN;
    }

    @Override
    public void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.f_19804_.m_135370_(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(CLIMBING, (Object)b0);
    }

    @Override
    public void setAttachmentDirection(Direction direction) {
        if (this.getAttachmentFacing() != direction) {
            this.setPreviousAttachmentDirection(this.getAttachmentFacing());
            this.f_19804_.m_135381_(ATTACHED_FACE, (Object)direction);
        }
    }

    @Override
    public void setPreviousAttachmentDirection(Direction direction) {
        this.f_19804_.m_135381_(PREV_ATTACHED_FACE, (Object)direction);
    }

    @Override
    public Direction getAttachmentFacing() {
        return (Direction)this.f_19804_.m_135370_(ATTACHED_FACE);
    }

    @Override
    public Direction getPreviousAttachmentDirection() {
        return (Direction)this.f_19804_.m_135370_(PREV_ATTACHED_FACE);
    }

    public int m_8085_() {
        return 45;
    }

    public int m_21529_() {
        return 10;
    }

    @Override
    public boolean canSleep() {
        return super.canSleep() && !this.isClimbing();
    }

    public int getClimbTicks() {
        return this.climbTicks;
    }

    @Override
    public int getClimbDelayTicks() {
        return this.climbDelayTicks;
    }

    @Override
    public void setClimbDelayTicks(int ticks) {
        this.climbDelayTicks = ticks;
    }

    public boolean isFlying() {
        return (Boolean)this.f_19804_.m_135370_(FLYING);
    }

    public void setFlying(boolean flying) {
        if (flying && this.m_6162_()) {
            flying = false;
        }
        if (flying) {
            this.m_20242_(true);
        } else {
            this.m_20242_(false);
        }
        this.f_19804_.m_135381_(FLYING, (Object)flying);
    }

    public boolean isDancing() {
        return (Boolean)this.f_19804_.m_135370_(DANCING);
    }

    public void setDancing(boolean value) {
        this.f_19804_.m_135381_(DANCING, (Object)value);
    }

    private boolean shouldStopDancing() {
        return this.jukeboxPos == null || !this.jukeboxPos.m_203195_((Position)this.m_20182_(), (double)GameEvent.f_238690_.m_157827_()) || !this.m_9236_().m_8055_(this.jukeboxPos).m_60713_(Blocks.f_50131_);
    }

    public void setJukeboxPlaying(BlockPos blockPos, boolean value) {
        if (value) {
            if (!this.isDancing()) {
                this.jukeboxPos = blockPos;
                this.setDancing(true);
                this.m_21573_().m_26573_();
            }
        } else if (blockPos.equals((Object)this.jukeboxPos) || this.jukeboxPos == null) {
            this.jukeboxPos = null;
            this.setDancing(false);
        }
    }

    public SmoothValue<Double> getEyesAlpha() {
        return this.eyesAlpha;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        if (this.m_5803_()) {
            return (SoundEvent)TDESoundEvents.DIMORPHODON_SLEEP.get();
        }
        return (SoundEvent)TDESoundEvents.DIMORPHODON_IDLE.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_21239_) {
        return (SoundEvent)TDESoundEvents.DIMORPHODON_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)TDESoundEvents.DIMORPHODON_DEATH.get();
    }

    public class JukeboxListener
    implements GameEventListener {
        private final PositionSource listenerSource;
        private final int listenerRadius;

        public JukeboxListener(PositionSource positionSource, int radius) {
            this.listenerSource = positionSource;
            this.listenerRadius = radius;
        }

        public boolean m_214068_(ServerLevel level, GameEvent event, GameEvent.Context context, Vec3 pos) {
            if (event == GameEvent.f_238690_) {
                EntityDimorphodon.this.setJukeboxPlaying(BlockPos.m_274446_((Position)pos), true);
                return true;
            }
            if (event == GameEvent.f_238649_) {
                EntityDimorphodon.this.setJukeboxPlaying(BlockPos.m_274446_((Position)pos), false);
                return true;
            }
            return false;
        }

        public PositionSource m_142460_() {
            return this.listenerSource;
        }

        public int m_142078_() {
            return this.listenerRadius;
        }
    }

    public static class Goals {

        public static class FlyOrAttack
        extends CustomGoal {
            private EntityDimorphodon entityDimorphodon;
            private int randomTick = 0;

            public FlyOrAttack(BaseAnimal mob) {
                super(mob);
                this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
                if (mob instanceof EntityDimorphodon) {
                    EntityDimorphodon entityDimorphodon;
                    this.entityDimorphodon = entityDimorphodon = (EntityDimorphodon)mob;
                }
            }

            public boolean m_8036_() {
                BaseSleepingAnimal sleepingAnimal;
                if (!this.isCanBeUsed()) {
                    return false;
                }
                BaseAnimal baseAnimal = this.mob;
                if (baseAnimal instanceof BaseSleepingAnimal && (sleepingAnimal = (BaseSleepingAnimal)baseAnimal).isSleepingOrResting()) {
                    return false;
                }
                if (this.entityDimorphodon != null && !this.entityDimorphodon.isFlying() && (this.entityDimorphodon.isClimbing() && this.entityDimorphodon.getClimbTicks() >= RandomUtils.randomInt((int)40, (int)80) || this.mob.m_20075_().m_204336_(BlockTags.f_13106_) || this.mob.m_20075_().m_204336_(BlockTags.f_13035_)) && !this.mob.m_6162_()) {
                    return RandomUtils.doWithChance((float)10.0f);
                }
                return false;
            }

            public boolean m_8045_() {
                if (!this.isCanBeContinuedToUse()) {
                    return false;
                }
                if (this.entityDimorphodon != null && !this.entityDimorphodon.isFlying()) {
                    return false;
                }
                return this.randomTick <= this.m_183277_(100);
            }

            public void m_8056_() {
                super.m_8056_();
                if (!this.entityDimorphodon.isFlying()) {
                    Direction dir = this.entityDimorphodon.getAttachmentFacing();
                    if (dir != Direction.DOWN) {
                        AVector3f vector3f = AVector3f.from((Vector3f)dir.m_122424_().m_253071_());
                        this.mob.m_20334_(vector3f.x, 1.0, vector3f.z);
                        this.mob.m_146922_(MathUtils.deg((float)MathUtils.atan2((float)(-vector3f.x), (float)vector3f.z)));
                    } else {
                        this.mob.m_20334_(0.0, 1.0, 0.0);
                    }
                    this.entityDimorphodon.setAttachmentDirection(Direction.DOWN);
                    this.entityDimorphodon.setBesideClimbableBlock(false);
                    this.entityDimorphodon.setFlying(true);
                }
            }

            public void m_8041_() {
                super.m_8041_();
                this.randomTick = 0;
                if (this.mob.m_5448_() != null) {
                    this.entityDimorphodon.setFlying(false);
                }
            }

            public void m_8037_() {
                super.m_8037_();
                ++this.randomTick;
                LivingEntity target = this.mob.m_5448_();
                if (target != null && this.entityDimorphodon.isFlying() && this.mob.m_6779_(target)) {
                    AVector3f flyDir = EntityUtils.directionTo((Entity)this.mob, (Entity)target);
                    this.mob.m_21563_().m_148051_((Entity)target);
                    this.mob.m_146922_(MathUtils.deg((float)MathUtils.atan2((float)(-flyDir.x), (float)flyDir.z)));
                    this.mob.m_20256_(this.mob.m_20184_().m_82520_((double)(flyDir.x * 0.1f), (double)(flyDir.y - 0.25f), (double)(flyDir.z * 0.1f)).m_82542_(1.0, (double)0.1f, 1.0));
                    if ((double)this.mob.m_20270_((Entity)target) <= (double)(this.mob.m_20205_() * this.mob.m_20205_() + this.mob.m_20205_())) {
                        this.mob.m_20334_(0.0, 0.0, 0.0);
                        this.entityDimorphodon.setFlying(false);
                        this.mob.m_5448_().m_6469_(this.mob.m_269291_().m_269333_((LivingEntity)this.mob), 2.0f);
                    }
                }
            }

            public static class Builder
            extends CustomGoalFactory {
                public CustomGoal<? extends BaseAnimal> create(BaseAnimal animal) {
                    if (animal instanceof EntityDimorphodon) {
                        EntityDimorphodon dimorphodon = (EntityDimorphodon)animal;
                        return new FlyOrAttack(dimorphodon);
                    }
                    throw new RuntimeException("This goal can only be used for Dimorphodon.");
                }
            }
        }

        public static class ClimbOnTree
        extends GoalMoveToBlock<EntityDimorphodon> {
            private BaseAnimal baseAnimal;
            private static final Direction[] directions = new Direction[]{Direction.SOUTH, Direction.EAST, Direction.WEST, Direction.NORTH};

            public ClimbOnTree(EntityDimorphodon mob) {
                super(mob, 2.5, 20, 10, 100, 0.5f, (pos, state) -> {
                    for (Direction direction : directions) {
                        BlockPos nearbyPos = pos.m_121955_(direction.m_122436_());
                        BlockState blockState = mob.m_9236_().m_8055_(nearbyPos);
                        if (!blockState.m_204336_(BlockTags.f_13106_) || !((double)nearbyPos.m_123342_() - mob.m_20186_() >= 2.0) || !((double)nearbyPos.m_123342_() - mob.m_20186_() < 4.0) || !mob.m_9236_().m_46859_(pos)) continue;
                        return true;
                    }
                    return false;
                });
                this.baseAnimal = mob;
            }

            @Override
            public boolean m_8036_() {
                if (!this.isCanBeUsed()) {
                    return false;
                }
                if (((EntityDimorphodon)this.mob).m_6162_() || !((EntityDimorphodon)this.mob).m_20096_()) {
                    return false;
                }
                if (this.baseAnimal.isTamed() && this.baseAnimal.getMovementOrderType() != MobOrder.Movement.WANDER) {
                    if (EntityUtils.isEntityExist((Entity)this.baseAnimal.m_5448_())) {
                        return super.m_8036_();
                    }
                    return false;
                }
                if (EntityUtils.isEntityExist((Entity)this.baseAnimal.m_5448_())) {
                    if (this.baseAnimal.m_20270_((Entity)this.baseAnimal.m_5448_()) > 4.0f) {
                        this.nextStartTick = 0;
                        return super.m_8036_();
                    }
                    return false;
                }
                return super.m_8036_();
            }

            @Override
            public boolean m_8045_() {
                if (!this.isCanBeContinuedToUse()) {
                    return false;
                }
                if (this.baseAnimal.isTamed() && this.baseAnimal.getMovementOrderType() != MobOrder.Movement.WANDER) {
                    if (EntityUtils.isEntityExist((Entity)this.baseAnimal.m_5448_())) {
                        return super.m_8036_();
                    }
                    this.baseAnimal.m_21573_().m_26573_();
                    return false;
                }
                return super.m_8045_();
            }

            public static class Builder
            extends CustomGoalFactory {
                public CustomGoal<? extends BaseAnimal> create(BaseAnimal animal) {
                    if (animal instanceof EntityDimorphodon) {
                        EntityDimorphodon dimorphodon = (EntityDimorphodon)animal;
                        return new ClimbOnTree(dimorphodon);
                    }
                    throw new RuntimeException("This goal can only be used for Dimorphodon.");
                }
            }
        }
    }
}

