/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.entity.ground;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.TurtleEggBlock;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import ru.astemir.astemirlib.common.action.ActionState;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseSleepingAnimal;
import ru.xishnikus.thedawnera.common.entity.properties.MobProperties;
import ru.xishnikus.thedawnera.common.misc.TDESoundEvents;

public class EntityDodo
extends BaseSleepingAnimal<MobProperties> {
    public final ActionState actionScream;
    public final ActionState actionEat;

    public EntityDodo(EntityType<? extends BaseSleepingAnimal> type, Level level) {
        super((EntityType<? extends BaseAnimal>)type, level);
        this.actionScream = this.actionController.getActionByName("scream");
        this.actionEat = this.actionController.getActionByName("eat");
    }

    public void m_8107_() {
        super.m_8107_();
    }

    @Override
    public void m_7023_(Vec3 motion) {
        if (this.actionController.is(new ActionState[]{this.actionEat, this.actionScream})) {
            motion = motion.m_82542_(0.0, 1.0, 0.0);
        }
        super.m_7023_(motion);
    }

    @Override
    public void onActionBegin(ActionState state) {
        if (state == this.actionEat) {
            this.m_5496_((SoundEvent)TDESoundEvents.EAT_GRASS.get(), 1.0f, this.m_6100_() * 1.4f);
        }
        if (state == this.actionScream) {
            this.m_5496_((SoundEvent)TDESoundEvents.DODO_SCREAM.get(), 1.0f, this.m_6100_());
            this.wakeUpOthers(6);
            for (EntityDodo dodo : this.m_9236_().m_45976_(EntityDodo.class, this.m_20191_().m_82377_(7.0, 4.0, 7.0))) {
                if (dodo.m_20148_().equals(this.m_20148_())) continue;
                dodo.m_21573_().m_26573_();
                dodo.m_21573_().m_26536_(dodo.m_21573_().m_6570_((Entity)this, 0), 0.8);
            }
        }
    }

    @Nullable
    protected SoundEvent m_7515_() {
        if (this.m_5803_()) {
            return null;
        }
        return (SoundEvent)TDESoundEvents.DODO_IDLE.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_21239_) {
        return (SoundEvent)TDESoundEvents.DODO_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)TDESoundEvents.DODO_DEATH.get();
    }

    public int m_8085_() {
        return 45;
    }

    public int m_21529_() {
        return 10;
    }

    public static boolean checkDodoSpawnRules(EntityType<EntityDodo> entityType, LevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos blockPos, RandomSource randomSource) {
        return blockPos.m_123342_() < levelAccessor.m_5736_() + 4 && TurtleEggBlock.m_57762_((BlockGetter)levelAccessor, (BlockPos)blockPos) && EntityDodo.m_186209_((BlockAndTintGetter)levelAccessor, (BlockPos)blockPos);
    }
}

