/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.entity.ground;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;
import ru.astemir.astemirlib.common.action.ActionState;
import ru.astemir.astemirlib.common.entity.ai.controller.LookControlSmart;
import ru.xishnikus.thedawnera.common.block.TDEBlocks;
import ru.xishnikus.thedawnera.common.block.eggs.BlockTallSeaGrassEggs;
import ru.xishnikus.thedawnera.common.entity.ai.goal.CustomGoal;
import ru.xishnikus.thedawnera.common.entity.ai.goal.breed.GoalLayEgg;
import ru.xishnikus.thedawnera.common.entity.data.GenderType;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.entity.base.ClimberMob;
import ru.xishnikus.thedawnera.common.entity.misc.RandomTickAction;
import ru.xishnikus.thedawnera.common.entity.properties.MobProperties;
import ru.xishnikus.thedawnera.common.misc.TDETags;

public class EntityPondSnail
extends BaseAnimal<MobProperties>
implements ClimberMob {
    private static final EntityDataAccessor<Direction> ATTACHED_FACE = SynchedEntityData.m_135353_(EntityPondSnail.class, (EntityDataSerializer)EntityDataSerializers.f_135040_);
    private static final EntityDataAccessor<Direction> PREV_ATTACHED_FACE = SynchedEntityData.m_135353_(EntityPondSnail.class, (EntityDataSerializer)EntityDataSerializers.f_135040_);
    private static final EntityDataAccessor<Byte> CLIMBING = SynchedEntityData.m_135353_(EntityPondSnail.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public final ActionState actionHide;
    public final ActionState actionOpen;
    private RandomTickAction randomShowAction = new RandomTickAction("open", 100, 30.0f, mob -> this.isHiding());
    private int climbDelayTicks = 0;

    public EntityPondSnail(EntityType<? extends BaseAnimal> animal, Level level) {
        super(animal, level);
        this.f_21365_ = new LookControlSmart((Mob)this);
        this.actionHide = this.actionController.getActionByName("hide");
        this.actionOpen = this.actionController.getActionByName("open");
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficultyInstance, MobSpawnType type, @Nullable SpawnGroupData groupData, @Nullable CompoundTag compoundTag) {
        SpawnGroupData data = super.m_6518_(level, difficultyInstance, type, groupData, compoundTag);
        this.setGender(GenderType.HERMAPHRODITE);
        return data;
    }

    public boolean m_6914_(LevelReader level) {
        return level.m_45784_((Entity)this);
    }

    @Override
    protected PathNavigation m_6037_(Level worldIn) {
        return new WallClimberNavigation((Mob)this, worldIn);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CLIMBING, (Object)0);
        this.f_19804_.m_135372_(ATTACHED_FACE, (Object)Direction.DOWN);
        this.f_19804_.m_135372_(PREV_ATTACHED_FACE, (Object)Direction.DOWN);
    }

    public boolean canTrample(BlockState state, BlockPos pos, float fallDistance) {
        return false;
    }

    @Override
    public boolean canLook() {
        if (this.isHidingOrShowing() && !this.isClimbing()) {
            return false;
        }
        return super.canLook();
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    protected void m_6763_(BlockState state) {
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6673_(DamageSource source) {
        return source.m_276093_(DamageTypes.f_268612_) || super.m_6673_(source);
    }

    public boolean m_6147_() {
        return this.isBesideClimbableBlock();
    }

    @Override
    public boolean isBesideClimbableBlock() {
        return ((Byte)this.f_19804_.m_135370_(CLIMBING) & 1) != 0 && this.getAttachmentFacing() != Direction.DOWN;
    }

    @Override
    public void setBesideClimbableBlock(boolean climbing) {
        byte b0 = (Byte)this.f_19804_.m_135370_(CLIMBING);
        b0 = climbing ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(CLIMBING, (Object)b0);
    }

    protected void m_7324_(Entity entity) {
    }

    @Override
    public void setAttachmentDirection(Direction direction) {
        if (this.getAttachmentFacing() != direction) {
            this.setPreviousAttachmentDirection(this.getAttachmentFacing());
            this.f_19804_.m_135381_(ATTACHED_FACE, (Object)direction);
        }
    }

    @Override
    public void setPreviousAttachmentDirection(Direction direction) {
        this.f_19804_.m_135381_(PREV_ATTACHED_FACE, (Object)direction);
    }

    @Override
    public Direction getAttachmentFacing() {
        return (Direction)this.f_19804_.m_135370_(ATTACHED_FACE);
    }

    @Override
    public Direction getPreviousAttachmentDirection() {
        return (Direction)this.f_19804_.m_135370_(PREV_ATTACHED_FACE);
    }

    @Override
    public int getClimbDelayTicks() {
        return this.climbDelayTicks;
    }

    @Override
    public void setClimbDelayTicks(int ticks) {
        this.climbDelayTicks = ticks;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.isHidingOrShowing()) {
            this.climbTick(2.0f, 0.05f);
        }
        this.randomShowAction.tick(this);
    }

    public void m_7023_(Vec3 vec3) {
        if (this.isHidingOrShowing()) {
            vec3 = vec3.m_82542_(0.0, 1.0, 0.0);
        }
        super.m_7023_(vec3);
    }

    public boolean isHiding() {
        return this.actionController.is(this.actionHide);
    }

    public boolean isHidingOrShowing() {
        return this.actionController.is(new ActionState[]{this.actionHide, this.actionOpen});
    }

    public void jumpInFluid(FluidType type) {
    }

    public double getFluidMotionScale(FluidType type) {
        return 1.0;
    }

    public boolean m_6063_() {
        return false;
    }

    protected float m_6108_() {
        return 0.0f;
    }

    public int m_8132_() {
        return 1;
    }

    public int m_8085_() {
        return 3;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    public void m_267651_(boolean flying) {
        float f1 = (float)Mth.m_184648_((double)(this.m_20185_() - this.f_19854_), (double)(0.5 * (this.m_20186_() - this.f_19855_)), (double)(this.m_20189_() - this.f_19856_));
        float f2 = Math.min(f1 * 16.0f, 1.0f);
        this.f_267362_.m_267566_(f2, 0.4f);
    }

    public boolean m_6469_(DamageSource damageSource, float amount) {
        this.actionController.playAction(this.actionHide);
        this.f_19804_.m_135381_(CLIMBING, (Object)0);
        this.f_19804_.m_135381_(ATTACHED_FACE, (Object)Direction.DOWN);
        return super.m_6469_(damageSource, amount);
    }

    protected SoundEvent m_7975_(DamageSource p_21239_) {
        return SoundEvents.f_12386_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12386_;
    }

    public static boolean checkSnailSpawnRules(EntityType type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource randomSource) {
        return level.m_8055_(pos.m_7495_().m_7495_()).m_204336_(TDETags.Blocks.UNDERWATER_SPAWNABLE) && pos.m_123342_() > level.m_5736_() - 13 && level.m_6425_(pos.m_7495_()).m_205070_(FluidTags.f_13131_) && level.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_49990_);
    }

    public static class Goals {

        public static class LayEgg<T extends BaseAnimal>
        extends GoalLayEgg<T> {
            public LayEgg(T mob, float speed) {
                super(mob, ((Block)TDEBlocks.SEAGRASS_EGGS.get()).m_49966_(), speed);
                this.setPositionChooser(GoalLayEgg.PositionChooser.SEAGRASS);
            }

            @Override
            public void m_8037_() {
                if (this.layPos != null) {
                    Vec3 position = Vec3.m_82512_((Vec3i)this.layPos);
                    if (this.mob.m_21573_().m_26571_()) {
                        this.mob.m_21573_().m_26519_(position.f_82479_, position.f_82480_, position.f_82481_, this.speed);
                    }
                    this.mob.m_21563_().m_24964_(position);
                    if (this.mob.m_20275_(position.f_82479_, position.f_82480_, position.f_82481_) < this.mob.getReachDistance(2.0)) {
                        ++this.layTicks;
                        if (this.layTicks % 20 == 0) {
                            this.mob.m_9236_().m_46796_(2001, this.layPos, Block.m_49956_((BlockState)this.mob.m_9236_().m_8055_(this.layPos)));
                        }
                        if (this.layTicks > this.m_183277_(100)) {
                            this.mob.setPregnant(false);
                            BlockState oldState = this.mob.m_9236_().m_8055_(this.layPos);
                            if (oldState.m_60713_(Blocks.f_50037_)) {
                                this.mob.m_9236_().m_7731_(this.layPos, ((Block)TDEBlocks.SEAGRASS_EGGS.get()).m_49966_(), 3);
                            } else if (oldState.m_60713_(Blocks.f_50038_)) {
                                this.mob.m_9236_().m_7731_(this.layPos, (BlockState)((Block)TDEBlocks.TALL_SEAGRASS_EGGS.get()).m_49966_().m_61124_((Property)BlockTallSeaGrassEggs.f_154740_, (Comparable)DoubleBlockHalf.LOWER), 19);
                                this.mob.m_9236_().m_7731_(this.layPos.m_7494_(), (BlockState)((Block)TDEBlocks.TALL_SEAGRASS_EGGS.get()).m_49966_().m_61124_((Property)BlockTallSeaGrassEggs.f_154740_, (Comparable)DoubleBlockHalf.UPPER), 19);
                            }
                        }
                    }
                }
            }

            public static class Builder
            extends GoalLayEgg.Builder {
                @Override
                public CustomGoal<? extends BaseAnimal> create(BaseAnimal animal) {
                    return new LayEgg<BaseAnimal>(animal, this.speedModifier.getFloat());
                }
            }
        }
    }
}

