/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.entity.ground;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import ru.astemir.astemirlib.common.action.ActionState;
import ru.astemir.astemirlib.common.entity.EntityUtils;
import ru.xishnikus.thedawnera.common.entity.ai.goal.move.GoalMoveToBlock;
import ru.xishnikus.thedawnera.common.entity.data.MobOrder;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseSleepingAnimal;
import ru.xishnikus.thedawnera.common.entity.entity.base.ScaredMob;
import ru.xishnikus.thedawnera.common.entity.properties.MobProperties;
import ru.xishnikus.thedawnera.common.misc.TDESoundEvents;
import ru.xishnikus.thedawnera.common.utils.TDEUtils;

public class EntityPsittacosaurus
extends BaseSleepingAnimal<MobProperties>
implements ScaredMob {
    public final ActionState actionAttack;
    public final ActionState actionScream;
    public final ActionState actionBush;
    public final ActionState actionEat;
    private BlockPos cropPos;
    private int scaredTicks;

    public EntityPsittacosaurus(EntityType<? extends BaseSleepingAnimal> type, Level level) {
        super((EntityType<? extends BaseAnimal>)type, level);
        this.m_21441_(BlockPathTypes.DANGER_OTHER, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_OTHER, 0.0f);
        this.addSpecificOrders(MobOrder.Specific.GATHERING);
        this.actionAttack = this.actionController.getActionByName("attack");
        this.actionScream = this.actionController.getActionByName("scream");
        this.actionBush = this.actionController.getActionByName("bush");
        this.actionEat = this.actionController.getActionByName("eat");
    }

    @Override
    public void m_7023_(Vec3 motion) {
        if (this.actionController.is(new ActionState[]{this.actionScream, this.actionEat, this.actionBush})) {
            motion = motion.m_82542_(0.0, 1.0, 0.0);
        }
        super.m_7023_(motion);
    }

    @Override
    public boolean m_6469_(DamageSource damageSource, float damage) {
        if (damageSource != this.m_269291_().m_269555_()) {
            return super.m_6469_(damageSource, damage);
        }
        return false;
    }

    @Override
    public void onActionBegin(ActionState state) {
        if (state == this.actionAttack) {
            this.m_5496_((SoundEvent)TDESoundEvents.PSITTACOSAURUS_ATTACK.get(), 1.0f, this.m_6100_());
        }
        if (state == this.actionEat) {
            this.m_5496_((SoundEvent)TDESoundEvents.EAT_GRASS.get(), this.m_6121_(), this.m_6100_() * 1.5f);
        }
    }

    @Override
    public void onActionTick(ActionState state, int ticks) {
        LivingEntity lastTarget;
        if (this.actionController.isActionAt(this.actionBush, 18) && this.cropPos != null) {
            BlockState blockState = this.m_9236_().m_8055_(this.cropPos);
            Block cropBlock = blockState.m_60734_();
            if (cropBlock instanceof CropBlock) {
                this.m_9236_().m_46953_(this.cropPos, true, (Entity)this);
            } else if (cropBlock instanceof SweetBerryBushBlock && (Integer)blockState.m_61143_((Property)SweetBerryBushBlock.f_57244_) > 1) {
                TDEUtils.pickSweetBerries((Entity)this, this.cropPos, blockState);
            }
        }
        if (this.actionController.isActionAt(this.actionAttack, 7) && (lastTarget = this.getLastAttackTarget()) != null && this.m_217066_(lastTarget)) {
            EntityUtils.damageEntity((LivingEntity)this, (Entity)lastTarget, (float)1.0f);
        }
        if (this.actionController.isActionAt(this.actionScream, 10)) {
            this.wakeUpOthers(10);
            this.m_5496_((SoundEvent)TDESoundEvents.PSITTACOSAURUS_SCREAM.get(), 1.0f, this.m_6100_());
        }
    }

    @Override
    public void onActionEnd(ActionState state) {
        super.onActionEnd(state);
    }

    protected SoundEvent m_7515_() {
        if (this.isSleepingOrResting()) {
            return null;
        }
        return (SoundEvent)TDESoundEvents.PSITTACOSAURUS_IDLE.get();
    }

    @Override
    public boolean canBeScared() {
        return !this.m_5803_() && !this.hasBaby();
    }

    @Override
    public int getScaredTicks() {
        return this.scaredTicks;
    }

    @Override
    public void setScaredTicks(int ticks) {
        this.scaredTicks = ticks;
    }

    @Override
    public double m_20204_() {
        return super.m_20204_();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_21239_) {
        return (SoundEvent)TDESoundEvents.PSITTACOSAURUS_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)TDESoundEvents.PSITTACOSAURUS_DEATH.get();
    }

    public int m_8085_() {
        return 40;
    }

    public int m_21529_() {
        return 40;
    }

    public static class Goals {

        public static class CollectCrops<T extends BaseAnimal>
        extends GoalMoveToBlock<T> {
            public CollectCrops(T mob, double speedModifier, int horizontalSearchRange, int verticalSearchRange, int interval, float acceptableDistance) {
                super(mob, speedModifier, horizontalSearchRange, verticalSearchRange, interval, acceptableDistance, (pos, state) -> {
                    if (state.m_60734_() instanceof CropBlock) {
                        return true;
                    }
                    if (state.m_60734_() instanceof SweetBerryBushBlock) {
                        return (Integer)state.m_61143_((Property)SweetBerryBushBlock.f_57244_) > 1;
                    }
                    return false;
                });
            }

            @Override
            public boolean m_8036_() {
                if (this.mob.getSpecificOrderType() == MobOrder.Specific.GATHERING || !this.mob.isTamed()) {
                    return super.m_8036_();
                }
                return false;
            }

            @Override
            public boolean m_8045_() {
                if (this.mob.getSpecificOrderType() == MobOrder.Specific.GATHERING || !this.mob.isTamed()) {
                    return super.m_8045_();
                }
                return false;
            }

            @Override
            public void achieveBlock(BlockPos blockPos) {
                BaseAnimal baseAnimal = this.mob;
                if (baseAnimal instanceof EntityPsittacosaurus) {
                    EntityPsittacosaurus entityPsittacosaurus = (EntityPsittacosaurus)baseAnimal;
                    entityPsittacosaurus.cropPos = blockPos;
                    this.mob.actionController.playAction(entityPsittacosaurus.actionBush);
                }
            }

            public static class Builder
            extends GoalMoveToBlock.Builder {
                @Override
                public CollectCrops create(BaseAnimal animal) {
                    return new CollectCrops<BaseAnimal>(animal, this.speedModifier.getDouble(), this.horizontalDistance.getInt(), this.verticalDistance.getInt(), this.interval.getInt(), this.acceptableDistance.getInt());
                }
            }
        }
    }
}

