/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.entity.ground;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import ru.astemir.astemirlib.common.action.ActionState;
import ru.astemir.astemirlib.common.entity.EntityUtils;
import ru.xishnikus.thedawnera.common.entity.data.GenderType;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseSleepingAnimal;
import ru.xishnikus.thedawnera.common.entity.entity.base.ScaredMob;
import ru.xishnikus.thedawnera.common.entity.properties.MobProperties;
import ru.xishnikus.thedawnera.common.misc.TDESoundEvents;
import ru.xishnikus.thedawnera.common.utils.TDEUtils;

public class EntityStruthiomimus
extends BaseSleepingAnimal<MobProperties>
implements ScaredMob {
    public final ActionState actionAttack;
    public final ActionState actionScream;
    public final ActionState actionEat;
    private int scaredTicks;

    public EntityStruthiomimus(EntityType<? extends BaseSleepingAnimal> type, Level level) {
        super((EntityType<? extends BaseAnimal>)type, level);
        this.actionAttack = this.actionController.getActionByName("attack");
        this.actionScream = this.actionController.getActionByName("scream");
        this.actionEat = this.actionController.getActionByName("eat");
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.scaredTicks > 0) {
            --this.scaredTicks;
        }
    }

    @Override
    public void m_7023_(Vec3 motion) {
        if (this.actionController.is(new ActionState[]{this.actionScream, this.actionEat})) {
            motion = motion.m_82542_(0.0, 1.0, 0.0);
        }
        super.m_7023_(motion);
    }

    @Override
    public void onActionBegin(ActionState state) {
        if (state == this.actionEat) {
            this.m_5496_((SoundEvent)TDESoundEvents.EAT_MEAT.get(), this.m_6121_(), this.m_6100_() * 1.5f);
        }
        if (state == this.actionAttack) {
            this.m_5496_((SoundEvent)TDESoundEvents.STRUTHIOMIMUS_ATTACK.get(), 1.0f, this.m_6100_());
        }
    }

    @Override
    public void onActionTick(ActionState state, int ticks) {
        LivingEntity lastTarget;
        if (this.actionController.isActionAt(this.actionAttack, 10) && (lastTarget = this.getLastAttackTarget()) != null && this.m_217066_(lastTarget)) {
            EntityUtils.damageEntity((LivingEntity)this, (Entity)lastTarget, (float)1.0f);
        }
        if (this.actionController.isActionAt(this.actionDown, 15)) {
            TDEUtils.shakeScreen(this, 14, 20, 2.0);
        }
        if (this.actionController.isActionAt(this.actionScream, 10)) {
            this.wakeUpOthers(20);
            TDEUtils.shakeScreen(this, 8, 150, 1.0);
            this.m_5496_((SoundEvent)TDESoundEvents.STRUTHIOMIMUS_SCREAM.get(), 3.0f, this.m_6100_());
        }
    }

    @Override
    public void onActionEnd(ActionState state) {
        super.onActionEnd(state);
        if (state == this.actionUp && this.getGender() == GenderType.MALE) {
            this.actionController.playAction(this.actionScream);
        }
    }

    protected SoundEvent m_7515_() {
        if (this.isSleepingOrResting()) {
            return null;
        }
        return (SoundEvent)TDESoundEvents.STRUTHIOMIMUS_IDLE.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_21239_) {
        return (SoundEvent)TDESoundEvents.STRUTHIOMIMUS_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)TDESoundEvents.STRUTHIOMIMUS_DEATH.get();
    }

    @Override
    public double m_20204_() {
        return super.m_20204_();
    }

    public int m_8085_() {
        return 40;
    }

    public int m_21529_() {
        return 40;
    }

    @Override
    public boolean canBeScared() {
        return !this.m_5803_() && !this.hasBaby();
    }

    @Override
    public int getScaredTicks() {
        return this.scaredTicks;
    }

    @Override
    public void setScaredTicks(int ticks) {
        this.scaredTicks = ticks;
    }
}

