/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.entity.ground;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import ru.astemir.astemirlib.common.action.ActionState;
import ru.astemir.astemirlib.common.entity.EntityUtils;
import ru.astemir.astemirlib.common.math.AVector3f;
import ru.astemir.astemirlib.common.misc.MiscUtils;
import ru.xishnikus.thedawnera.common.entity.ai.controller.GiantDinoBodyControl;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseRideableAnimal;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseSleepingAnimal;
import ru.xishnikus.thedawnera.common.entity.entity.ground.EntityDeinonychus;
import ru.xishnikus.thedawnera.common.entity.input.InputKey;
import ru.xishnikus.thedawnera.common.entity.input.KeyInputMob;
import ru.xishnikus.thedawnera.common.entity.misc.MobStepHandler;
import ru.xishnikus.thedawnera.common.misc.TDESoundEvents;
import ru.xishnikus.thedawnera.common.utils.TDEUtils;

public class EntityTriceratops
extends BaseRideableAnimal<BaseRideableAnimal.Properties>
implements KeyInputMob {
    private MobStepHandler stepHandler = new MobStepHandler().addListener(0.4f, 0.64f, (livingEntity, stepTick) -> (stepTick == 0 || stepTick == 8) && !this.isSleepingOrResting()).addListener(0.1f, 1.92f, (livingEntity, stepTick) -> (stepTick == 0 || stepTick == 19) && !this.isSleepingOrResting());
    public final ActionState actionAttack = this.actionController.getActionByName("attack");
    public final ActionState actionScream = this.actionController.getActionByName("scream");
    public final ActionState actionEat = this.actionController.getActionByName("eat");

    public EntityTriceratops(EntityType<? extends BaseRideableAnimal> type, Level level) {
        super((EntityType<? extends BaseSleepingAnimal>)type, level);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.stepHandler.tick((LivingEntity)this);
    }

    @Override
    public void m_7023_(Vec3 motion) {
        if (this.actionController.is(new ActionState[]{this.actionAttack, this.actionScream, this.actionEat})) {
            motion = motion.m_82542_(0.0, 1.0, 0.0);
        }
        super.m_7023_(motion);
    }

    @Override
    public void onActionBegin(ActionState state) {
        if (state == this.actionEat) {
            this.m_5496_((SoundEvent)TDESoundEvents.EAT_GRASS.get(), this.m_6121_(), this.m_6100_());
        }
        if (state == this.actionAttack) {
            this.m_5496_((SoundEvent)TDESoundEvents.TRICERATOPS_ATTACK.get(), 1.0f, this.m_6100_());
        }
    }

    @Override
    public void onActionTick(ActionState state, int ticks) {
        if (this.actionController.isActionAt(this.actionAttack, 8)) {
            LivingEntity lastTarget = this.getLastAttackTarget();
            TDEUtils.attackFrontEntities(this, 6.0f);
            if (lastTarget != null && this.m_217066_(lastTarget)) {
                EntityUtils.damageEntity((LivingEntity)this, (Entity)lastTarget, (float)1.5f);
            }
        }
        if (this.actionController.isActionAt(this.actionDown, 15)) {
            TDEUtils.shakeScreen(this, 14, 20, 4.0);
        }
        if (this.actionController.isActionAt(this.actionScream, 10)) {
            this.wakeUpOthers(20);
            TDEUtils.shakeScreen(this, 8, 150, 2.0);
            this.m_5496_((SoundEvent)TDESoundEvents.TRICERATOPS_SCREAM.get(), 2.0f, this.m_6100_());
        }
    }

    @Override
    public void onInputHandle(InputKey inputKey) {
        if (this.tickControlled >= 20 && this.actionController.isNoAction() && !this.isSleepingOrResting()) {
            if (inputKey.is("attack") && this.consumeEnergy(10.0f)) {
                this.actionController.playAction(this.actionAttack);
            }
            if (inputKey.is("roar") && this.consumeEnergy(10.0f)) {
                this.actionController.playAction(this.actionScream);
            }
        }
    }

    @Override
    public void onServerMobStep(float stepPower) {
        if (!this.m_6162_()) {
            MobStepHandler.playStepSound((LivingEntity)this, (SoundEvent)TDESoundEvents.TRICERATOPS_STEP.get());
            if (stepPower == 0.1f) {
                TDEUtils.shakeScreen(this, 6, 20, 3.0);
            }
            if (stepPower == 0.4f) {
                AVector3f dir = EntityUtils.getDirection((Entity)this);
                for (LivingEntity entity : this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82386_((double)(dir.x * 3.5f), 0.0, (double)(dir.z * 3.5f)), MiscUtils.withoutEntity((Entity)this))) {
                    if (!this.m_6779_(entity) || entity instanceof EntityTriceratops) continue;
                    float knockbackResistance = (float)entity.m_21133_(Attributes.f_22278_);
                    entity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)(this.m_21133_(Attributes.f_22281_) / 2.0));
                    entity.m_20334_((double)(dir.x * (1.25f - knockbackResistance)), (double)(1.25f - knockbackResistance), (double)(dir.z * (1.25f - knockbackResistance)));
                    entity.f_19812_ = true;
                }
                TDEUtils.shakeScreen(this, 6, 30, 4.0);
            }
        }
    }

    @Override
    protected BodyRotationControl m_7560_() {
        return new GiantDinoBodyControl((Mob)this);
    }

    @Override
    public double m_6048_() {
        return (double)this.m_20206_() * 0.88;
    }

    @Override
    public float getPassengerEyeScale() {
        if (this.m_20069_()) {
            return 0.65f;
        }
        if (this.actionController.is(this.actionDown)) {
            float p = (float)this.actionController.getTicks() / (float)this.actionDown.getLength();
            return Math.max(0.775f, 1.0f * p);
        }
        if (this.actionController.is(this.actionUp)) {
            float p = (float)this.actionController.getTicks() / (float)this.actionUp.getLength();
            return Math.max(0.775f, 1.0f * (1.0f - p));
        }
        if (this.stateController.is(this.actionRest) || this.stateController.is(this.actionSleep)) {
            return 0.775f;
        }
        return 1.0f;
    }

    public void m_269138_(DamageSource damageSource) {
        super.m_269138_(damageSource);
        this.f_267362_.m_267771_(0.5f);
    }

    @Override
    protected void m_19956_(Entity entity, Entity.MoveFunction moveFunction) {
        if (entity instanceof EntityDeinonychus) {
            super.m_19956_(entity, moveFunction);
            return;
        }
        if (this.m_20363_(entity)) {
            double d0 = this.m_20186_() + this.m_6048_() + entity.m_6049_();
            int i = this.m_20197_().indexOf(entity);
            float f = 0.5f;
            if (i != 0) {
                f = -0.7f;
            }
            Vec3 vec3 = new Vec3(0.0, 0.0, (double)f).m_82524_(-this.f_20883_ * ((float)Math.PI / 180));
            moveFunction.m_20372_(entity, this.m_20185_() + vec3.f_82479_, d0, this.m_20189_() + vec3.f_82481_);
        }
    }

    protected boolean m_7310_(Entity entity) {
        return this.m_20197_().size() <= 2;
    }

    @Override
    public AABB getTreeFallBoundingBox() {
        return this.m_20191_().m_82377_(1.0, 0.0, 1.0);
    }

    @Override
    public boolean canLook() {
        if (this.actionController.is(new ActionState[]{this.actionEat, this.actionScream})) {
            return false;
        }
        return super.canLook();
    }

    protected SoundEvent m_7515_() {
        if (this.isSleepingOrResting()) {
            return null;
        }
        return (SoundEvent)TDESoundEvents.TRICERATOPS_IDLE.get();
    }

    public int m_8100_() {
        return 240;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_21239_) {
        return (SoundEvent)TDESoundEvents.TRICERATOPS_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)TDESoundEvents.TRICERATOPS_DEATH.get();
    }

    public int m_8085_() {
        return 60;
    }

    public int m_21529_() {
        return 10;
    }
}

