/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.entity.ground;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import ru.astemir.astemirlib.client.SmoothValue;
import ru.astemir.astemirlib.common.action.ActionState;
import ru.astemir.astemirlib.common.entity.EntityUtils;
import ru.astemir.astemirlib.common.math.AVector3f;
import ru.astemir.astemirlib.common.math.InterpolationType;
import ru.xishnikus.thedawnera.common.effect.TDEMobEffects;
import ru.xishnikus.thedawnera.common.entity.ai.controller.GiantDinoBodyControl;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseRideableAnimal;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseSleepingAnimal;
import ru.xishnikus.thedawnera.common.entity.entity.ground.EntityDeinonychus;
import ru.xishnikus.thedawnera.common.entity.input.InputKey;
import ru.xishnikus.thedawnera.common.entity.input.KeyInputMob;
import ru.xishnikus.thedawnera.common.entity.misc.MobStepHandler;
import ru.xishnikus.thedawnera.common.entity.misc.RandomTickAction;
import ru.xishnikus.thedawnera.common.entity.properties.misc.RandomSelectAction;
import ru.xishnikus.thedawnera.common.misc.TDESoundEvents;
import ru.xishnikus.thedawnera.common.utils.TDEUtils;

public class EntityTyrannosaurus
extends BaseRideableAnimal<BaseRideableAnimal.Properties>
implements KeyInputMob {
    public SmoothValue<Double> clientNeckRot = SmoothValue.valDouble((InterpolationType)InterpolationType.LINEAR, (double)0.0);
    private RandomTickAction randomRoar = new RandomTickAction("roar", 200, 5.0f, mob -> !this.m_20069_());
    private RandomTickAction randomSniff = new RandomTickAction("sniff", 300, 5.0f, mob -> this.m_5448_() == null && !this.m_20069_() && this.isHungry() && !this.m_6162_());
    private RandomSelectAction inputRandomAttack = new RandomSelectAction().add(50.0f, "attack1").add(50.0f, "attack2").add(30.0f, "attack3");
    public final ActionState actionAttack1;
    public final ActionState actionAttack2;
    public final ActionState actionAttackRam;
    public final ActionState actionAttackGround;
    public final ActionState actionRoar;
    public final ActionState actionEat;
    public final ActionState actionSniff;
    private MobStepHandler stepHandler = new MobStepHandler().addListener(0.5f, 0.8f, (livingEntity, stepTick) -> {
        if (!(stepTick != 6 && stepTick != 15 || this.isSleepingOrResting())) {
            TDEUtils.crackGround((LivingEntity)this, 1, 1, 6, false);
            return true;
        }
        return false;
    }).addListener(0.1f, 2.0f, (livingEntity, stepTick) -> {
        if (!(stepTick != 19 && stepTick != 39 || this.isSleepingOrResting())) {
            TDEUtils.crackGround((LivingEntity)this, 1, 1, 6, false);
            return true;
        }
        return false;
    });

    public EntityTyrannosaurus(EntityType<? extends BaseRideableAnimal> type, Level level) {
        super((EntityType<? extends BaseSleepingAnimal>)type, level);
        this.actionAttack1 = this.actionController.getActionByName("attack1");
        this.actionAttack2 = this.actionController.getActionByName("attack2");
        this.actionAttackRam = this.actionController.getActionByName("attack3");
        this.actionAttackGround = this.actionController.getActionByName("attack4");
        this.actionRoar = this.actionController.getActionByName("roar");
        this.actionEat = this.actionController.getActionByName("eat");
        this.actionSniff = this.actionController.getActionByName("sniff");
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.actionController.isActionAt(this.actionAttackGround, 12)) {
            TDEUtils.affectEntitiesInRadius((LivingEntity)this, this.m_20191_().m_82377_(3.5, 2.0, 3.5), entity -> true, livingEntity -> {
                if (this.m_6779_((LivingEntity)livingEntity)) {
                    if (this.m_6688_() == null && livingEntity instanceof EntityTyrannosaurus) {
                        return;
                    }
                    livingEntity.f_19802_ = 0;
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 80, 1, false, false));
                    livingEntity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 30.0f);
                    livingEntity.m_20334_(0.0, 0.5, 0.0);
                }
            });
            TDEUtils.crackGround((LivingEntity)this, 6, 1, 8, true);
            TDEUtils.shakeScreen(this, 20, 120, 10.0);
        }
        if (!this.isSleepingOrResting()) {
            if (!this.m_217005_()) {
                this.randomRoar.tick(this);
                this.randomSniff.tick(this);
            }
            this.stepHandler.tick((LivingEntity)this);
        }
        this.clientNeckRot.update(0.05f);
    }

    @Override
    public void m_7023_(Vec3 motion) {
        if (this.actionController.is(new ActionState[]{this.actionRoar, this.actionEat, this.actionAttackRam, this.actionAttack1, this.actionAttack2, this.actionAttackGround, this.actionSniff})) {
            motion = motion.m_82542_(0.0, 1.0, 0.0);
        }
        super.m_7023_(motion);
    }

    @Override
    public boolean m_6469_(DamageSource damageSource, float damage) {
        if (this.actionController.is(this.actionRoar)) {
            this.actionController.setNoState();
        }
        return super.m_6469_(damageSource, damage);
    }

    @Override
    public void onInputHandle(InputKey inputKey) {
        if (this.tickControlled >= 20 && this.actionController.isNoAction() && !this.isSleepingOrResting() && !this.m_20069_()) {
            if (inputKey.is("attack") && this.consumeEnergy(10.0f)) {
                this.inputRandomAttack.playRandom(this);
            }
            if (inputKey.is("roar") && this.consumeEnergy(20.0f)) {
                this.actionController.playAction(this.actionRoar);
            }
            if (inputKey.is("attack_ground") && this.consumeEnergy(50.0f)) {
                this.actionController.playAction(this.actionAttackGround);
            }
        }
    }

    @Override
    public void onActionBegin(ActionState state) {
        if (state == this.actionEat) {
            this.m_5496_((SoundEvent)TDESoundEvents.EAT_MEAT.get(), this.m_6121_(), this.m_6100_() * 0.7f);
        }
        if (state == this.actionStartSleeping) {
            this.m_216990_((SoundEvent)TDESoundEvents.TYRANNOSAURUS_YAWN.get());
        }
        if (state == this.actionAttack1 || state == this.actionAttack2) {
            this.m_5496_((SoundEvent)TDESoundEvents.TYRANNOSAURUS_ATTACK.get(), 1.0f, this.m_6100_());
        }
        if (state == this.actionAttackRam) {
            this.m_5496_((SoundEvent)TDESoundEvents.TYRANNOSAURUS_RAM.get(), 1.0f, this.m_6100_());
        }
    }

    @Override
    public void onActionTick(ActionState state, int ticks) {
        LivingEntity lastTarget;
        if (this.actionController.isActionAt(this.actionWakeUp, 20)) {
            this.m_5496_((SoundEvent)TDESoundEvents.TYRANNOSAURUS_SNIFF.get(), 1.0f, this.m_6100_() * 0.65f);
        }
        if (this.actionController.isActionAt(this.actionSniff, 10)) {
            this.m_5496_((SoundEvent)TDESoundEvents.TYRANNOSAURUS_SNIFF.get(), 1.0f, this.m_6100_() * 0.65f);
        }
        if (this.actionController.isActionAt(this.actionAttackGround, 5)) {
            MobStepHandler.playStepSound((LivingEntity)this, (SoundEvent)TDESoundEvents.TYRANNOSAURUS_ATTACK_GROUND.get());
        }
        if (this.actionController.isActionAt(this.actionAttackRam, 7)) {
            lastTarget = this.getLastAttackTarget();
            AVector3f dir = EntityUtils.getDirection((Entity)this);
            TDEUtils.attackFrontEntities(this, 15.0f);
            if (lastTarget != null && this.m_217066_(lastTarget)) {
                float damageMultiplier = lastTarget instanceof Player ? 1.15f : 2.0f;
                EntityUtils.damageEntity((LivingEntity)this, (Entity)lastTarget, (float)damageMultiplier, (boolean)true);
                lastTarget.m_20334_((double)dir.x, 0.5, (double)dir.y);
            }
        }
        if (this.actionController.isActionAt(this.actionAttack1, 10) || this.actionController.isActionAt(this.actionAttack2, 12)) {
            lastTarget = this.getLastAttackTarget();
            TDEUtils.attackFrontEntities(this, 15.0f);
            if (lastTarget != null && this.m_217066_(lastTarget)) {
                float damageMultiplier = lastTarget instanceof Player ? 1.25f : 1.55f;
                EntityUtils.damageEntity((LivingEntity)this, (Entity)this.getLastAttackTarget(), (float)damageMultiplier, (boolean)true);
                if (!this.m_6162_()) {
                    this.getLastAttackTarget().m_7292_(new MobEffectInstance((MobEffect)TDEMobEffects.FRACTURE.get(), 180, 1, true, false));
                }
            }
        }
        if (this.actionController.isActionAt(this.actionDown, 15)) {
            TDEUtils.shakeScreen(this, 14, 40, 5.0);
        }
        if (this.actionController.isActionAt(this.actionRoar, 15)) {
            this.wakeUpOthers(20);
            TDEUtils.shakeScreen(this, 40, 330, 15.0);
            this.m_5496_((SoundEvent)TDESoundEvents.TYRANNOSAURUS_ROAR.get(), 3.0f, this.m_6100_());
        }
    }

    @Override
    public void onServerMobStep(float stepPower) {
        if (!this.m_6162_()) {
            for (LivingEntity livingEntity : this.m_9236_().m_45976_(LivingEntity.class, new AABB(this.m_20191_().f_82288_, this.m_20191_().f_82289_, this.m_20191_().f_82290_, this.m_20191_().f_82291_, this.m_20191_().f_82289_ + 1.0, this.m_20191_().f_82293_).m_82400_(0.5))) {
                if (!this.m_6779_(livingEntity) || !(livingEntity.m_20206_() / this.m_20206_() < 0.5f) || livingEntity.m_6095_() == this.m_6095_()) continue;
                livingEntity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_) * 0.45f);
            }
            TDEUtils.shakeScreen(this, 15, 40, 5.0);
            MobStepHandler.playStepSound((LivingEntity)this, (SoundEvent)TDESoundEvents.TYRANNOSAURUS_STEP.get());
        }
    }

    public void m_269138_(DamageSource damageSource) {
        super.m_269138_(damageSource);
        this.f_267362_.m_267771_(0.25f);
    }

    @Override
    protected BodyRotationControl m_7560_() {
        return new GiantDinoBodyControl((Mob)this);
    }

    @Override
    public boolean canLook() {
        if (this.actionController.is(this.actionRoar)) {
            return false;
        }
        return super.canLook();
    }

    @Override
    public AABB getTreeFallBoundingBox() {
        return this.m_20191_().m_82377_(3.0, 0.0, 3.0);
    }

    @Override
    public float getPassengerEyeScale() {
        if (this.m_9236_().m_6425_(this.m_20183_().m_7495_()).m_192917_((Fluid)Fluids.f_76193_)) {
            return -0.25f;
        }
        if (this.actionController.is(this.actionDown)) {
            float p = (float)this.actionController.getTicks() / (float)this.actionDown.getLength();
            return Math.max(0.085f, 1.0f * p);
        }
        if (this.actionController.is(this.actionUp)) {
            float p = (float)this.actionController.getTicks() / (float)this.actionUp.getLength();
            return Math.max(0.085f, 1.0f * (1.0f - p));
        }
        if (this.stateController.is(this.actionRest) || this.stateController.is(this.actionSleep)) {
            return 0.085f;
        }
        return 1.0f;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        if (!this.actionController.isNoAction()) {
            return null;
        }
        if (this.m_5803_()) {
            return (SoundEvent)TDESoundEvents.TYRANNOSAURUS_SLEEP.get();
        }
        return (SoundEvent)TDESoundEvents.TYRANNOSAURUS_IDLE.get();
    }

    protected boolean m_7310_(Entity entity) {
        return this.m_20197_().size() <= 2;
    }

    public int m_8100_() {
        return 240;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)TDESoundEvents.TYRANNOSAURUS_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)TDESoundEvents.TYRANNOSAURUS_DEATH.get();
    }

    public int m_8085_() {
        return 40;
    }

    public int m_21529_() {
        return 5;
    }

    @Override
    public float m_6134_() {
        return this.m_6162_() ? 0.35f : 1.0f;
    }

    @Override
    protected void m_19956_(Entity entity, Entity.MoveFunction moveFunction) {
        if (entity instanceof EntityDeinonychus) {
            super.m_19956_(entity, moveFunction);
            return;
        }
        if (this.m_20363_(entity)) {
            double d0 = this.m_20186_() + this.m_6048_() + entity.m_6049_();
            int i = this.m_20197_().indexOf(entity);
            float f = 0.7f;
            if (i != 0) {
                f = -0.7f;
            }
            Vec3 vec3 = new Vec3(0.0, 0.0, (double)f).m_82524_(-this.f_20883_ * ((float)Math.PI / 180));
            moveFunction.m_20372_(entity, this.m_20185_() + vec3.f_82479_, d0, this.m_20189_() + vec3.f_82481_);
        }
    }

    public AABB m_6921_() {
        return this.m_20191_().m_82400_(1.5);
    }
}

