/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.entity.misc;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import ru.astemir.astemirlib.client.SmoothValue;
import ru.astemir.astemirlib.common.handler.EntityEventMap;
import ru.astemir.astemirlib.common.handler.EventEntity;
import ru.astemir.astemirlib.common.handler.LevelEvent;
import ru.astemir.astemirlib.common.math.AVector3f;
import ru.astemir.astemirlib.common.math.InterpolationType;
import ru.astemir.astemirlib.common.math.MathUtils;
import ru.astemir.astemirlib.common.math.RandomUtils;
import ru.astemir.astemirlib.common.network.PacketArgument;
import ru.xishnikus.thedawnera.common.TDELevelEvents;
import ru.xishnikus.thedawnera.common.entity.TDEEntities;
import ru.xishnikus.thedawnera.common.io.config.TDECommonConfig;
import ru.xishnikus.thedawnera.common.misc.TDESoundEvents;
import ru.xishnikus.thedawnera.common.utils.TreeDetector;

public class EntityFallingTree
extends Entity
implements EventEntity {
    private static final LevelEvent EVENT_ADD_NODE = new LevelEvent();
    private static final EntityEventMap<EntityFallingTree> clientEvents = new EntityEventMap().registerEvent(EVENT_ADD_NODE, (entity, blockPos, level, packetArguments) -> {
        Vec3i offset = AVector3f.from((Vec3)packetArguments[0].asVec3()).toVec3i();
        BlockState blockState = NbtUtils.m_247651_((HolderGetter)level.m_246945_(Registries.f_256747_), (CompoundTag)packetArguments[1].asNBT());
        entity.addNode(new Node(offset, blockState));
    });
    private List<Node> nodes = new ArrayList<Node>();
    private float maxSize = 0.5f;
    public SmoothValue<Double> treeFallDegree = SmoothValue.valDouble((InterpolationType)InterpolationType.LINEAR, (double)0.0).setTo((Object)90.0);

    public EntityFallingTree(EntityType<?> type, Level level) {
        super(type, level);
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag compoundTag) {
        if (compoundTag.m_128441_("Nodes")) {
            ListTag nodesNbt = compoundTag.m_128437_("Nodes", 10);
            for (Tag tag : nodesNbt) {
                CompoundTag nodeNbt = (CompoundTag)tag;
                ListTag offsetList = nodeNbt.m_128437_("Offset", 3);
                Vec3i offset = new Vec3i(offsetList.m_128763_(0), offsetList.m_128763_(1), offsetList.m_128763_(2));
                BlockState blockState = NbtUtils.m_247651_((HolderGetter)this.m_9236_().m_246945_(Registries.f_256747_), (CompoundTag)nodeNbt.m_128469_("BlockState"));
                Node node = new Node(offset, blockState);
                this.addNode(node);
                this.updateNodeClient(node);
            }
        }
    }

    protected void m_7380_(CompoundTag compoundTag) {
        ListTag nodesNbt = new ListTag();
        for (Node node : this.nodes) {
            ListTag posList = new ListTag();
            CompoundTag nodeNbt = new CompoundTag();
            posList.add((Object)IntTag.m_128679_((int)node.offset.m_123341_()));
            posList.add((Object)IntTag.m_128679_((int)node.offset.m_123342_()));
            posList.add((Object)IntTag.m_128679_((int)node.offset.m_123343_()));
            nodeNbt.m_128365_("Offset", (Tag)posList);
            nodeNbt.m_128365_("BlockState", (Tag)NbtUtils.m_129202_((BlockState)node.blockState));
            nodesNbt.add((Object)nodeNbt);
        }
        compoundTag.m_128365_("Nodes", (Tag)nodesNbt);
    }

    public void m_8119_() {
        super.m_8119_();
        this.treeFallDegree.update(0.1f);
        if ((Double)this.treeFallDegree.get(0.1f) > 75.0) {
            BlockPos blockPos = this.m_20183_();
            for (Node node : this.getNodes()) {
                Vector3f vec3 = new Vector3f((float)node.getOffset().m_123341_(), (float)node.getOffset().m_123342_(), (float)node.getOffset().m_123343_());
                vec3.rotateX(MathUtils.rad((float)90.0f));
                vec3.rotateY(MathUtils.rad((float)this.m_146908_()));
                BlockPos offsetBlockPos = blockPos.m_7918_((int)Math.floor(vec3.x), (int)Math.floor(vec3.y), (int)Math.floor(vec3.z));
                if (!this.m_9236_().m_8055_(offsetBlockPos).m_247087_()) continue;
                if (node.blockState.m_204336_(BlockTags.f_13106_)) {
                    float yRot = this.m_146908_();
                    Direction.Axis axis = yRot >= 45.0f && yRot <= 135.0f || yRot >= -135.0f && yRot <= -45.0f ? Direction.Axis.X : Direction.Axis.Z;
                    BlockPos pos = TreeDetector.getNearestGround(this.m_9236_(), offsetBlockPos);
                    if (node.blockState.m_61138_((Property)RotatedPillarBlock.f_55923_)) {
                        this.m_9236_().m_7731_(pos, (BlockState)node.blockState.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)axis), 11);
                        continue;
                    }
                    this.m_9236_().m_7731_(pos, node.blockState, 11);
                    continue;
                }
                BlockPos pos = TreeDetector.getNearestGround(this.m_9236_(), offsetBlockPos);
                this.m_9236_().m_7731_(pos, node.blockState, 11);
            }
            for (Player nearbyPlayer : this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82400_(3.0))) {
                TDELevelEvents.shakeScreen(nearbyPlayer, this.m_9236_(), this.m_20183_(), 30, 3.0);
            }
            this.m_6074_();
        }
    }

    public void addNode(Node node) {
        this.nodes.add(node);
        int maxOffset = 0;
        for (Node child : this.nodes) {
            if (Math.abs(child.getOffset().m_123341_()) > maxOffset) {
                maxOffset = Math.abs(child.getOffset().m_123341_());
            }
            if (Math.abs(child.getOffset().m_123342_()) > maxOffset) {
                maxOffset = Math.abs(child.getOffset().m_123342_());
            }
            if (Math.abs(child.getOffset().m_123343_()) <= maxOffset) continue;
            maxOffset = Math.abs(child.getOffset().m_123343_());
        }
        this.maxSize = maxOffset;
        this.m_6210_();
    }

    public void updateNodeClient(Node node) {
        if (!this.m_9236_().f_46443_) {
            Vec3i offset = node.getOffset();
            BlockState blockState = node.blockState;
            this.playClientEvent(EVENT_ADD_NODE, new PacketArgument[]{PacketArgument.valVec3((Vec3)new Vec3((double)offset.m_123341_(), (double)offset.m_123342_(), (double)offset.m_123343_())), PacketArgument.valNbt((CompoundTag)NbtUtils.m_129202_((BlockState)blockState))});
        }
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public EntityDimensions m_6972_(Pose pose) {
        return EntityDimensions.m_20395_((float)this.maxSize, (float)this.maxSize);
    }

    public static boolean createFallingTree(Level level, BlockPos logPos, Vec3 fallFromPos, int blockCountLimit) {
        if (((Boolean)TDECommonConfig.FALLING_TREES.get()).booleanValue()) {
            BlockPos origin = TreeDetector.bottomOfTree(level, logPos);
            if (TreeDetector.isNormalRotatedLog(level, origin)) {
                HashSet<BlockPos> logBlocks = new HashSet<BlockPos>();
                HashSet<BlockPos> leavesBlocks = new HashSet<BlockPos>();
                HashSet<BlockPos> loopedLogBlocks = new HashSet<BlockPos>();
                TreeDetector.searchForLogs((LevelAccessor)level, logPos, logBlocks, loopedLogBlocks, leavesBlocks);
                if (logBlocks.size() >= 3 && logBlocks.size() < blockCountLimit && leavesBlocks.size() >= 3) {
                    HashSet<BlockPos> gathered = new HashSet<BlockPos>();
                    gathered.addAll(logBlocks);
                    gathered.addAll(leavesBlocks);
                    EntityFallingTree fallingTree = (EntityFallingTree)((EntityType)TDEEntities.FALLING_TREE.get()).m_20615_(level);
                    Vec3 vec3 = Vec3.m_82512_((Vec3i)origin).m_82546_(fallFromPos);
                    float f = -((float)Mth.m_14136_((double)(-vec3.f_82479_), (double)vec3.f_82481_)) * 180.0f / (float)Math.PI;
                    fallingTree.m_146922_(f);
                    fallingTree.m_6034_((double)origin.m_123341_() + 0.5, origin.m_123342_(), (double)origin.m_123343_() + 0.5);
                    level.m_7967_((Entity)fallingTree);
                    level.m_6263_(null, (double)origin.m_123341_(), (double)origin.m_123342_(), (double)origin.m_123343_(), (SoundEvent)TDESoundEvents.TREE_FALL.get(), SoundSource.BLOCKS, 1.0f, RandomUtils.randomFloat((float)0.9f, (float)1.1f));
                    for (BlockPos blockPos : gathered) {
                        Vec3i offset = new Vec3i(blockPos.m_123341_() - origin.m_123341_(), blockPos.m_123342_() - origin.m_123342_(), blockPos.m_123343_() - origin.m_123343_());
                        BlockState blockState = level.m_8055_(blockPos);
                        Node node = new Node(offset, blockState);
                        fallingTree.addNode(node);
                        fallingTree.updateNodeClient(node);
                        level.m_7471_(blockPos, false);
                    }
                    return gathered.size() > 0;
                }
            }
            return false;
        }
        return false;
    }

    public EntityEventMap getClientLevelEventMap() {
        return clientEvents;
    }

    public static class Node {
        private Vec3i offset;
        private BlockState blockState;

        public Node(Vec3i offset, BlockState blockState) {
            this.offset = offset;
            this.blockState = blockState;
        }

        public Vec3i getOffset() {
            return this.offset;
        }

        public BlockState getBlockState() {
            return this.blockState;
        }
    }
}

