/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.entity.projectile;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import ru.astemir.astemirlib.client.bedrock.animation.Animated;
import ru.astemir.astemirlib.client.bedrock.animation.data.Animator;
import ru.astemir.astemirlib.client.bedrock.model.BedrockModel;
import ru.astemir.astemirlib.common.math.RandomUtils;
import ru.xishnikus.thedawnera.common.enchantment.TDEEnchantments;
import ru.xishnikus.thedawnera.common.entity.TDEEntities;
import ru.xishnikus.thedawnera.common.entity.entity.projectile.BaseArrowLike;
import ru.xishnikus.thedawnera.common.item.TDEItems;
import ru.xishnikus.thedawnera.common.misc.TDEDamageTypes;
import ru.xishnikus.thedawnera.common.misc.TDESoundEvents;

public class EntityThrownDiplorang
extends BaseArrowLike
implements Animated {
    private static final EntityDataAccessor<Boolean> HAS_FOIL = SynchedEntityData.m_135353_(EntityThrownDiplorang.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SHOULD_RETURN = SynchedEntityData.m_135353_(EntityThrownDiplorang.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DEVOTED = SynchedEntityData.m_135353_(EntityThrownDiplorang.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private ItemStack itemStack = new ItemStack((ItemLike)TDEItems.DIPLORANG.get());
    private int airCutterLevel = 0;
    @OnlyIn(value=Dist.CLIENT)
    private Animator animator;
    private Vec3 originalPos;

    public EntityThrownDiplorang(EntityType<? extends BaseArrowLike> entityType, Level level) {
        super(entityType, level);
    }

    public EntityThrownDiplorang(Level level, LivingEntity owner, ItemStack itemStack) {
        super((EntityType<? extends BaseArrowLike>)((EntityType)TDEEntities.DIPLORANG.get()), level);
        this.m_5602_((Entity)owner);
        this.m_6034_(owner.m_20185_(), owner.m_20188_() - 0.25, owner.m_20189_());
        this.originalPos = this.m_20182_();
        this.itemStack = itemStack;
        this.f_19804_.m_135381_(HAS_FOIL, (Object)itemStack.m_41790_());
        this.f_19804_.m_135381_(SHOULD_RETURN, (Object)false);
        this.f_19804_.m_135381_(DEVOTED, (Object)(EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)TDEEnchantments.DEVOTED.get()), (ItemStack)itemStack) > 0 ? 1 : 0));
        this.airCutterLevel = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)TDEEnchantments.AIR_CUTTER.get()), (ItemStack)itemStack);
        this.setPierceLevel((byte)EnchantmentHelper.getTagEnchantmentLevel((Enchantment)((Enchantment)TDEEnchantments.PENETRATION.get()), (ItemStack)itemStack));
        if (owner instanceof Player) {
            this.pickup = BaseArrowLike.Pickup.ALLOWED;
        }
    }

    public void m_37251_(Entity entity, float yRot, float xRot, float p_37255_, float p_37256_, float p_37257_) {
        float f = -Mth.m_14031_((float)((xRot += RandomUtils.randomFloat((float)-5.0f, (float)5.0f)) * ((float)Math.PI / 180))) * Mth.m_14089_((float)(yRot * ((float)Math.PI / 180)));
        float f1 = -Mth.m_14031_((float)((yRot + p_37255_) * ((float)Math.PI / 180)));
        float f2 = Mth.m_14089_((float)(xRot * ((float)Math.PI / 180))) * Mth.m_14089_((float)(yRot * ((float)Math.PI / 180)));
        this.m_6686_(f, f1, f2, p_37256_, p_37257_);
        Vec3 vec3 = entity.m_20184_();
        this.m_20256_(this.m_20184_().m_82520_(vec3.f_82479_, entity.m_20096_() ? 0.0 : vec3.f_82480_, vec3.f_82481_));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HAS_FOIL, (Object)false);
        this.f_19804_.m_135372_(SHOULD_RETURN, (Object)false);
        this.f_19804_.m_135372_(DEVOTED, (Object)false);
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (compoundTag.m_128425_("ItemStack", 10)) {
            this.itemStack = ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("ItemStack"));
        }
        this.airCutterLevel = compoundTag.m_128451_("AirCutterLevel");
        this.f_19804_.m_135381_(DEVOTED, (Object)compoundTag.m_128471_("IsDevoted"));
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128365_("ItemStack", (Tag)this.itemStack.m_41739_(new CompoundTag()));
        compoundTag.m_128379_("IsDevoted", ((Boolean)this.f_19804_.m_135370_(DEVOTED)).booleanValue());
        compoundTag.m_128405_("AirCutterLevel", this.airCutterLevel);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        Player owner = (Player)this.m_19749_();
        if (owner != null) {
            boolean isDevoted = (Boolean)this.f_19804_.m_135370_(DEVOTED);
            if (this.isFlying() && this.f_19797_ % 5 == 0) {
                this.m_5496_((SoundEvent)TDESoundEvents.BOOMERANG_THROW.get(), 1.0f, RandomUtils.randomFloat((float)0.9f, (float)1.1f));
            }
            if (!this.inGround && !this.m_20096_()) {
                if (this.f_19797_ > 10 + this.airCutterLevel * 5 && !this.isShouldReturn()) {
                    this.setShouldReturn(true);
                }
                if (this.isShouldReturn()) {
                    if (isDevoted) {
                        Vec3 vec3 = owner.m_20182_().m_82520_(0.0, (double)(owner.m_20206_() / 2.0f), 0.0).m_82546_(this.m_20182_());
                        this.f_19812_ = true;
                        this.m_20256_(vec3.m_82541_().m_82490_(0.5));
                    }
                    if (this.m_20275_(owner.m_20185_(), owner.m_20186_() + (double)(owner.m_20206_() / 2.0f), owner.m_20189_()) < (double)(this.m_20205_() * 2.0f * this.m_20205_() * 2.0f + owner.m_20205_())) {
                        if (!owner.m_21224_()) {
                            this.tryPickup(owner);
                            this.m_146870_();
                        } else {
                            this.startFalling();
                        }
                    }
                }
            } else if (isDevoted && this.inGround) {
                Vec3 vec3 = owner.m_146892_().m_82546_(this.m_20182_()).m_82541_().m_82490_(0.5);
                this.m_20343_(this.m_20185_() + vec3.f_82479_, this.m_20186_() + (double)0.1f + vec3.f_82480_, this.m_20189_() + vec3.f_82481_);
            }
        }
    }

    @Override
    @Nullable
    protected EntityHitResult findHitEntity(Vec3 pos, Vec3 hitPos) {
        return super.findHitEntity(pos, hitPos);
    }

    @Override
    protected void m_5790_(EntityHitResult entityHitResult) {
        DamageSource damagesource;
        Entity entity = entityHitResult.m_82443_();
        Entity owner = this.m_19749_();
        float f = (float)this.m_20184_().m_82553_();
        int i = Mth.m_14165_((double)Mth.m_14008_((double)((double)f * this.baseDamage), (double)0.0, (double)2.147483647E9));
        if (this.getPierceLevel() > 0) {
            if (this.piercingIgnoreEntityIds == null) {
                this.piercingIgnoreEntityIds = new IntOpenHashSet(5);
            }
            if (this.piercedAndKilledEntities == null) {
                this.piercedAndKilledEntities = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.piercingIgnoreEntityIds.size() >= this.getPierceLevel()) {
                this.setShouldReturn(true);
                return;
            }
            this.piercingIgnoreEntityIds.add(entity.m_19879_());
        }
        if (owner == null) {
            damagesource = this.getDamageSource((Entity)this, (Entity)this);
        } else {
            damagesource = this.getDamageSource((Entity)this, owner);
            if (owner instanceof LivingEntity) {
                ((LivingEntity)owner).m_21335_(entity);
            }
        }
        if (entity instanceof EnderMan) {
            damagesource = this.m_269291_().m_269390_((Entity)this, owner);
        }
        int k = entity.m_20094_();
        if (this.m_6060_()) {
            entity.m_20254_(5);
        }
        if (entity.m_6469_(damagesource, (float)i)) {
            if (entity.m_6095_() == EntityType.f_20566_) {
                this.setShouldReturn(true);
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                if (this.knockback > 0) {
                    double d0 = Math.max(0.0, 1.0 - livingentity.m_21133_(Attributes.f_22278_));
                    Vec3 vec3 = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)this.knockback * 0.6 * d0);
                    if (vec3.m_82556_() > 0.0) {
                        livingentity.m_5997_(vec3.f_82479_, 0.1, vec3.f_82481_);
                    }
                }
                if (!this.m_9236_().f_46443_ && owner instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)livingentity, (Entity)owner);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)owner), (Entity)livingentity);
                }
                this.doPostHurtEffects(livingentity);
                if (!entity.m_6084_() && this.piercedAndKilledEntities != null) {
                    this.piercedAndKilledEntities.add(livingentity);
                }
            }
            this.m_5496_(this.soundEvent, 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
            if (this.getPierceLevel() <= 0) {
                this.setShouldReturn(true);
            }
        } else {
            entity.m_7311_(k);
            this.m_20256_(this.m_20184_().m_82490_(-0.1));
            this.m_146922_(this.m_146908_() + 180.0f);
            this.f_19859_ += 180.0f;
            if (!this.m_9236_().f_46443_ && this.m_20184_().m_82556_() < 1.0E-7) {
                if (this.pickup == BaseArrowLike.Pickup.ALLOWED) {
                    this.m_5552_(this.getPickupItem(), 0.1f);
                }
                this.m_146870_();
            }
        }
    }

    @Override
    protected void m_8060_(BlockHitResult blockHitResult) {
        this.lastState = this.m_9236_().m_8055_(blockHitResult.m_82425_());
        Vec3 vec3 = blockHitResult.m_82450_().m_82492_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.m_20256_(vec3);
        Vec3 vec31 = vec3.m_82541_().m_82490_((double)0.05f);
        this.m_20343_(this.m_20185_() - vec31.f_82479_, this.m_20186_() - vec31.f_82480_, this.m_20189_() - vec31.f_82481_);
        this.m_5496_(this.getHitGroundSoundEvent(), 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
        this.inGround = true;
        this.setPierceLevel((byte)0);
        this.setSoundEvent((SoundEvent)TDESoundEvents.BOOMERANG_GROUND_IMPACT.get());
        this.setShotFromCrossbow(false);
        this.resetPiercedEntities();
    }

    @Override
    protected boolean tryPickup(Player player) {
        return super.tryPickup(player) || this.isNoPhysics() && this.m_150171_((Entity)player) && player.m_150109_().m_36054_(this.getPickupItem());
    }

    @Override
    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return (SoundEvent)TDESoundEvents.BOOMERANG_GROUND_IMPACT.get();
    }

    @Override
    public void m_6123_(Player player) {
        if (this.m_150171_((Entity)player) || this.m_19749_() == null) {
            super.m_6123_(player);
        }
    }

    @Override
    public void tickDespawn() {
        if (this.pickup != BaseArrowLike.Pickup.ALLOWED) {
            super.tickDespawn();
        }
    }

    public void setShouldReturn(boolean value) {
        Vec3 vec3;
        this.f_19804_.m_135381_(SHOULD_RETURN, (Object)value);
        if (!((Boolean)this.f_19804_.m_135370_(DEVOTED)).booleanValue() && this.originalPos != null && (vec3 = this.originalPos.m_82546_(this.m_20182_())) != null) {
            this.f_19812_ = true;
            this.m_20256_(vec3.m_82541_().m_82490_(0.5));
        }
        if (value && this.piercingIgnoreEntityIds != null) {
            this.piercingIgnoreEntityIds.clear();
        }
    }

    public boolean isShouldReturn() {
        return (Boolean)this.f_19804_.m_135370_(SHOULD_RETURN);
    }

    public boolean isFlying() {
        return !this.inGround && !this.m_20096_() && !this.isInFluidType();
    }

    @Override
    protected float getWaterInertia() {
        return 0.3f;
    }

    @Override
    public float getGravityModifier() {
        return 0.0075f;
    }

    public boolean m_6000_(double x, double y, double z) {
        return true;
    }

    @Override
    protected ItemStack getPickupItem() {
        return this.itemStack;
    }

    @Override
    protected DamageSource getDamageSource(Entity entity, Entity entity2) {
        return TDEDamageTypes.causeBoomerangDamage(this.m_9236_().m_9598_(), entity, entity2);
    }

    public boolean isFoil() {
        return (Boolean)this.f_19804_.m_135370_(HAS_FOIL);
    }

    public Animator getOrCreateAnimator(BedrockModel bedrockModel) {
        if (this.animator == null) {
            this.animator = new Animator(bedrockModel).normalizationSpeed(5.0f);
        }
        return this.animator;
    }
}

