/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.entity.water;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.Nullable;
import ru.astemir.astemirlib.client.SmoothValue;
import ru.astemir.astemirlib.common.action.ActionState;
import ru.astemir.astemirlib.common.entity.EntityUtils;
import ru.astemir.astemirlib.common.math.Color;
import ru.astemir.astemirlib.common.math.InterpolationType;
import ru.astemir.astemirlib.common.math.RandomUtils;
import ru.xishnikus.thedawnera.common.effect.TDEMobEffects;
import ru.xishnikus.thedawnera.common.entity.ai.controller.AmphibiousMobMoveController;
import ru.xishnikus.thedawnera.common.entity.ai.controller.WaterMobLookControl;
import ru.xishnikus.thedawnera.common.entity.ai.goal.move.GoalMoveToBlock;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseWaterAnimal;
import ru.xishnikus.thedawnera.common.entity.properties.MobProperties;
import ru.xishnikus.thedawnera.common.item.TDEItems;
import ru.xishnikus.thedawnera.common.misc.TDESoundEvents;
import ru.xishnikus.thedawnera.common.particle.BloodParticleOptions;

public class EntityDiplocaulus
extends BaseWaterAnimal<MobProperties>
implements Bucketable {
    private static final EntityDataAccessor<Byte> MAD = SynchedEntityData.m_135353_(EntityDiplocaulus.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(EntityDiplocaulus.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public SmoothValue<Double> madness = SmoothValue.valDouble((InterpolationType)InterpolationType.CATMULLROM, (double)0.0);
    private static final EntityDataAccessor<Integer> MOISTNESS_LEVEL = SynchedEntityData.m_135353_(EntityDiplocaulus.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public ActionState actionAttack;
    public ActionState actionAttackInWater;
    public ActionState actionEat;
    public ActionState actionEatInWater;
    public ActionState actionScream;

    public EntityDiplocaulus(EntityType<? extends BaseAnimal> type, Level level) {
        super(type, level);
        this.f_21365_ = new LookController(this, 40);
        this.actionAttack = this.actionController.getActionByName("attack1");
        this.actionAttackInWater = this.actionController.getActionByName("attack2");
        this.actionEat = this.actionController.getActionByName("eat1");
        this.actionEatInWater = this.actionController.getActionByName("eat2");
        this.actionScream = this.actionController.getActionByName("scream");
        this.f_21342_ = new AmphibiousMobMoveController((PathfinderMob)this, 0.3f, 3.0f, 1.25f, 0.9f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new Goals.ReturnToWater(this, 0.6f));
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, p -> this.m_21023_((MobEffect)TDEMobEffects.AMPHIBIAN_MADNESS.get())));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Villager.class, true, p -> this.m_21023_((MobEffect)TDEMobEffects.AMPHIBIAN_MADNESS.get())));
    }

    @Override
    public InteractionResult m_6071_(Player p_149155_, InteractionHand p_149156_) {
        return Bucketable.m_148828_((Player)p_149155_, (InteractionHand)p_149156_, (LivingEntity)this).orElse(super.m_6071_(p_149155_, p_149156_));
    }

    @Override
    protected PathNavigation m_6037_(Level level) {
        return new AmphibiousPathNavigation((Mob)this, level);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficultyInstance, MobSpawnType type, @Nullable SpawnGroupData groupData, @Nullable CompoundTag compoundTag) {
        this.m_20301_(this.m_6062_());
        return super.m_6518_(level, difficultyInstance, type, groupData, compoundTag);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MOISTNESS_LEVEL, (Object)2000);
        this.f_19804_.m_135372_(MAD, (Object)0);
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("Moistness", this.getMoistnessLevel());
        compoundTag.m_128379_("IsMad", this.isMad());
        compoundTag.m_128379_("FromBucket", this.m_27487_());
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (compoundTag.m_128441_("Moistness")) {
            this.setMoisntessLevel(compoundTag.m_128451_("Moistness"));
        }
        if (compoundTag.m_128441_("IsMad")) {
            this.setMad(compoundTag.m_128471_("IsMad"));
        }
        if (compoundTag.m_128441_("FromBucket")) {
            this.m_27497_(compoundTag.m_128471_("FromBucket"));
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        boolean wasMad = this.isMad();
        if (this.f_19797_ % 40 == 0 && this.getMoistnessLevel() > 500 && this.m_20146_() > 200) {
            this.m_5634_(1.0f);
        }
        if (!this.m_21023_((MobEffect)TDEMobEffects.AMPHIBIAN_MADNESS.get())) {
            if (wasMad && !this.m_9236_().f_46443_) {
                this.setMad(false);
                this.m_6710_(null);
            }
            if (this.m_21525_()) {
                this.m_20301_(this.m_6062_());
            } else if (this.m_20071_()) {
                this.setMoisntessLevel(2000);
            } else {
                this.setMoisntessLevel(this.getMoistnessLevel() - 1);
                if (this.getMoistnessLevel() <= 0) {
                    this.m_6469_(this.m_269291_().m_269483_(), 1.0f);
                }
            }
        } else if (!wasMad && !this.m_9236_().f_46443_) {
            this.setMad(true);
        }
        if (this.isMad()) {
            if (this.f_19797_ % 2 == 0) {
                this.m_9236_().m_7106_((ParticleOptions)new BloodParticleOptions(new Color(0.5f, 0.0f, 0.0f, 1.0f).toVec3().m_252839_(), 1.0f), this.m_20208_(0.5), this.m_20186_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
            this.madness.setTo((Object)1.0);
        } else {
            this.madness.setTo((Object)0.0);
        }
        this.madness.update(0.1f);
    }

    @Override
    public void onActionBegin(ActionState state) {
        if (state == this.actionEat || state == this.actionEatInWater) {
            this.m_5496_((SoundEvent)TDESoundEvents.EAT_SHORT.get(), 1.0f, this.m_6100_() * 1.5f);
        }
        if (state == this.actionScream) {
            this.m_5496_((SoundEvent)TDESoundEvents.DIPLOCAULUS_SCREAM.get(), this.m_6121_(), this.m_6100_());
        }
    }

    @Override
    public void onActionTick(ActionState state, int ticks) {
        LivingEntity lastTarget;
        if ((this.actionController.isActionAt(this.actionAttack, 5) || this.actionController.isActionAt(this.actionAttackInWater, 5)) && (lastTarget = this.getLastAttackTarget()) != null && this.m_217066_(lastTarget)) {
            float multiplier = this.getMobRation().canBeEaten((LivingEntity)this, lastTarget) ? 2.0f : 1.0f;
            EntityUtils.damageEntity((LivingEntity)this, (Entity)lastTarget, (float)multiplier);
        }
    }

    protected void m_7472_(DamageSource p_21385_, int p_21386_, boolean p_21387_) {
        super.m_7472_(p_21385_, p_21386_, p_21387_);
        if (RandomUtils.doWithChance((RandomSource)this.f_19796_, (float)3.0f)) {
            this.m_19998_((ItemLike)TDEItems.DIPLORANG.get());
        }
    }

    public boolean m_147207_(MobEffectInstance effectInstance, @Nullable Entity entity) {
        if (entity instanceof Witch && effectInstance.m_19544_() == MobEffects.f_19614_) {
            return false;
        }
        return super.m_147207_(effectInstance, entity);
    }

    @Override
    public boolean applyInstantEffect(MobEffect mobEffect, Entity source, Entity owner, LivingEntity livingEntity) {
        if (owner instanceof Witch && mobEffect == MobEffects.f_19602_) {
            return false;
        }
        return super.applyInstantEffect(mobEffect, source, owner, livingEntity);
    }

    public void setMad(boolean value) {
        byte b0 = (Byte)this.f_19804_.m_135370_(MAD);
        b0 = value ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(MAD, (Object)b0);
    }

    public boolean isMad() {
        return ((Byte)this.f_19804_.m_135370_(MAD) & 1) != 0;
    }

    public int getMoistnessLevel() {
        return (Integer)this.f_19804_.m_135370_(MOISTNESS_LEVEL);
    }

    public void setMoisntessLevel(int level) {
        this.f_19804_.m_135381_(MOISTNESS_LEVEL, (Object)level);
    }

    public int m_6062_() {
        return 2000;
    }

    @Override
    public boolean m_6040_() {
        return false;
    }

    @Override
    protected void handleAirSupply(int airTick) {
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)TDESoundEvents.DIPLOCAULUS_IDLE.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)TDESoundEvents.DIPLOCAULUS_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)TDESoundEvents.DIPLOCAULUS_DEATH.get();
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean value) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)value);
    }

    public void m_6872_(ItemStack itemStack) {
        Bucketable.m_148822_((Mob)this, (ItemStack)itemStack);
        CompoundTag compoundtag = itemStack.m_41784_();
        compoundtag.m_128405_("Age", this.m_146764_());
        compoundtag.m_128379_("IsMad", this.isMad());
        this.writeBaseMob(compoundtag);
    }

    public void m_142278_(CompoundTag compoundTag) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)compoundTag);
        if (compoundTag.m_128441_("IsMad")) {
            this.setMad(compoundTag.m_128471_("IsMad"));
        }
        this.readBaseMob(compoundTag);
    }

    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)TDEItems.DIPLOCAULUS_BUCKET.get());
    }

    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    public class LookController
    extends WaterMobLookControl {
        private BaseWaterAnimal mob;

        public LookController(BaseWaterAnimal mob, int maxYRotFromCenter) {
            super(mob, maxYRotFromCenter);
            this.mob = mob;
        }

        @Override
        public void m_8128_() {
            if (this.mob.m_20069_()) {
                super.m_8128_();
            } else {
                if (this.m_8106_()) {
                    this.mob.m_146926_(0.0f);
                }
                if (this.f_186068_ > 0) {
                    --this.f_186068_;
                    this.m_180896_().ifPresent(p_287447_ -> {
                        this.mob.f_20885_ = this.m_24956_(this.mob.f_20885_, p_287447_.floatValue(), this.f_24938_);
                    });
                    this.m_180897_().ifPresent(p_289400_ -> this.mob.m_146926_(this.m_24956_(this.mob.m_146909_(), p_289400_.floatValue(), this.f_24939_)));
                } else {
                    this.mob.f_20885_ = this.m_24956_(this.mob.f_20885_, this.mob.f_20883_, 10.0f);
                }
                this.m_142586_();
            }
        }
    }

    public static class Goals {

        public static class ReturnToWater
        extends GoalMoveToBlock<EntityDiplocaulus> {
            private final EntityDiplocaulus diplocaulus;

            public ReturnToWater(EntityDiplocaulus diplocaulus, double speedModifier) {
                super(diplocaulus, speedModifier, 24, 2, 20, 0.5f, (pos, state) -> state.m_60713_(Blocks.f_49990_));
                this.diplocaulus = diplocaulus;
            }

            @Override
            public boolean m_8045_() {
                if (this.diplocaulus.m_20069_()) {
                    return false;
                }
                return this.diplocaulus.getMoistnessLevel() <= 400;
            }

            @Override
            public boolean m_8036_() {
                if (this.diplocaulus.m_20069_()) {
                    return false;
                }
                if (this.diplocaulus.getMoistnessLevel() <= 400) {
                    return super.m_8036_();
                }
                return false;
            }

            @Override
            public boolean shouldRecalculatePath() {
                return this.tryTicks % 160 == 0;
            }
        }
    }
}

