/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.entity.water;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import ru.astemir.astemirlib.client.SmoothValue;
import ru.astemir.astemirlib.common.action.ActionState;
import ru.astemir.astemirlib.common.entity.EntityUtils;
import ru.astemir.astemirlib.common.math.AVector3f;
import ru.astemir.astemirlib.common.math.InterpolationType;
import ru.astemir.astemirlib.common.math.RandomUtils;
import ru.xishnikus.thedawnera.common.effect.TDEMobEffects;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseRideableAnimal;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseRideableWaterAnimal;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseSubpart;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseWaterAnimal;
import ru.xishnikus.thedawnera.common.entity.entity.base.MultipartMob;
import ru.xishnikus.thedawnera.common.entity.input.InputKey;
import ru.xishnikus.thedawnera.common.entity.input.KeyInputMob;
import ru.xishnikus.thedawnera.common.entity.properties.misc.NumberProperty;
import ru.xishnikus.thedawnera.common.entity.properties.misc.RandomSelectAction;
import ru.xishnikus.thedawnera.common.io.json.TDEJsonUtils;
import ru.xishnikus.thedawnera.common.misc.TDESoundEvents;
import ru.xishnikus.thedawnera.common.utils.TDEUtils;

public class EntityDunkleosteus
extends BaseRideableWaterAnimal<Properties>
implements MultipartMob,
KeyInputMob {
    public SmoothValue<Double> clientPregnancyScale = SmoothValue.valDouble((InterpolationType)InterpolationType.LINEAR, (double)1.0);
    public final ActionState actionAttackBite = this.actionController.getActionByName("attack1");
    public final ActionState actionAttackHead = this.actionController.getActionByName("attack2");
    public final ActionState actionEat = this.actionController.getActionByName("eat");
    private BaseSubpart headpart;
    private BaseSubpart backpart;
    private RandomSelectAction attackRandom = ((Properties)this.getProperties()).getRandomSelectActions().get("attack_random");

    public EntityDunkleosteus(EntityType<? extends BaseWaterAnimal> type, Level level) {
        super(type, level);
    }

    @Override
    public BaseSubpart<?>[] initializeParts() {
        this.headpart = this.createPart(this.m_6095_().m_20678_() * 0.75f, this.m_6095_().m_20679_() * 0.75f);
        this.backpart = this.createPart(this.m_6095_().m_20678_() * 0.75f, this.m_6095_().m_20679_() * 0.75f);
        return new BaseSubpart[]{this.headpart, this.backpart};
    }

    public boolean m_147207_(MobEffectInstance effect, @Nullable Entity entity) {
        if (effect.m_19544_() == TDEMobEffects.FRACTURE.get()) {
            return false;
        }
        return super.m_147207_(effect, entity);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.clientPregnancyScale.update(0.1f);
        if (this.isPregnant()) {
            this.clientPregnancyScale.setTo((Object)1.15);
        } else {
            this.clientPregnancyScale.setTo((Object)1.0);
        }
        if (this.m_6162_()) {
            this.jumpOnGround();
        }
    }

    public void m_8107_() {
        super.m_8107_();
        this.scaleParts(this.m_6162_() ? 0.5f : 1.0f);
        Vec3 offset = this.getOffsetForPart();
        Vec3[] partPoses = this.preparePartPositions();
        this.offsetPart(this.headpart, offset.f_82479_ * -1.5, offset.f_82480_ + (double)0.15f, offset.f_82481_ * -1.5);
        this.offsetPart(this.backpart, offset.f_82479_ * 1.5, -offset.f_82480_ + (double)0.15f, offset.f_82481_ * 1.5);
        this.applyPartPositions(partPoses);
    }

    @Override
    public boolean doesKilledEntityHasDrop(LivingEntity killedEntity, Collection<ItemEntity> drops) {
        if (killedEntity instanceof Skeleton) {
            Skeleton skeleton = (Skeleton)killedEntity;
            ItemStack boneMeal = Items.f_42499_.m_7968_();
            boneMeal.m_41764_(RandomUtils.randomInt((RandomSource)this.f_19796_, (int)4, (int)8));
            skeleton.m_19983_(boneMeal);
        }
        if (killedEntity instanceof Turtle) {
            Turtle turtle = (Turtle)killedEntity;
            if (RandomUtils.doWithChance((RandomSource)this.f_19796_, (float)30.0f) && !turtle.m_6162_()) {
                turtle.m_19998_((ItemLike)Items.f_42355_);
            }
        }
        return super.doesKilledEntityHasDrop(killedEntity, drops);
    }

    @Override
    public void onActionBegin(ActionState state) {
        if (state == this.actionEat) {
            this.m_5496_((SoundEvent)TDESoundEvents.EAT_SHORT.get(), 1.0f, this.m_6100_());
        }
        if (state == this.actionAttackBite) {
            this.m_5496_((SoundEvent)TDESoundEvents.DUNKLEOSTEUS_ATTACK.get(), 1.0f, this.m_6100_());
        }
        if (state == this.actionAttackHead) {
            this.m_5496_((SoundEvent)TDESoundEvents.DUNKLEOSTEUS_RAM.get(), 1.0f, this.m_6100_());
        }
    }

    @Override
    public void onInputHandle(InputKey inputKey) {
        if (this.tickControlled >= 20 && this.actionController.isNoAction() && inputKey.is("attack") && this.consumeEnergy(10.0f)) {
            this.attackRandom.playRandom(this);
        }
    }

    @Override
    public void onActionTick(ActionState state, int ticks) {
        if (this.actionController.isActionAt(this.actionAttackBite, 8)) {
            LivingEntity lastTarget = this.getLastAttackTarget();
            TDEUtils.attackFrontEntities(this, 20.0f);
            if (this.getLastEatenFood() != null) {
                Properties.Trade trade = ((Properties)this.getProperties()).getTrade(this.getLastEatenFood().m_41720_());
                ItemEntity itemEntity = this.m_19983_(trade.random(this.f_19796_));
                itemEntity.m_20256_(EntityUtils.getDirection((Entity)this).mul(0.25f).toVec3());
                itemEntity.f_19812_ = true;
                this.setLastEatenFood(null);
            }
            if (lastTarget != null && this.m_217066_(lastTarget)) {
                lastTarget.m_7292_(new MobEffectInstance((MobEffect)TDEMobEffects.FRACTURE.get(), 120, 0, true, false));
                EntityUtils.damageEntity((LivingEntity)this, (Entity)lastTarget, (float)1.3f, (boolean)false);
            }
        } else if (this.actionController.isActionAt(this.actionAttackHead, 11)) {
            LivingEntity lastTarget = this.getLastAttackTarget();
            if (lastTarget != null && this.m_217066_(lastTarget)) {
                EntityUtils.damageEntity((LivingEntity)this, (Entity)lastTarget, (float)1.0f, (boolean)true);
            }
            TDEUtils.breakNearbyBlocks((Entity)this, this.m_9236_(), AVector3f.from((Vec3)this.m_146892_().m_82520_(0.0, 0.5, 0.0).m_82549_(EntityUtils.getDirection((Entity)this).mul(1.5f, 1.5f, 1.5f).toVec3())).toBlockPos(), 1.0f, blockState -> blockState.m_60713_(Blocks.f_50058_));
        }
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (this.m_21830_((LivingEntity)player) && !this.m_6162_() && this.actionController.isNoAction() && ((Properties)this.getProperties()).hasTrade(itemStack.m_41720_())) {
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            this.setLastEatenFood(itemStack.m_41720_().m_7968_());
            this.actionController.playAction(this.actionAttackBite);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public boolean hurtFromPart(BaseSubpart part, DamageSource source, float amount) {
        return MultipartMob.super.hurtFromPart(part, source, part == this.headpart ? amount * 0.5f : amount);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)TDESoundEvents.DUNKLEOSTEUS_IDLE.get();
    }

    @Override
    public int m_8100_() {
        return 300;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_21239_) {
        return (SoundEvent)TDESoundEvents.DUNKLEOSTEUS_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)TDESoundEvents.DUNKLEOSTEUS_DEATH.get();
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public static class Properties
    extends BaseRideableAnimal.Properties {
        public Map<Item, Trade> trades = new HashMap<Item, Trade>();

        public Properties(ResourceLocation configPath) {
            super(configPath);
        }

        @Override
        public void deserialize(JsonObject jsonObject) {
            JsonElement tradesJson;
            super.deserialize(jsonObject);
            if (jsonObject.has("Trades") && (tradesJson = jsonObject.get("Trades")).isJsonArray()) {
                JsonArray tradesJsonArray = tradesJson.getAsJsonArray();
                for (JsonElement tradeJson : tradesJsonArray) {
                    if (!tradeJson.isJsonObject()) continue;
                    JsonObject tradeJsonObject = tradeJson.getAsJsonObject();
                    this.trades.put(TDEJsonUtils.parseItem(tradeJsonObject, "From"), new Trade(TDEJsonUtils.parseItem(tradeJsonObject, "To"), TDEJsonUtils.parseNumber(tradeJsonObject, "Amount")));
                }
            }
        }

        public Trade getTrade(Item item) {
            return this.trades.get(item);
        }

        public boolean hasTrade(Item item) {
            return this.trades.containsKey(item);
        }

        private static class Trade {
            private Item item;
            private NumberProperty count;

            public Trade(Item item, NumberProperty count) {
                this.item = item;
                this.count = count;
            }

            public ItemStack random(RandomSource random) {
                ItemStack itemStack = this.item.m_7968_();
                itemStack.m_41764_(this.count.getInt());
                return itemStack;
            }
        }
    }
}

