/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.entity.water;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import ru.astemir.astemirlib.client.SmoothValue;
import ru.astemir.astemirlib.common.action.ActionState;
import ru.astemir.astemirlib.common.entity.EntityUtils;
import ru.astemir.astemirlib.common.math.AVector3f;
import ru.astemir.astemirlib.common.math.InterpolationType;
import ru.astemir.astemirlib.common.math.MathUtils;
import ru.astemir.astemirlib.common.math.RandomUtils;
import ru.xishnikus.thedawnera.common.TDELevelEvents;
import ru.xishnikus.thedawnera.common.entity.ai.goal.CustomGoal;
import ru.xishnikus.thedawnera.common.entity.ai.goal.move.GoalMoveToEntity;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseSubpart;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseWaterAnimal;
import ru.xishnikus.thedawnera.common.entity.entity.base.MultipartMob;
import ru.xishnikus.thedawnera.common.entity.properties.MobProperties;
import ru.xishnikus.thedawnera.common.entity.properties.ai.CustomGoalFactory;
import ru.xishnikus.thedawnera.common.entity.properties.misc.NumberProperty;
import ru.xishnikus.thedawnera.common.io.json.JsonField;
import ru.xishnikus.thedawnera.common.misc.TDESoundEvents;
import ru.xishnikus.thedawnera.common.particle.TDEParticleTypes;

public class EntityMixosaurus
extends BaseWaterAnimal<MobProperties>
implements MultipartMob {
    private static final EntityDataAccessor<Integer> MOISTNESS_LEVEL = SynchedEntityData.m_135353_(EntityMixosaurus.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final ActionState actionAttack;
    public final ActionState actionEat;
    public final ActionState actionJump;
    public SmoothValue<Double> clientPregnancyScale = SmoothValue.valDouble((InterpolationType)InterpolationType.LINEAR, (double)1.0);
    private BaseSubpart headpart;
    private BaseSubpart backpart;

    public EntityMixosaurus(EntityType<? extends BaseWaterAnimal> type, Level level) {
        super((EntityType<? extends BaseAnimal>)type, level);
        this.actionAttack = this.actionController.getActionByName("attack");
        this.actionEat = this.actionController.getActionByName("eat");
        this.actionJump = this.actionController.getActionByName("jump");
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficultyInstance, MobSpawnType type, @Nullable SpawnGroupData groupData, @Nullable CompoundTag compoundTag) {
        this.m_20301_(this.m_6062_());
        return super.m_6518_(level, difficultyInstance, type, groupData, compoundTag);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MOISTNESS_LEVEL, (Object)1200);
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("Moistness", this.getMoistnessLevel());
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (compoundTag.m_128441_("Moistness")) {
            this.setMoisntessLevel(compoundTag.m_128451_("Moistness"));
        }
    }

    @Override
    public BaseSubpart<?>[] initializeParts() {
        this.headpart = this.createPart(this.m_6095_().m_20678_(), this.m_6095_().m_20679_());
        this.backpart = this.createPart(this.m_6095_().m_20678_(), this.m_6095_().m_20679_());
        return new BaseSubpart[]{this.headpart, this.backpart};
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_21525_()) {
            this.m_20301_(this.m_6062_());
        } else if (this.m_20071_()) {
            this.setMoisntessLevel(2400);
        } else {
            this.setMoisntessLevel(this.getMoistnessLevel() - 1);
            if (this.getMoistnessLevel() <= 0) {
                this.m_6469_(this.m_269291_().m_269483_(), 1.0f);
            }
            this.jumpOnGround();
        }
        if (this.m_9236_().f_46443_ && this.m_20069_() && this.m_20184_().m_82556_() > 0.03) {
            Vec3 vec3 = this.m_20252_(0.0f);
            float f = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 0.3f;
            float f1 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))) * 0.3f;
            float f2 = 1.2f - this.f_19796_.m_188501_() * 0.7f;
            for (int i = 0; i < 2; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123776_, this.m_20185_() - vec3.f_82479_ * (double)f2 + (double)f, this.m_20186_() - vec3.f_82480_, this.m_20189_() - vec3.f_82481_ * (double)f2 + (double)f1, 0.0, 0.0, 0.0);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123776_, this.m_20185_() - vec3.f_82479_ * (double)f2 - (double)f, this.m_20186_() - vec3.f_82480_, this.m_20189_() - vec3.f_82481_ * (double)f2 - (double)f1, 0.0, 0.0, 0.0);
            }
        }
        this.clientPregnancyScale.update(0.1f);
        if (this.isPregnant()) {
            this.clientPregnancyScale.setTo((Object)1.15);
        } else {
            this.clientPregnancyScale.setTo((Object)1.0);
        }
    }

    protected void m_5841_() {
        super.m_5841_();
        if (this.actionController.is(this.actionJump)) {
            for (int i = 0; i < 40; ++i) {
                this.m_9236_().m_7106_((ParticleOptions)TDEParticleTypes.WATER_SPLASH.get(), this.m_20185_() + (double)RandomUtils.randomFloat((float)-0.25f, (float)0.25f), this.m_20186_() + (double)RandomUtils.randomFloat((float)-0.2f, (float)0.0f), this.m_20189_() + (double)RandomUtils.randomFloat((float)-0.25f, (float)0.25f), (double)RandomUtils.randomFloat((float)-0.2f, (float)0.2f), (double)RandomUtils.randomFloat((float)0.1f, (float)0.6f), (double)RandomUtils.randomFloat((float)-0.2f, (float)0.2f));
            }
        }
    }

    public void m_8107_() {
        ItemStack heldItem;
        super.m_8107_();
        if (!this.m_20069_() && this.m_20096_()) {
            this.m_146926_(MathUtils.lerp((float)this.m_146909_(), (float)0.0f, (float)0.1f));
        }
        if (this.f_19797_ % 120 == 0 && (heldItem = this.m_21120_(InteractionHand.MAIN_HAND)).m_41614_()) {
            TDELevelEvents.eatFood((LivingEntity)this, heldItem.m_41777_());
            this.m_5496_((SoundEvent)TDESoundEvents.EAT_SHORT.get(), 1.0f, 1.5f);
            this.actionController.playAction(this.actionEat);
            this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
            this.eat(this.getMaxHunger() / 8.0f);
        }
        this.scaleParts(this.m_6162_() ? 0.5f : 1.0f);
        Vec3 offset = this.getOffsetForPart();
        Vec3[] partPoses = this.preparePartPositions();
        this.offsetPart(this.headpart, offset.f_82479_ * -0.75, offset.f_82480_ * 0.5, offset.f_82481_ * -0.75);
        this.offsetPart(this.backpart, offset.f_82479_ * 0.75, -offset.f_82480_ * 0.5, offset.f_82481_ * 0.75);
        this.applyPartPositions(partPoses);
    }

    @Override
    public void onActionBegin(ActionState state) {
        if (state == this.actionEat) {
            this.m_5496_((SoundEvent)TDESoundEvents.EAT_SHORT.get(), 1.0f, this.m_6100_() * 1.5f);
        }
    }

    @Override
    public void onActionTick(ActionState state, int ticks) {
        LivingEntity lastTarget;
        if (this.actionController.isActionAt(this.actionAttack, 5) && (lastTarget = this.getLastAttackTarget()) != null && this.m_217066_(lastTarget)) {
            float multiplier = this.getMobRation().canBeEaten((LivingEntity)this, lastTarget) ? 2.0f : 1.0f;
            EntityUtils.damageEntity((LivingEntity)this, (Entity)lastTarget, (float)multiplier);
        }
    }

    @Override
    public boolean canLookXRot() {
        return !this.actionController.is(this.actionJump);
    }

    public int getMoistnessLevel() {
        return (Integer)this.f_19804_.m_135370_(MOISTNESS_LEVEL);
    }

    public void setMoisntessLevel(int level) {
        this.f_19804_.m_135381_(MOISTNESS_LEVEL, (Object)level);
    }

    public int m_6062_() {
        return 1200;
    }

    @Override
    public boolean m_6040_() {
        return false;
    }

    @Override
    protected void handleAirSupply(int airTick) {
    }

    public float m_6100_() {
        return super.m_6100_() + 0.25f;
    }

    protected float m_6121_() {
        return 0.7f;
    }

    @Override
    public int m_8100_() {
        return 300;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)TDESoundEvents.MIXOSAURUS_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)TDESoundEvents.MIXOSAURUS_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)TDESoundEvents.MIXOSAURUS_DEATH.get();
    }

    public static class Goals {

        public static class StealFish
        extends GoalMoveToEntity<BaseAnimal> {
            public StealFish(BaseAnimal mob, int horizontalDistance, int verticalDistance, double speedModifier, int interval) {
                super(mob, speedModifier, horizontalDistance, verticalDistance, interval, entity -> {
                    Player player;
                    ItemStack heldStack = mob.m_21120_(InteractionHand.MAIN_HAND);
                    return !(heldStack != ItemStack.f_41583_ && heldStack != null || !(entity instanceof Player) || !(player = (Player)entity).m_21120_(InteractionHand.MAIN_HAND).m_204117_(ItemTags.f_13156_) && !player.m_21120_(InteractionHand.OFF_HAND).m_204117_(ItemTags.f_13156_));
                });
                this.setTargetOffset(new AVector3f(0.0f, 1.0f, 0.0f));
                this.setCanTargetCondition(target -> target.m_20069_());
            }

            @Override
            public void achieveEntity(Entity entity) {
                Entity entity2 = this.target;
                if (entity2 instanceof Player) {
                    ItemStack resultStack;
                    Player player = (Player)entity2;
                    ItemStack mainHand = player.m_21120_(InteractionHand.MAIN_HAND);
                    ItemStack offHand = player.m_21120_(InteractionHand.OFF_HAND);
                    Object object = mainHand.m_204117_(ItemTags.f_13156_) ? mainHand : (resultStack = offHand.m_204117_(ItemTags.f_13156_) ? offHand : null);
                    if (resultStack != null) {
                        this.mob.m_21008_(InteractionHand.MAIN_HAND, resultStack.m_41777_());
                        resultStack.m_41774_(1);
                    }
                }
            }

            public static class Builder
            extends CustomGoalFactory {
                @JsonField(value="Speed")
                private NumberProperty speedModifier = NumberProperty.uniform(1.0);
                @JsonField(value="HorizontalDistance")
                private NumberProperty horizontalDistance = NumberProperty.uniform(20.0);
                @JsonField(value="VerticalDistance")
                private NumberProperty verticalDistance = NumberProperty.uniform(10.0);
                @JsonField(value="Interval")
                private NumberProperty interval = NumberProperty.uniform(20.0);

                public CustomGoal<? extends BaseAnimal> create(BaseAnimal animal) {
                    return new StealFish(animal, this.horizontalDistance.getInt(), this.verticalDistance.getInt(), this.speedModifier.getDouble(), this.interval.getInt());
                }
            }
        }
    }
}

