/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.entity.water;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import ru.astemir.astemirlib.common.action.ActionState;
import ru.astemir.astemirlib.common.entity.EntityUtils;
import ru.astemir.astemirlib.common.math.RandomUtils;
import ru.xishnikus.thedawnera.common.entity.ai.controller.AmphibiousMobMoveController;
import ru.xishnikus.thedawnera.common.entity.ai.controller.SemiWaterPathNavigation;
import ru.xishnikus.thedawnera.common.entity.ai.goal.CustomGoal;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseRideableAnimal;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseRideableWaterAnimal;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseSubpart;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseWaterAnimal;
import ru.xishnikus.thedawnera.common.entity.entity.base.MultipartMob;
import ru.xishnikus.thedawnera.common.entity.entity.ground.EntityDeinonychus;
import ru.xishnikus.thedawnera.common.entity.input.InputKey;
import ru.xishnikus.thedawnera.common.entity.input.KeyInputMob;
import ru.xishnikus.thedawnera.common.entity.properties.misc.RandomSelectAction;
import ru.xishnikus.thedawnera.common.misc.TDESoundEvents;
import ru.xishnikus.thedawnera.common.particle.TDEParticleTypes;
import ru.xishnikus.thedawnera.common.utils.TDEUtils;

public class EntitySachicasaurus
extends BaseRideableWaterAnimal<BaseRideableAnimal.Properties>
implements MultipartMob,
KeyInputMob {
    private static final EntityDataAccessor<Byte> CHARGED = SynchedEntityData.m_135353_(EntitySachicasaurus.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public final ActionState actionAttack1;
    public final ActionState actionAttack2;
    public final ActionState actionAttackLand;
    public final ActionState actionEat1;
    public final ActionState actionEat2;
    public final ActionState actionOpen;
    public final ActionState actionClose;
    public final ActionState actionRoar;
    private BaseSubpart headpart;
    private BaseSubpart headpart2;
    private BaseSubpart backpart;
    private RandomSelectAction inputRandomAttack = new RandomSelectAction().add(50.0f, "attack1").add(50.0f, "attack2");
    private int chargedTicks = 0;

    public EntitySachicasaurus(EntityType<? extends BaseWaterAnimal> type, Level level) {
        super(type, level);
        this.actionAttack1 = this.actionController.getActionByName("attack1");
        this.actionAttack2 = this.actionController.getActionByName("attack2");
        this.actionAttackLand = this.actionController.getActionByName("attack_land");
        this.actionEat1 = this.actionController.getActionByName("eat1");
        this.actionEat2 = this.actionController.getActionByName("eat2");
        this.actionOpen = this.actionController.getActionByName("open");
        this.actionClose = this.actionController.getActionByName("close");
        this.actionRoar = this.actionController.getActionByName("roar");
        this.f_21342_ = new AmphibiousMobMoveController((PathfinderMob)this, 0.3f, 3.0f, 1.25f, 0.6f);
    }

    @Override
    protected PathNavigation m_6037_(Level level) {
        return new SemiWaterPathNavigation((Mob)this, level);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CHARGED, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128379_("IsCharged", this.isCharged());
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (compoundTag.m_128441_("IsCharged")) {
            this.setCharged(compoundTag.m_128471_("IsCharged"));
        }
    }

    @Override
    public BaseSubpart<?>[] initializeParts() {
        this.headpart = this.createPart(this.m_6095_().m_20678_(), this.m_6095_().m_20679_());
        this.headpart2 = this.createPart(this.m_6095_().m_20678_(), this.m_6095_().m_20679_());
        this.backpart = this.createPart(this.m_6095_().m_20678_(), this.m_6095_().m_20679_());
        return new BaseSubpart[]{this.headpart, this.headpart2, this.backpart};
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new Goals.PrepareCharge(this));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_6688_() != null) {
            InputKey chargeKey = ((BaseRideableAnimal.Properties)this.getProperties()).getInputMap().getKeyByName("charge_start");
            if (chargeKey.isDown() && this.consumeEnergy(1.0f)) {
                if (!this.isCharged()) {
                    this.actionController.playAction(this.actionOpen);
                }
            } else if (this.actionController.is(this.actionOpen)) {
                this.actionController.setNoState();
            } else if (this.isCharged()) {
                this.actionController.playAction(this.actionClose);
            }
        } else if (this.isCharged()) {
            ++this.chargedTicks;
            if (this.chargedTicks >= 120) {
                this.chargedTicks = 0;
                this.actionController.playAction(this.actionClose);
            }
        }
        this.scaleParts(this.m_6162_() ? 0.5f : 1.0f);
        Vec3 offset = this.getOffsetForPart();
        Vec3[] partPoses = this.preparePartPositions();
        this.offsetPart(this.backpart, offset.f_82479_ * 2.0, -offset.f_82480_ * 2.0, offset.f_82481_ * 2.0);
        this.offsetPart(this.headpart2, offset.f_82479_ * -4.0, offset.f_82480_ * 4.0, offset.f_82481_ * -4.0);
        this.offsetPart(this.headpart, offset.f_82479_ * -2.0, offset.f_82480_ * 2.0, offset.f_82481_ * -2.0);
        this.applyPartPositions(partPoses);
    }

    @Override
    public void onActionBegin(ActionState state) {
        if (state == this.actionAttack1) {
            this.m_5496_((SoundEvent)TDESoundEvents.SACHICASAURUS_ATTACK.get(), 2.0f, this.m_6100_());
        }
        if (state == this.actionAttack2) {
            this.m_5496_((SoundEvent)TDESoundEvents.SACHICASAURUS_ATTACK_OTHER.get(), 2.0f, this.m_6100_());
        }
        if (state == this.actionEat1 || state == this.actionEat2) {
            this.m_5496_((SoundEvent)TDESoundEvents.EAT_MEAT.get(), 1.0f, this.m_6100_() * 0.6f);
        }
    }

    @Override
    public void onActionTick(ActionState state, int ticks) {
        float damageMultiplier;
        LivingEntity lastTarget;
        if (this.actionController.isActionAt(this.actionClose, 5)) {
            this.setCharged(false);
            this.m_5496_((SoundEvent)TDESoundEvents.SACHICASAURUS_JAW_CLOSE.get(), this.m_6121_(), this.m_6100_());
            lastTarget = this.getLastAttackTarget();
            TDEUtils.attackFrontEntities(this, 40.0f);
            if (lastTarget != null && this.m_217066_(lastTarget)) {
                damageMultiplier = lastTarget instanceof Player ? 2.5f : 3.0f;
                EntityUtils.damageEntity((LivingEntity)this, (Entity)this.getLastAttackTarget(), (float)damageMultiplier, (boolean)true);
            }
        }
        if (this.actionController.isActionAt(this.actionOpen, (double)1.8f)) {
            this.setCharged(true);
            this.m_5496_((SoundEvent)TDESoundEvents.SACHICASAURUS_JAW_OPEN.get(), this.m_6121_(), this.m_6100_());
        }
        if (this.actionController.isActionAt(this.actionRoar, 5)) {
            this.m_5496_(this.getRoarSound(), 8.0f, this.m_6100_());
        }
        if (this.actionController.isActionAt(this.actionAttack1, 5)) {
            lastTarget = this.getLastAttackTarget();
            TDEUtils.attackFrontEntities(this, 40.0f);
            if (lastTarget != null && this.m_217066_(lastTarget)) {
                damageMultiplier = lastTarget instanceof Player ? 1.25f : 1.55f;
                EntityUtils.damageEntity((LivingEntity)this, (Entity)this.getLastAttackTarget(), (float)damageMultiplier, (boolean)true);
            }
        }
    }

    @Override
    public void onActionEnd(ActionState state) {
    }

    @Override
    public void onInputHandle(InputKey inputKey) {
        if (this.tickControlled >= 20 && this.actionController.isNoAction() && !this.isCharged()) {
            if (inputKey.is("attack") && this.consumeEnergy(10.0f)) {
                this.inputRandomAttack.playRandom(this);
            }
            if (inputKey.is("roar") && this.consumeEnergy(20.0f)) {
                this.actionController.playAction(this.actionRoar);
            }
        }
    }

    protected void m_5841_() {
        super.m_5841_();
        for (int i = 0; i < 80; ++i) {
            this.m_9236_().m_7106_((ParticleOptions)TDEParticleTypes.WATER_SPLASH.get(), this.m_20185_() + (double)RandomUtils.randomFloat((float)-0.25f, (float)0.25f), this.m_20186_() + (double)RandomUtils.randomFloat((float)-0.2f, (float)0.0f), this.m_20189_() + (double)RandomUtils.randomFloat((float)-0.25f, (float)0.25f), (double)RandomUtils.randomFloat((float)-0.2f, (float)0.2f), (double)RandomUtils.randomFloat((float)0.1f, (float)0.6f), (double)RandomUtils.randomFloat((float)-0.2f, (float)0.2f));
        }
    }

    @Override
    protected void m_19956_(Entity entity, Entity.MoveFunction moveFunction) {
        if (entity instanceof EntityDeinonychus) {
            super.m_19956_(entity, moveFunction);
            return;
        }
        if (this.m_20363_(entity)) {
            double d0 = this.m_20186_() + this.m_6048_() + entity.m_6049_();
            int i = this.m_20197_().indexOf(entity);
            float f = 0.7f;
            if (i != 0) {
                f = -0.7f;
            }
            Vec3 vec3 = new Vec3(0.0, 0.0, (double)f).m_82524_(-this.f_20883_ * ((float)Math.PI / 180));
            moveFunction.m_20372_(entity, this.m_20185_() + vec3.f_82479_, d0 - 0.5, this.m_20189_() + vec3.f_82481_);
        }
    }

    @Override
    public float getPassengerEyeScale() {
        return 1.5f;
    }

    public void setCharged(boolean value) {
        byte b0 = (Byte)this.f_19804_.m_135370_(CHARGED);
        b0 = value ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(CHARGED, (Object)b0);
    }

    public boolean isCharged() {
        return ((Byte)this.f_19804_.m_135370_(CHARGED) & 1) != 0;
    }

    protected SoundEvent m_7515_() {
        if (this.isEyeInFluidType(Fluids.f_76193_.getFluidType())) {
            return (SoundEvent)TDESoundEvents.SACHICASAURUS_IDLE_UNDERWATER.get();
        }
        return (SoundEvent)TDESoundEvents.SACHICASAURUS_IDLE.get();
    }

    protected float m_6121_() {
        return 3.0f;
    }

    protected SoundEvent getRoarSound() {
        if (this.isEyeInFluidType(Fluids.f_76193_.getFluidType())) {
            return (SoundEvent)TDESoundEvents.SACHICASAURUS_ROAR_UNDERWATER.get();
        }
        return (SoundEvent)TDESoundEvents.SACHICASAURUS_ROAR.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        if (this.isEyeInFluidType(Fluids.f_76193_.getFluidType())) {
            return (SoundEvent)TDESoundEvents.SACHICASAURUS_HURT_UNDERWATER.get();
        }
        return (SoundEvent)TDESoundEvents.SACHICASAURUS_HURT.get();
    }

    protected SoundEvent m_5592_() {
        if (this.isEyeInFluidType(Fluids.f_76193_.getFluidType())) {
            return (SoundEvent)TDESoundEvents.SACHICASAURUS_DEATH_UNDERWATER.get();
        }
        return (SoundEvent)TDESoundEvents.SACHICASAURUS_DEATH.get();
    }

    @Override
    public int m_8100_() {
        return 600;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public static class Goals {

        public static class PrepareCharge
        extends CustomGoal {
            private int ticks = 0;
            private LivingEntity target;
            private EntitySachicasaurus sachicasaurus;

            public PrepareCharge(BaseAnimal mob) {
                super(mob);
                this.sachicasaurus = (EntitySachicasaurus)mob;
            }

            public boolean m_8036_() {
                if ((float)this.ticks < 100.0f) {
                    ++this.ticks;
                }
                this.target = this.mob.m_5448_();
                if (this.target == null) {
                    return false;
                }
                if (!this.mob.m_20069_()) {
                    return false;
                }
                return (float)this.ticks >= 100.0f && this.mob.m_20280_((Entity)this.target) <= 60.0 && !this.sachicasaurus.isCharged() && !this.sachicasaurus.actionController.is(new ActionState[]{this.sachicasaurus.actionOpen, this.sachicasaurus.actionClose});
            }

            public boolean m_8045_() {
                return this.sachicasaurus.actionController.is(this.sachicasaurus.actionOpen) || this.sachicasaurus.isCharged();
            }

            public void m_8056_() {
                this.ticks = 0;
                if (!this.sachicasaurus.isCharged()) {
                    this.sachicasaurus.actionController.playAction(this.sachicasaurus.actionOpen);
                }
            }

            public void m_8037_() {
                if (this.sachicasaurus.isCharged() && this.sachicasaurus.m_20280_((Entity)this.target) <= this.sachicasaurus.getReachDistanceTo((Entity)this.target, 2.0)) {
                    this.sachicasaurus.actionController.playAction(this.sachicasaurus.actionClose);
                }
            }
        }
    }
}

