/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.entity.water;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import ru.astemir.astemirlib.client.SmoothValue;
import ru.astemir.astemirlib.common.action.ActionState;
import ru.astemir.astemirlib.common.entity.EntityUtils;
import ru.astemir.astemirlib.common.math.InterpolationType;
import ru.astemir.astemirlib.common.math.RandomUtils;
import ru.astemir.astemirlib.common.world.WorldUtils;
import ru.xishnikus.thedawnera.common.block.TDEBlocks;
import ru.xishnikus.thedawnera.common.entity.TDEEntities;
import ru.xishnikus.thedawnera.common.entity.ai.goal.CustomGoal;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseSubpart;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseWaterAnimal;
import ru.xishnikus.thedawnera.common.entity.entity.base.MultipartMob;
import ru.xishnikus.thedawnera.common.entity.entity.ground.EntityPondSnail;
import ru.xishnikus.thedawnera.common.entity.properties.MobProperties;
import ru.xishnikus.thedawnera.common.entity.properties.ai.CustomGoalFactory;
import ru.xishnikus.thedawnera.common.entity.properties.misc.NumberProperty;
import ru.xishnikus.thedawnera.common.io.json.JsonField;
import ru.xishnikus.thedawnera.common.misc.TDESoundEvents;
import ru.xishnikus.thedawnera.common.utils.WeightedRandom;

public class EntitySturgeon
extends BaseWaterAnimal<MobProperties>
implements MultipartMob {
    public SmoothValue<Double> clientPregnancyScale = SmoothValue.valDouble((InterpolationType)InterpolationType.LINEAR, (double)1.0);
    public final ActionState actionAttack = this.actionController.getActionByName("attack");
    public final ActionState actionDig = this.actionController.getActionByName("dig");
    public final ActionState actionEat = this.actionController.getActionByName("eat");
    private BaseSubpart headpart;
    private BaseSubpart backpart;
    private int digCooldown;

    public EntitySturgeon(EntityType<? extends BaseWaterAnimal> type, Level level) {
        super((EntityType<? extends BaseAnimal>)type, level);
    }

    @Override
    public BaseSubpart<?>[] initializeParts() {
        this.headpart = this.createPart(this.m_6095_().m_20678_(), this.m_6095_().m_20679_());
        this.backpart = this.createPart(this.m_6095_().m_20678_(), this.m_6095_().m_20679_());
        return new BaseSubpart[]{this.headpart, this.backpart};
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficultyInstance, MobSpawnType type, @Nullable SpawnGroupData groupData, @Nullable CompoundTag compoundTag) {
        this.digCooldown = 400;
        return super.m_6518_(level, difficultyInstance, type, groupData, compoundTag);
    }

    protected void m_7472_(DamageSource damageSource, int lootingLevel, boolean killedByPlayer) {
        super.m_7472_(damageSource, lootingLevel, killedByPlayer);
        if (this.isPregnant()) {
            this.m_19998_((ItemLike)TDEBlocks.STURGEON_ROE.get());
        }
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("DigCooldown", this.digCooldown);
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        if (compoundTag.m_128441_("DigCooldown")) {
            this.setDigCooldown(compoundTag.m_128451_("DigCooldown"));
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.jumpOnGround();
        if (this.digCooldown > 0) {
            --this.digCooldown;
        }
        this.clientPregnancyScale.update(0.1f);
        if (this.isPregnant()) {
            this.clientPregnancyScale.setTo((Object)1.15);
        } else {
            this.clientPregnancyScale.setTo((Object)1.0);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        this.scaleParts(this.m_6162_() ? 0.5f : 1.0f);
        Vec3 offset = this.getOffsetForPart();
        Vec3[] partPoses = this.preparePartPositions();
        this.offsetPart(this.headpart, offset.f_82479_ * -0.75, offset.f_82480_ * 0.5, offset.f_82481_ * -0.75);
        this.offsetPart(this.backpart, offset.f_82479_ * 0.75, -offset.f_82480_ * 0.5, offset.f_82481_ * 0.75);
        this.applyPartPositions(partPoses);
    }

    @Override
    public void onActionBegin(ActionState state) {
        if (state == this.actionEat) {
            this.m_5496_((SoundEvent)TDESoundEvents.EAT_SHORT.get(), 1.0f, this.m_6100_() * 1.5f);
        }
    }

    @Override
    public void onActionTick(ActionState state, int ticks) {
        LivingEntity lastTarget;
        if (this.actionController.isActionAt(this.actionAttack, 5) && (lastTarget = this.getLastAttackTarget()) != null && this.m_217066_(lastTarget)) {
            float multiplier = this.getMobRation().canBeEaten((LivingEntity)this, lastTarget) ? 8.0f : 1.0f;
            EntityUtils.damageEntity((LivingEntity)this, (Entity)lastTarget, (float)multiplier);
        }
    }

    protected SoundEvent m_7515_() {
        return null;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_12330_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12328_;
    }

    public int getDigCooldown() {
        return this.digCooldown;
    }

    public void setDigCooldown(int digCooldown) {
        this.digCooldown = digCooldown;
    }

    public static class Goals {

        public static class DigForFood
        extends CustomGoal<EntitySturgeon> {
            private static final WeightedRandom<Item> randomItems = new WeightedRandom<Item>().put(80.0f, Items.f_41867_).put(5.0f, Items.f_41983_).put(1.0f, Items.f_42715_);
            private BlockPos digPos;
            private int digTicks;
            private double speedModifier;

            public DigForFood(EntitySturgeon mob, double speedModifier) {
                super(mob);
                this.speedModifier = speedModifier;
                this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
            }

            public boolean m_8036_() {
                if (!this.isCanBeUsed()) {
                    return false;
                }
                if (((EntitySturgeon)this.mob).getDigCooldown() > 0 || ((EntitySturgeon)this.mob).m_6162_() || ((EntitySturgeon)this.mob).isPregnant() || ((EntitySturgeon)this.mob).m_5448_() != null || !RandomUtils.doWithChance((RandomSource)((EntitySturgeon)this.mob).m_217043_(), (float)1.0f)) {
                    return false;
                }
                BlockPos blockPos = this.getDigPos(((EntitySturgeon)this.mob).m_20183_());
                if (blockPos != null) {
                    this.digPos = blockPos;
                    return true;
                }
                return false;
            }

            public void m_8056_() {
                ((EntitySturgeon)this.mob).setDigCooldown(RandomUtils.randomInt((RandomSource)((EntitySturgeon)this.mob).m_217043_(), (int)1200, (int)2400));
            }

            public boolean m_8045_() {
                if (!this.isCanBeContinuedToUse()) {
                    return false;
                }
                return this.digPos != null && !((EntitySturgeon)this.mob).isPregnant();
            }

            public void m_8041_() {
                super.m_8041_();
                this.digTicks = 0;
                this.digPos = null;
                ((EntitySturgeon)this.mob).actionController.setNoState();
            }

            public void m_8037_() {
                super.m_8037_();
                if (this.digPos != null) {
                    BlockPos blockPos = WorldUtils.blockPos((double)((double)this.digPos.m_123341_() + 0.5), (double)((float)this.digPos.m_123342_() + 0.5f), (double)((double)this.digPos.m_123343_() + 0.5));
                    if (((EntitySturgeon)this.mob).m_20275_(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_()) < ((EntitySturgeon)this.mob).getReachDistance(2.0)) {
                        ++this.digTicks;
                        ((EntitySturgeon)this.mob).m_20334_(0.0, 0.0, 0.0);
                        if (this.digTicks % 2 == 0) {
                            ((EntitySturgeon)this.mob).actionController.playAction(((EntitySturgeon)this.mob).actionDig);
                            ((EntitySturgeon)this.mob).m_9236_().m_46796_(2001, this.digPos, Block.m_49956_((BlockState)((EntitySturgeon)this.mob).m_9236_().m_8055_(this.digPos.m_7495_())));
                        }
                        if (this.digTicks > this.m_183277_(60)) {
                            if (RandomUtils.doWithChance((float)90.0f)) {
                                ItemEntity item = (ItemEntity)EntityType.f_20461_.m_20615_(((EntitySturgeon)this.mob).m_9236_());
                                item.m_32045_(randomItems.random().m_7968_());
                                item.m_6034_((double)this.digPos.m_123341_() + 0.5, (double)this.digPos.m_123342_() + 0.5, (double)this.digPos.m_123343_() + 0.5);
                                ((EntitySturgeon)this.mob).m_9236_().m_7967_((Entity)item);
                                this.m_8041_();
                            } else {
                                EntityPondSnail snail = (EntityPondSnail)((EntityType)TDEEntities.POND_SNAIL.get()).m_20615_(((EntitySturgeon)this.mob).m_9236_());
                                snail.m_6034_((double)this.digPos.m_123341_() + 0.5, (double)this.digPos.m_123342_() + 0.5, (double)this.digPos.m_123343_() + 0.5);
                                ((EntitySturgeon)this.mob).m_9236_().m_7967_((Entity)snail);
                                this.m_8041_();
                            }
                        }
                    } else if (((EntitySturgeon)this.mob).m_21573_().m_26571_() || ((EntitySturgeon)this.mob).m_21573_().m_26577_()) {
                        ((EntitySturgeon)this.mob).m_21573_().m_26536_(((EntitySturgeon)this.mob).m_21573_().m_26524_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), 0), this.speedModifier);
                    }
                }
            }

            public BlockPos getDigPos(BlockPos from) {
                Level world = ((EntitySturgeon)this.mob).m_9236_();
                RandomSource random = ((EntitySturgeon)this.mob).m_217043_();
                int range = 20;
                for (int i = 0; i < 20; ++i) {
                    BlockPos seafloor = from.m_7918_(random.m_188503_(range) - range / 2, 0, random.m_188503_(range) - range / 2);
                    while (world.m_6425_(seafloor).m_205070_(FluidTags.f_13131_) && seafloor.m_123342_() > 1) {
                        seafloor = seafloor.m_7495_();
                    }
                    BlockState floorState = world.m_8055_(seafloor);
                    if (!floorState.m_60713_(Blocks.f_49992_) && !floorState.m_60713_(Blocks.f_49994_) && !floorState.m_60713_(Blocks.f_50129_)) continue;
                    return seafloor.m_7494_();
                }
                return null;
            }

            public static class Builder
            extends CustomGoalFactory<DigForFood> {
                @JsonField(value="Speed")
                private NumberProperty speedModifier = NumberProperty.uniform(1.0);

                @Override
                public DigForFood create(BaseAnimal animal) {
                    if (animal instanceof EntitySturgeon) {
                        EntitySturgeon sturgeon = (EntitySturgeon)animal;
                        return new DigForFood(sturgeon, this.speedModifier.getDouble());
                    }
                    throw new RuntimeException("This goal can only be used for Sturgeon.");
                }
            }
        }
    }
}

