/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.input;

import net.minecraft.network.chat.Component;
import ru.xishnikus.thedawnera.common.entity.input.InputActionType;
import ru.xishnikus.thedawnera.common.entity.input.InputType;

public class InputKey {
    private InputActionType inputActionType;
    private InputType inputType;
    private Id buttonId;
    private int cooldown = 0;
    private boolean pressed = false;
    private int cooldownTicks = 0;
    private int clickCount = 0;
    private int releaseCount = 0;
    private int id = 0;
    private String name;

    public InputKey(String name, InputType inputType, InputActionType inputActionType, Id buttonId, int cooldown) {
        this.name = name;
        this.inputType = inputType;
        this.inputActionType = inputActionType;
        this.buttonId = buttonId;
        this.cooldown = cooldown;
    }

    public InputKey(String name, InputType inputType, InputActionType inputActionType, Id buttonId) {
        this.name = name;
        this.inputType = inputType;
        this.inputActionType = inputActionType;
        this.buttonId = buttonId;
    }

    public boolean isDown() {
        return this.pressed;
    }

    public boolean isDoubleClicked() {
        if (this.clickCount < 2) {
            return false;
        }
        this.clickCount -= 2;
        return true;
    }

    public boolean isClicked() {
        if (this.clickCount == 0) {
            return false;
        }
        --this.clickCount;
        return true;
    }

    public boolean isReleased() {
        if (this.releaseCount == 0) {
            return false;
        }
        --this.releaseCount;
        return true;
    }

    public void setPressed(boolean pressed) {
        if (pressed) {
            ++this.clickCount;
        } else {
            ++this.releaseCount;
        }
        this.pressed = pressed;
    }

    public boolean isActive() {
        return this.inputActionType.getPredicate().test(this);
    }

    public void update() {
        if (this.cooldown != 0 && this.cooldownTicks > 0) {
            --this.cooldownTicks;
        }
    }

    public void delay() {
        this.cooldownTicks = this.cooldown;
    }

    public boolean is(String str) {
        return this.name.equals(str);
    }

    public boolean isReadyToUse() {
        return this.cooldown == 0 || this.cooldownTicks == 0;
    }

    public InputType getInputType() {
        return this.inputType;
    }

    public InputActionType getInputAction() {
        return this.inputActionType;
    }

    public Id getButtonId() {
        return this.buttonId;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public int getCooldownTicks() {
        return this.cooldownTicks;
    }

    public void setId(int id) {
        this.id = id;
    }

    public static enum Id {
        KEY_0(48, "key.keyboard.0"),
        KEY_1(49, "key.keyboard.1"),
        KEY_2(50, "key.keyboard.2"),
        KEY_3(51, "key.keyboard.3"),
        KEY_4(52, "key.keyboard.4"),
        KEY_5(53, "key.keyboard.5"),
        KEY_6(54, "key.keyboard.6"),
        KEY_7(55, "key.keyboard.7"),
        KEY_8(56, "key.keyboard.8"),
        KEY_9(57, "key.keyboard.9"),
        KEY_A(65, "key.keyboard.a"),
        KEY_B(66, "key.keyboard.b"),
        KEY_C(67, "key.keyboard.c"),
        KEY_D(68, "key.keyboard.d"),
        KEY_E(69, "key.keyboard.e"),
        KEY_F(70, "key.keyboard.f"),
        KEY_G(71, "key.keyboard.g"),
        KEY_H(72, "key.keyboard.h"),
        KEY_I(73, "key.keyboard.i"),
        KEY_J(74, "key.keyboard.j"),
        KEY_K(75, "key.keyboard.k"),
        KEY_L(76, "key.keyboard.l"),
        KEY_M(77, "key.keyboard.m"),
        KEY_N(78, "key.keyboard.n"),
        KEY_O(79, "key.keyboard.o"),
        KEY_P(80, "key.keyboard.p"),
        KEY_Q(81, "key.keyboard.q"),
        KEY_R(82, "key.keyboard.r"),
        KEY_S(83, "key.keyboard.s"),
        KEY_T(84, "key.keyboard.t"),
        KEY_U(85, "key.keyboard.u"),
        KEY_V(86, "key.keyboard.v"),
        KEY_W(87, "key.keyboard.w"),
        KEY_X(88, "key.keyboard.x"),
        KEY_Y(89, "key.keyboard.y"),
        KEY_Z(90, "key.keyboard.z"),
        KEY_F1(290, "key.keyboard.f1"),
        KEY_F2(291, "key.keyboard.f2"),
        KEY_F3(292, "key.keyboard.f3"),
        KEY_F4(293, "key.keyboard.f4"),
        KEY_F5(294, "key.keyboard.f5"),
        KEY_F6(295, "key.keyboard.f6"),
        KEY_F7(296, "key.keyboard.f7"),
        KEY_F8(297, "key.keyboard.f8"),
        KEY_F9(298, "key.keyboard.f9"),
        KEY_F10(299, "key.keyboard.f10"),
        KEY_F11(300, "key.keyboard.f11"),
        KEY_F12(301, "key.keyboard.f12"),
        KEY_F13(302, "key.keyboard.f13"),
        KEY_F14(303, "key.keyboard.f14"),
        KEY_F15(304, "key.keyboard.f15"),
        KEY_F16(305, "key.keyboard.f16"),
        KEY_F17(306, "key.keyboard.f17"),
        KEY_F18(307, "key.keyboard.f18"),
        KEY_F19(308, "key.keyboard.f19"),
        KEY_F20(309, "key.keyboard.f20"),
        KEY_F21(310, "key.keyboard.f21"),
        KEY_F22(311, "key.keyboard.f22"),
        KEY_F23(312, "key.keyboard.f23"),
        KEY_F24(313, "key.keyboard.f24"),
        KEY_F25(314, "key.keyboard.f25"),
        KEY_NUMLOCK(282, "key.keyboard.numlock"),
        KEY_NUMPAD0(320, "key.keyboard.numpad0"),
        KEY_NUMPAD1(321, "key.keyboard.numpad1"),
        KEY_NUMPAD2(322, "key.keyboard.numpad2"),
        KEY_NUMPAD3(323, "key.keyboard.numpad3"),
        KEY_NUMPAD4(324, "key.keyboard.numpad4"),
        KEY_NUMPAD5(325, "key.keyboard.numpad5"),
        KEY_NUMPAD6(326, "key.keyboard.numpad6"),
        KEY_NUMPAD7(327, "key.keyboard.numpad7"),
        KEY_NUMPAD8(328, "key.keyboard.numpad8"),
        KEY_NUMPAD9(329, "key.keyboard.numpad9"),
        KEY_NUMPADCOMMA(330, "key.keyboard.numpadcomma"),
        KEY_NUMPADENTER(335, "key.keyboard.numpadenter"),
        KEY_NUMPADEQUALS(336, "key.keyboard.numpadequals"),
        KEY_DOWN(264, "key.keyboard.down"),
        KEY_LEFT(263, "key.keyboard.left"),
        KEY_RIGHT(262, "key.keyboard.right"),
        KEY_UP(265, "key.keyboard.up"),
        KEY_ADD(334, "key.keyboard.add"),
        KEY_APOSTROPHE(39, "key.keyboard.apostrophe"),
        KEY_BACKSLASH(92, "key.keyboard.backslash"),
        KEY_COMMA(44, "key.keyboard.comma"),
        KEY_EQUALS(61, "key.keyboard.equals"),
        KEY_GRAVE(96, "key.keyboard.grave"),
        KEY_LBRACKET(91, "key.keyboard.lbracket"),
        KEY_MINUS(45, "key.keyboard.minus"),
        KEY_MULTIPLY(332, "key.keyboard.multiply"),
        KEY_PERIOD(46, "key.keyboard.period"),
        KEY_RBRACKET(93, "key.keyboard.rbracket"),
        KEY_SEMICOLON(59, "key.keyboard.semicolon"),
        KEY_SLASH(47, "key.keyboard.slash"),
        KEY_SPACE(32, "key.keyboard.space"),
        KEY_TAB(258, "key.keyboard.tab"),
        KEY_LALT(342, "key.keyboard.lalt"),
        KEY_LCONTROL(341, "key.keyboard.lcontrol"),
        KEY_LSHIFT(340, "key.keyboard.lshift"),
        KEY_LWIN(343, "key.keyboard.lwin"),
        KEY_RALT(346, "key.keyboard.ralt"),
        KEY_RCONTROL(345, "key.keyboard.rcontrol"),
        KEY_RSHIFT(344, "key.keyboard.rshift"),
        KEY_RWIN(347, "key.keyboard.rwin"),
        KEY_RETURN(257, "key.keyboard.return"),
        KEY_ESCAPE(256, "key.keyboard.escape"),
        KEY_BACKSPACE(259, "key.keyboard.backspace"),
        KEY_DELETE(261, "key.keyboard.delete"),
        KEY_END(269, "key.keyboard.end"),
        KEY_HOME(268, "key.keyboard.home"),
        KEY_INSERT(260, "key.keyboard.insert"),
        KEY_PAGEDOWN(267, "key.keyboard.pagedown"),
        KEY_PAGEUP(266, "key.keyboard.pageup"),
        KEY_CAPSLOCK(280, "key.keyboard.capslock"),
        KEY_PAUSE(284, "key.keyboard.pause"),
        MOUSE_BUTTON_LEFT(0, "key.mouse.left"),
        MOUSE_BUTTON_MIDDLE(2, "key.mouse.middle"),
        MOUSE_BUTTON_RIGHT(1, "mey.mouse.right");

        private int id;
        private String name;

        private Id(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public Component getDisplayName() {
            return Component.m_237115_((String)this.name);
        }

        public String getName() {
            return this.name;
        }
    }
}

