/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.input;

import ru.xishnikus.thedawnera.common.entity.input.InputKey;
import ru.xishnikus.thedawnera.common.entity.input.KeyInputMob;

public class InputMap {
    private InputKey[] keys;

    public InputMap(InputKey ... keys) {
        for (int i = 0; i < keys.length; ++i) {
            keys[i].setId(i);
        }
        this.keys = keys;
    }

    public void update(KeyInputMob entity) {
        for (InputKey key : this.keys) {
            key.update();
            if (!key.isActive() || !key.isReadyToUse()) continue;
            key.delay();
        }
    }

    public InputKey getKeyByName(String name) {
        for (InputKey key : this.keys) {
            if (!key.getName().equals(name)) continue;
            return key;
        }
        return null;
    }

    public InputKey getKeyById(int id) {
        for (InputKey key : this.keys) {
            if (key.getId() != id) continue;
            return key;
        }
        return null;
    }

    public InputKey[] getKeys() {
        return this.keys;
    }
}

