/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.misc;

import java.util.LinkedList;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import ru.astemir.astemirlib.common.entity.EntityUtils;
import ru.astemir.astemirlib.common.handler.LevelEvent;
import ru.astemir.astemirlib.common.handler.LevelEventHandler;
import ru.astemir.astemirlib.common.network.PacketArgument;
import ru.xishnikus.thedawnera.common.TDELevelEvents;

public class MobStepHandler {
    private LinkedList<Listener> listeners = new LinkedList();

    public void tick(LivingEntity entity) {
        Level level = entity.m_9236_();
        if (level.f_46443_) {
            if (!entity.m_20096_() || entity.m_20069_() || entity.m_20077_()) {
                return;
            }
            for (Listener listener : this.listeners) {
                if (!listener.run(entity)) continue;
                return;
            }
        }
    }

    public MobStepHandler addListener(float stepPower, float length, BiPredicate<LivingEntity, Integer> predicate) {
        this.listeners.add(new Listener(stepPower, (int)Math.floor(length * 20.0f), predicate));
        return this;
    }

    public static void playStepSound(LivingEntity entity, SoundEvent soundEvent) {
        entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), soundEvent, entity.m_5720_(), 1.5f, entity.m_6100_());
    }

    private class Listener {
        private float power;
        private int length;
        private int steppedTickCount;
        private BiPredicate<LivingEntity, Integer> predicate;

        public Listener(float power, int length, BiPredicate<LivingEntity, Integer> predicate) {
            this.power = power;
            this.length = length;
            this.predicate = predicate;
        }

        public boolean run(LivingEntity entity) {
            if (EntityUtils.isMoving((LivingEntity)entity, (float)(-this.power), (float)this.power, (float)0.1f)) {
                this.steppedTickCount = this.steppedTickCount < this.length ? ++this.steppedTickCount : 0;
                if (this.predicate.test(entity, this.steppedTickCount)) {
                    LevelEventHandler.playServerEvent((Level)entity.m_9236_(), (BlockPos)entity.m_20183_(), (LevelEvent)TDELevelEvents.EVENT_MOB_STEP, (PacketArgument[])new PacketArgument[]{PacketArgument.valInt((int)entity.m_19879_()), PacketArgument.valFloat((float)this.power)});
                }
                return true;
            }
            this.reset();
            return false;
        }

        public void reset() {
            this.steppedTickCount = 0;
        }
    }
}

