/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.properties;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import ru.astemir.astemirlib.common.action.ActionController;
import ru.astemir.astemirlib.common.action.ActionListener;
import ru.astemir.astemirlib.common.action.ActionState;
import ru.astemir.astemirlib.common.action.ActionStateMachine;
import ru.xishnikus.thedawnera.common.entity.input.InputMap;
import ru.xishnikus.thedawnera.common.entity.properties.misc.ConditionalSelectAction;
import ru.xishnikus.thedawnera.common.entity.properties.misc.MobAIBuilder;
import ru.xishnikus.thedawnera.common.entity.properties.misc.MobAttributeName;
import ru.xishnikus.thedawnera.common.entity.properties.misc.MobFoodRation;
import ru.xishnikus.thedawnera.common.entity.properties.misc.MobSchedule;
import ru.xishnikus.thedawnera.common.entity.properties.misc.MobSpawnData;
import ru.xishnikus.thedawnera.common.entity.properties.misc.MobTameMethod;
import ru.xishnikus.thedawnera.common.entity.properties.misc.NumberProperty;
import ru.xishnikus.thedawnera.common.entity.properties.misc.RandomSelectAction;
import ru.xishnikus.thedawnera.common.io.json.JsonField;
import ru.xishnikus.thedawnera.common.io.json.JsonModConfig;
import ru.xishnikus.thedawnera.common.io.json.TDEJsonUtils;
import ru.xishnikus.thedawnera.common.misc.TDEAttributes;

public class MobProperties {
    private ResourceLocation configPath;
    private Map<MobAttributeName, Double> attributes = new HashMap<MobAttributeName, Double>();
    private Map<String, List<ActionState>> actionControllers;
    private Map<String, RandomSelectAction> randomSelectActions = new HashMap<String, RandomSelectAction>();
    private Map<String, ConditionalSelectAction> conditionalActions = new HashMap<String, ConditionalSelectAction>();
    private MobTameMethod tameMethod = MobTameMethod.NO_TAMING;
    private MobFoodRation foodRation;
    private MobSchedule mobSchedule;
    private MobAIBuilder mobAI;
    private InputMap inputMap;
    private MobSpawnData mobSpawn;
    @JsonField(value="PushModifier")
    private NumberProperty pushModifier = NumberProperty.uniform(1.0);
    @JsonField(value="StepHeight")
    private NumberProperty stepHeight = NumberProperty.uniform(0.6f);
    @JsonField(value="ExperienceDrop")
    private NumberProperty experienceDrop = NumberProperty.ranged(2.0, 6.0);
    @JsonField(value="RequiresSaddle")
    private boolean requiresSaddle = false;
    @JsonField(value="CanWearArmor")
    private boolean canWearArmor = false;
    @JsonField(value="Tamable")
    private boolean tamable = false;
    @JsonField(value="Rideable")
    private boolean rideable = false;

    public MobProperties(ResourceLocation configPath) {
        this.configPath = configPath;
    }

    @Deprecated
    public void loadFromConfig() {
        JsonObject jsonObject = new JsonModConfig(this.configPath).getContent();
        if (jsonObject.has("Attributes")) {
            this.attributes = TDEJsonUtils.parseAttributes(jsonObject, "Attributes");
        }
        if (jsonObject.has("StateMachine")) {
            this.actionControllers = TDEJsonUtils.parseActionStateMachine(jsonObject, "StateMachine");
        }
        if (jsonObject.has("RandomActions")) {
            this.randomSelectActions = TDEJsonUtils.parseRandomSelectActions(jsonObject, "RandomActions");
        }
        if (jsonObject.has("ConditionalActions")) {
            this.conditionalActions = TDEJsonUtils.parseConditionalSelectAction(jsonObject, "ConditionalActions");
        }
        if (jsonObject.has("InputControls")) {
            this.inputMap = TDEJsonUtils.parseInputMap(jsonObject, "InputControls");
        }
        if (jsonObject.has("FoodRation")) {
            this.foodRation = (MobFoodRation)TDEJsonUtils.GSON.fromJson(jsonObject.get("FoodRation"), MobFoodRation.class);
        }
        if (jsonObject.has("AI")) {
            this.mobAI = (MobAIBuilder)TDEJsonUtils.GSON.fromJson(jsonObject.get("AI"), MobAIBuilder.class);
        }
        if (jsonObject.has("MobSchedule")) {
            this.mobSchedule = (MobSchedule)TDEJsonUtils.GSON.fromJson(jsonObject.get("MobSchedule"), MobSchedule.class);
        }
        if (jsonObject.has("SpawnData")) {
            this.mobSpawn = (MobSpawnData)TDEJsonUtils.GSON.fromJson(jsonObject.get("SpawnData"), MobSpawnData.class);
        }
        if (jsonObject.has("TameMethod")) {
            this.tameMethod = MobTameMethod.fromJson(jsonObject.get("TameMethod").getAsJsonObject());
        }
        TDEJsonUtils.loadAllJsonFields(jsonObject, this);
        this.deserialize(jsonObject);
    }

    public void deserialize(JsonObject jsonObject) {
    }

    public AttributeSupplier buildAttributes() {
        AttributeSupplier.Builder builder = PathfinderMob.m_21552_();
        builder.m_22268_(Attributes.f_22281_, 1.0);
        builder.m_22268_((Attribute)TDEAttributes.MAX_HUNGER.get(), 1.0);
        builder.m_22268_((Attribute)TDEAttributes.MAX_ENERGY.get(), 1.0);
        for (Map.Entry<MobAttributeName, Double> entry : this.attributes.entrySet()) {
            builder.m_22268_(entry.getKey().getAttribute().get(), entry.getValue().doubleValue());
        }
        return builder.m_22265_();
    }

    public ActionStateMachine buildStateMachine(ActionListener entity) {
        if (this.actionControllers != null) {
            ActionController[] controllers = new ActionController[this.actionControllers.size()];
            int index = 0;
            for (Map.Entry<String, List<ActionState>> entry : this.actionControllers.entrySet()) {
                String controllerName = entry.getKey();
                List<ActionState> actionStates = entry.getValue();
                controllers[index] = new ActionController(entity, controllerName, actionStates.toArray(new ActionState[actionStates.size()]));
                ++index;
            }
            return new ActionStateMachine(controllers);
        }
        return new ActionStateMachine(new ActionController[0]);
    }

    public ResourceLocation getConfigPath() {
        return this.configPath;
    }

    public NumberProperty getPushModifier() {
        return this.pushModifier;
    }

    public NumberProperty getStepHeight() {
        return this.stepHeight;
    }

    public NumberProperty getExperienceDrop() {
        return this.experienceDrop;
    }

    public MobSpawnData getMobSpawn() {
        return this.mobSpawn;
    }

    public MobFoodRation getFoodRation() {
        return this.foodRation;
    }

    public MobSchedule getMobSchedule() {
        return this.mobSchedule;
    }

    public MobAIBuilder getMobAI() {
        return this.mobAI;
    }

    public InputMap getInputMap() {
        return this.inputMap;
    }

    public MobTameMethod getTameMethod() {
        return this.tameMethod;
    }

    public Map<String, RandomSelectAction> getRandomSelectActions() {
        return this.randomSelectActions;
    }

    public Map<String, ConditionalSelectAction> getConditionalActions() {
        return this.conditionalActions;
    }

    public boolean isRequiresSaddle() {
        return this.requiresSaddle;
    }

    public boolean isCanWearArmor() {
        return this.canWearArmor;
    }

    public boolean isTamable() {
        return this.tamable;
    }

    public boolean isRideable() {
        return this.rideable;
    }

    public static <T extends MobProperties> Supplier<T> build(Class<T> propertiesClass, ResourceLocation path) {
        try {
            MobProperties properties = (MobProperties)propertiesClass.getConstructor(ResourceLocation.class).newInstance(path);
            properties.loadFromConfig();
            return () -> properties;
        }
        catch (Exception e) {
            throw new JsonParseException("Invalid mob properties " + path + ".\nException: " + e.getMessage());
        }
    }
}

