/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.properties.ai;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import ru.xishnikus.thedawnera.common.entity.ai.goal.CustomGoal;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.properties.ai.TDECustomGoalFactories;
import ru.xishnikus.thedawnera.common.entity.properties.misc.MobCondition;
import ru.xishnikus.thedawnera.common.io.json.TDEJsonUtils;

public abstract class CustomGoalFactory<T extends CustomGoal<? extends BaseAnimal>> {
    protected Predicate<BaseAnimal> canUse = mob -> true;
    protected Predicate<BaseAnimal> canContinueUse = mob -> true;
    protected boolean shouldCanBeUsedToContinue;

    public abstract T create(BaseAnimal var1);

    public void deserialize(JsonObject json) {
    }

    public void setup(BaseAnimal animal, T goal) {
        ((CustomGoal)((Object)goal)).setCanUseCondition(() -> this.canUse.test(animal));
        ((CustomGoal)((Object)goal)).setCanContinueUseCondition(() -> this.canContinueUse.test(animal));
        ((CustomGoal)((Object)goal)).setShouldCanBeUsedToContinue(this.shouldCanBeUsedToContinue);
    }

    public static class Deserializer
    implements JsonDeserializer<CustomGoalFactory<?>> {
        public CustomGoalFactory<?> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                JsonObject jsonObject = json.getAsJsonObject();
                String id = jsonObject.get("ID").getAsString();
                Object builder = TDECustomGoalFactories.createFactory(new ResourceLocation(id));
                if (jsonObject.has("CanUse")) {
                    ((CustomGoalFactory)builder).canUse = MobCondition.parsePredicate(BaseAnimal.class, jsonObject, "CanUse");
                }
                if (jsonObject.has("CanContinueUse")) {
                    ((CustomGoalFactory)builder).canContinueUse = MobCondition.parsePredicate(BaseAnimal.class, jsonObject, "CanContinueUse");
                }
                if (jsonObject.has("ShouldCanBeUsedToContinue")) {
                    ((CustomGoalFactory)builder).shouldCanBeUsedToContinue = jsonObject.get("ShouldCanBeUsedToContinue").getAsBoolean();
                }
                TDEJsonUtils.loadAllJsonFields(jsonObject, builder);
                ((CustomGoalFactory)builder).deserialize(jsonObject);
                return builder;
            }
            throw new JsonParseException("Invalid entity goal " + json);
        }
    }
}

