/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.properties.ai;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import ru.xishnikus.thedawnera.common.entity.ai.goal.CustomTargetGoal;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.properties.ai.CustomGoalFactory;
import ru.xishnikus.thedawnera.common.entity.properties.ai.TDECustomGoalFactories;
import ru.xishnikus.thedawnera.common.entity.properties.misc.MobCondition;
import ru.xishnikus.thedawnera.common.entity.properties.misc.NumberProperty;
import ru.xishnikus.thedawnera.common.io.json.TDEJsonUtils;

public class CustomTargetGoalFactory<T extends CustomTargetGoal<? extends BaseAnimal>>
extends CustomGoalFactory<T> {
    protected Predicate<Entity> canTargetEntity = target -> true;
    private NumberProperty unseenMemoryTicks = NumberProperty.uniform(400.0);
    protected boolean mustReach = false;
    protected boolean mustSee = true;

    @Override
    public T create(BaseAnimal animal) {
        return null;
    }

    @Override
    public void setup(BaseAnimal animal, T goal) {
        super.setup(animal, goal);
        ((CustomTargetGoal)((Object)goal)).setUnseenMemoryTicks(this.unseenMemoryTicks.getInt());
        ((CustomTargetGoal)((Object)goal)).setMustReach(this.mustReach);
        ((CustomTargetGoal)((Object)goal)).setMustSee(this.mustSee);
        ((CustomTargetGoal)((Object)goal)).setCanTargetCondition(this.canTargetEntity);
    }

    public static class Deserializer
    implements JsonDeserializer<CustomTargetGoalFactory<?>> {
        public CustomTargetGoalFactory<?> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                JsonObject jsonObject = json.getAsJsonObject();
                String id = jsonObject.get("ID").getAsString();
                CustomTargetGoalFactory builder = (CustomTargetGoalFactory)TDECustomGoalFactories.createFactory(new ResourceLocation(id));
                if (jsonObject.has("CanUse")) {
                    builder.canUse = MobCondition.parsePredicate(BaseAnimal.class, jsonObject, "CanUse");
                }
                if (jsonObject.has("CanContinueUse")) {
                    builder.canContinueUse = MobCondition.parsePredicate(BaseAnimal.class, jsonObject, "CanContinueUse");
                }
                if (jsonObject.has("TargetConditions")) {
                    builder.canTargetEntity = MobCondition.parsePredicate(Entity.class, jsonObject, "TargetConditions");
                }
                if (jsonObject.has("ShouldCanBeUsedToContinue")) {
                    builder.shouldCanBeUsedToContinue = jsonObject.get("ShouldCanBeUsedToContinue").getAsBoolean();
                }
                if (jsonObject.has("MushReach")) {
                    builder.mustReach = jsonObject.get("MushReach").getAsBoolean();
                }
                if (jsonObject.has("MushSee")) {
                    builder.mustSee = jsonObject.get("MushSee").getAsBoolean();
                }
                if (jsonObject.has("MemoryTicks")) {
                    builder.unseenMemoryTicks = TDEJsonUtils.parseNumber(jsonObject, "MemoryTicks");
                }
                TDEJsonUtils.loadAllJsonFields(jsonObject, builder);
                builder.deserialize(jsonObject);
                return builder;
            }
            throw new JsonParseException("Invalid entity target goal " + json);
        }
    }
}

