/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.properties.misc;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.world.entity.Mob;
import ru.astemir.astemirlib.common.action.ActionController;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.properties.MobProperties;
import ru.xishnikus.thedawnera.common.entity.properties.misc.MobCondition;

public class ConditionalSelectAction {
    private Map<String, Predicate<Mob>> actions = new HashMap<String, Predicate<Mob>>();

    public void add(String action, Predicate<Mob> predicate) {
        this.actions.put(action, predicate);
    }

    public void playConditional(BaseAnimal entity, String actionControllerName) {
        for (Map.Entry<String, Predicate<Mob>> entry : this.actions.entrySet()) {
            if (!entry.getValue().test((Mob)entity)) continue;
            String actionName = entry.getKey();
            ActionController controller = entity.getActionStateMachine().getController(actionControllerName);
            if (controller.getActionByName(actionName) != null) {
                controller.playAction(actionName);
            } else {
                Object properties = entity.getProperties();
                ((MobProperties)properties).getRandomSelectActions().get(actionName).playRandom(entity);
            }
            return;
        }
    }

    public static class Deserializer
    implements JsonDeserializer<ConditionalSelectAction> {
        public ConditionalSelectAction deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonArray()) {
                ConditionalSelectAction conditionalSelectAction = new ConditionalSelectAction();
                JsonArray jsonArray = json.getAsJsonArray();
                for (JsonElement element : jsonArray) {
                    if (!element.isJsonObject()) continue;
                    JsonObject actionJson = element.getAsJsonObject();
                    Predicate<Mob> predicate = MobCondition.parsePredicate(Mob.class, actionJson, "Conditions");
                    conditionalSelectAction.add(actionJson.get("Action").getAsString(), predicate);
                }
                return conditionalSelectAction;
            }
            return new ConditionalSelectAction();
        }
    }
}

