/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.properties.misc;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.properties.ai.CustomGoalFactory;
import ru.xishnikus.thedawnera.common.entity.properties.ai.CustomTargetGoalFactory;
import ru.xishnikus.thedawnera.common.io.json.TDEJsonUtils;

public class MobAIBuilder {
    public Map<CustomGoalFactory<?>, Integer> goals = new HashMap();
    public Map<CustomGoalFactory<?>, Integer> targetGoals = new HashMap();

    public void build(BaseAnimal baseAnimal) {
        this.buildGoals(baseAnimal);
        this.buildTargetGoals(baseAnimal);
    }

    private void buildGoals(BaseAnimal mob) {
        for (Map.Entry<CustomGoalFactory<?>, Integer> entry : this.goals.entrySet()) {
            int priority = entry.getValue();
            CustomGoalFactory<?> builder = entry.getKey();
            Object goal = builder.create(mob);
            builder.setup(mob, goal);
            mob.f_21345_.m_25352_(priority, goal);
        }
    }

    private void buildTargetGoals(BaseAnimal mob) {
        for (Map.Entry<CustomGoalFactory<?>, Integer> entry : this.targetGoals.entrySet()) {
            int priority = entry.getValue();
            CustomGoalFactory<?> builder = entry.getKey();
            Object goal = builder.create(mob);
            builder.setup(mob, goal);
            mob.f_21346_.m_25352_(priority, goal);
        }
    }

    public static class Deserializer
    implements JsonDeserializer<MobAIBuilder> {
        private static Map<CustomGoalFactory<?>, Integer> parseAIGoals(JsonObject json, Class<? extends CustomGoalFactory> factoryClass, String name) {
            HashMap goals = new HashMap();
            JsonElement element = json.get(name);
            if (element.isJsonArray()) {
                try {
                    for (JsonElement jsonElement : element.getAsJsonArray()) {
                        JsonObject jsonObject;
                        int priority = 0;
                        if (jsonElement instanceof JsonObject && (jsonObject = (JsonObject)jsonElement).has("Priority")) {
                            priority = jsonObject.get("Priority").getAsInt();
                        }
                        goals.put((CustomGoalFactory)TDEJsonUtils.GSON.fromJson(jsonElement, factoryClass), priority);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return goals;
        }

        public MobAIBuilder deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonObject = json.getAsJsonObject();
            MobAIBuilder ai = new MobAIBuilder();
            if (jsonObject.has("Goals")) {
                ai.goals = Deserializer.parseAIGoals(jsonObject, CustomGoalFactory.class, "Goals");
            }
            if (jsonObject.has("TargetGoals")) {
                ai.targetGoals = Deserializer.parseAIGoals(jsonObject, CustomTargetGoalFactory.class, "TargetGoals");
            }
            return ai;
        }
    }
}

