/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.properties.misc;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.StringUtils;
import ru.astemir.astemirlib.common.math.AVector3f;
import ru.xishnikus.thedawnera.common.entity.data.MobOrder;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseSleepingAnimal;
import ru.xishnikus.thedawnera.common.entity.properties.MobProperties;
import ru.xishnikus.thedawnera.common.entity.properties.misc.ConditionalSelectAction;
import ru.xishnikus.thedawnera.common.entity.properties.misc.RandomSelectAction;

public class MobAction {
    public static Map<ResourceLocation, Executor> actionExecutors = new HashMap<ResourceLocation, Executor>();
    private String[] args;
    private Executor executor;

    public MobAction(String[] args, Executor executor) {
        this.args = args;
        this.executor = executor;
    }

    public void run(Mob mob) {
        this.executor.execute(mob, this.args, new Object[0]);
    }

    public void run(Mob mob, Object ... executeArgs) {
        this.executor.execute(mob, this.args, executeArgs);
    }

    public static void register(ResourceLocation name, Executor executor) {
        actionExecutors.put(name, executor);
    }

    public static MobAction parse(String str) {
        for (Map.Entry<ResourceLocation, Executor> entry : actionExecutors.entrySet()) {
            String id = StringUtils.substringBefore((String)str, (String)",");
            if (!entry.getKey().toString().equals(id)) continue;
            String[] args = new String[]{};
            if (str.contains(",")) {
                args = StringUtils.substringAfter((String)str, (String)",").split(",");
            }
            return new MobAction(args, entry.getValue());
        }
        throw new IllegalStateException("Invalid mob action: %s".formatted(str));
    }

    public static MobAction parseFromJson(JsonElement element) {
        JsonPrimitive primitive;
        if (element.isJsonPrimitive() && (primitive = element.getAsJsonPrimitive()).isString()) {
            return MobAction.parse(primitive.getAsString());
        }
        throw new JsonParseException("Failed to parse mob schedule action " + element);
    }

    public static List<MobAction> parseListFromJson(JsonObject jsonObject, String name) {
        ArrayList<MobAction> actions = new ArrayList<MobAction>();
        if (jsonObject.has(name)) {
            JsonElement actionsJson = jsonObject.get(name);
            if (actionsJson.isJsonArray()) {
                JsonArray actionsJsonArray = actionsJson.getAsJsonArray();
                for (JsonElement jsonElement : actionsJsonArray) {
                    actions.add(MobAction.parseFromJson(jsonElement));
                }
            } else if (actionsJson.isJsonPrimitive()) {
                actions.add(MobAction.parseFromJson(actionsJson));
            }
        }
        return actions;
    }

    static {
        MobAction.register(new ResourceLocation("dawnera", "lie_down"), (mob, args, execArgs) -> {
            if (mob instanceof BaseSleepingAnimal) {
                BaseSleepingAnimal sleepingDino = (BaseSleepingAnimal)mob;
                if (sleepingDino.isTamed() && sleepingDino.getMovementOrderType() == MobOrder.Movement.FOLLOW) {
                    return;
                }
                if (!sleepingDino.isSleepingOrResting()) {
                    sleepingDino.lieDownOrSleep(false);
                }
            }
        });
        MobAction.register(new ResourceLocation("dawnera", "sleep"), (mob, args, execArgs) -> {
            if (mob instanceof BaseSleepingAnimal) {
                BaseSleepingAnimal sleepingDino = (BaseSleepingAnimal)mob;
                if (sleepingDino.isTamed() && sleepingDino.getMovementOrderType() == MobOrder.Movement.FOLLOW) {
                    return;
                }
                if (!sleepingDino.m_5803_()) {
                    sleepingDino.lieDownOrSleep(true);
                }
            }
        });
        MobAction.register(new ResourceLocation("dawnera", "wake_up"), (mob, args, execArgs) -> {
            BaseSleepingAnimal sleepingDino;
            if (mob instanceof BaseSleepingAnimal && (sleepingDino = (BaseSleepingAnimal)mob).m_5803_()) {
                sleepingDino.standOrWakeUp(false);
            }
        });
        MobAction.register(new ResourceLocation("dawnera", "stand_up"), (mob, args, execArgs) -> {
            if (mob instanceof BaseSleepingAnimal) {
                BaseSleepingAnimal sleepingDino = (BaseSleepingAnimal)mob;
                if (sleepingDino.isTamed() && sleepingDino.getMovementOrderType() == MobOrder.Movement.WAIT) {
                    return;
                }
                if (sleepingDino.isSleepingOrResting()) {
                    sleepingDino.standOrWakeUp(true);
                }
            }
        });
        MobAction.register(new ResourceLocation("dawnera", "play_action"), (mob, args, execArgs) -> {
            if (mob instanceof BaseAnimal) {
                BaseAnimal baseAnimal = (BaseAnimal)mob;
                if (args.length < 2) {
                    throw new RuntimeException("Invalid action execution, arguments not provided.");
                }
                baseAnimal.getActionStateMachine().getController(args[0]).playAction(args[1]);
            }
        });
        MobAction.register(new ResourceLocation("dawnera", "stop_action"), (mob, args, execArgs) -> {
            if (mob instanceof BaseAnimal) {
                BaseAnimal baseAnimal = (BaseAnimal)mob;
                if (args.length < 1) {
                    throw new RuntimeException("Invalid action execution, arguments are not provided.");
                }
                baseAnimal.getActionStateMachine().getController(args[0]).setNoState();
            }
        });
        MobAction.register(new ResourceLocation("dawnera", "focus_on_target"), (mob, args, execArgs) -> {
            if (mob instanceof BaseAnimal) {
                BaseAnimal baseAnimal = (BaseAnimal)mob;
                if (execArgs.length < 1) {
                    throw new RuntimeException("Invalid action execution, arguments are not provided.");
                }
                baseAnimal.setLastAttackTarget((LivingEntity)execArgs[0]);
            }
        });
        MobAction.register(new ResourceLocation("dawnera", "look_at_target"), (mob, args, execArgs) -> mob.m_7618_(EntityAnchorArgument.Anchor.EYES, ((Entity)execArgs[0]).m_20182_()));
        MobAction.register(new ResourceLocation("dawnera", "look_at_pos"), (mob, args, execArgs) -> mob.m_7618_(EntityAnchorArgument.Anchor.EYES, ((BlockPos)execArgs[0]).m_252807_()));
        MobAction.register(new ResourceLocation("dawnera", "stop_navigation"), (mob, args, execArgs) -> mob.m_21573_().m_26573_());
        MobAction.register(new ResourceLocation("dawnera", "anger_particles"), (mob, args, execArgs) -> {
            if (!mob.m_9236_().f_46443_) {
                for (int i = 0; i < 20; ++i) {
                    ((ServerLevel)mob.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123792_, mob.m_20208_(0.5), mob.m_20187_(), mob.m_20262_(0.5), 1, 0.0, 0.0, 0.0, (double)0.1f);
                }
            }
        });
        MobAction.register(new ResourceLocation("dawnera", "delay_sleep"), (mob, args, execArgs) -> {
            if (mob instanceof BaseSleepingAnimal) {
                BaseSleepingAnimal sleepingAnimal = (BaseSleepingAnimal)mob;
                if (args.length < 2) {
                    throw new RuntimeException("Invalid action execution, arguments are not provided.");
                }
                sleepingAnimal.delaySleeping(Integer.parseInt(args[0]), Integer.parseInt(args[1]));
            }
        });
        MobAction.register(new ResourceLocation("dawnera", "play_random_action"), (mob, args, execArgs) -> {
            if (mob instanceof BaseAnimal) {
                BaseAnimal baseAnimal = (BaseAnimal)mob;
                if (args.length < 2) {
                    throw new RuntimeException("Invalid action execution, arguments are not provided.");
                }
                Map<String, RandomSelectAction> actions = ((MobProperties)baseAnimal.getProperties()).getRandomSelectActions();
                if (actions.containsKey(args[1])) {
                    actions.get(args[1]).playRandom(baseAnimal, args[0]);
                }
            }
        });
        MobAction.register(new ResourceLocation("dawnera", "play_conditional_action"), (mob, args, execArgs) -> {
            if (mob instanceof BaseAnimal) {
                BaseAnimal baseAnimal = (BaseAnimal)mob;
                if (args.length < 2) {
                    throw new RuntimeException("Invalid action execution, arguments are not provided.");
                }
                Map<String, ConditionalSelectAction> actions = ((MobProperties)baseAnimal.getProperties()).getConditionalActions();
                if (actions.containsKey(args[1])) {
                    actions.get(args[1]).playConditional(baseAnimal, args[0]);
                }
            }
        });
        MobAction.register(new ResourceLocation("dawnera", "motion_to_pos"), (mob, args, execArgs) -> {
            if (args.length < 1 || execArgs.length < 1) {
                throw new RuntimeException("Invalid action execution, arguments are not provided.");
            }
            mob.m_20256_(AVector3f.from((Vec3)mob.m_20182_()).direction(AVector3f.from((BlockPos)((BlockPos)execArgs[0]))).mul(Float.parseFloat(args[0])).toVec3());
        });
    }

    public static interface Executor {
        public void execute(Mob var1, String[] var2, Object[] var3);
    }
}

