/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.properties.misc;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;
import ru.astemir.astemirlib.common.entity.EntityUtils;
import ru.astemir.astemirlib.common.math.RandomUtils;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseSleepingAnimal;
import ru.xishnikus.thedawnera.common.entity.entity.base.PackMob;
import ru.xishnikus.thedawnera.common.entity.entity.base.ScaredMob;
import ru.xishnikus.thedawnera.common.entity.entity.ground.EntityDimorphodon;
import ru.xishnikus.thedawnera.common.misc.TDETags;

public class MobCondition {
    public static Map<ResourceLocation, Predictor> conditionPredictors = new HashMap<ResourceLocation, Predictor>();
    private String[] args;
    private Predictor predictor;

    public MobCondition(String[] args, Predictor predictor) {
        this.args = args;
        this.predictor = predictor;
    }

    public <T extends Entity> Predicate<T> predicate(Class<T> entityClass) {
        return e -> this.predictor.test((Entity)e, this.args);
    }

    public static void register(ResourceLocation name, Predictor predictor) {
        conditionPredictors.put(name, predictor);
    }

    public static MobCondition parse(String str) {
        for (Map.Entry<ResourceLocation, Predictor> entry : conditionPredictors.entrySet()) {
            String id = StringUtils.substringBefore((String)str, (String)",");
            if (!entry.getKey().toString().equals(id)) continue;
            String[] args = new String[]{};
            if (str.contains(",")) {
                args = StringUtils.substringAfter((String)str, (String)",").split(",");
            }
            return new MobCondition(args, entry.getValue());
        }
        throw new IllegalStateException("Invalid mob condition: %s".formatted(str));
    }

    public static MobCondition parseFromJson(JsonElement element) {
        JsonPrimitive primitive;
        if (element.isJsonPrimitive() && (primitive = element.getAsJsonPrimitive()).isString()) {
            return MobCondition.parse(primitive.getAsString());
        }
        throw new JsonParseException("Failed to parse mob condition " + element);
    }

    public static List<MobCondition> parseListFromJson(JsonObject jsonObject, String name) {
        ArrayList<MobCondition> conditions = new ArrayList<MobCondition>();
        if (jsonObject.has(name)) {
            JsonElement conditionsJson = jsonObject.get(name);
            if (conditionsJson.isJsonArray()) {
                JsonArray conditionsJsonArray = conditionsJson.getAsJsonArray();
                for (JsonElement jsonElement : conditionsJsonArray) {
                    conditions.add(MobCondition.parseFromJson(jsonElement));
                }
            } else if (conditionsJson.isJsonPrimitive()) {
                conditions.add(MobCondition.parseFromJson(conditionsJson));
            }
        }
        return conditions;
    }

    public static <T extends Entity> Predicate<T> parsePredicate(Class<T> entityClass, JsonObject jsonObject, String name) {
        if (jsonObject.has(name)) {
            Predicate<Object> predicate = null;
            JsonElement element = jsonObject.get(name);
            if (element.isJsonArray()) {
                List<MobCondition> conditions = MobCondition.parseListFromJson(jsonObject, name);
                if (!conditions.isEmpty()) {
                    if (predicate == null) {
                        predicate = conditions.get(0).predicate(entityClass);
                    }
                    for (int i = 1; i < conditions.size(); ++i) {
                        predicate = predicate.and(conditions.get(i).predicate(entityClass));
                    }
                } else {
                    predicate = p -> true;
                }
                return predicate;
            }
            if (element.isJsonPrimitive()) {
                String[] tokens = element.getAsString().split("\\s+");
                for (int i = 0; i < tokens.length; i += 2) {
                    Predicate<T> currentPredicate = MobCondition.parse(tokens[i]).predicate(entityClass);
                    if (predicate == null) {
                        predicate = currentPredicate;
                        continue;
                    }
                    if (tokens[i - 1].equals("&&")) {
                        predicate = predicate.and(currentPredicate);
                        continue;
                    }
                    if (!tokens[i - 1].equals("||")) continue;
                    predicate = predicate.or(currentPredicate);
                }
                return predicate;
            }
        }
        return m -> true;
    }

    static {
        MobCondition.register(new ResourceLocation("dawnera", "has_no_target"), (entity, args) -> {
            if (entity instanceof Mob) {
                Mob mob = (Mob)entity;
                return !EntityUtils.isEntityExist((Entity)mob.m_5448_());
            }
            return true;
        });
        MobCondition.register(new ResourceLocation("dawnera", "has_no_rider"), (entity, args) -> entity.m_6688_() == null);
        MobCondition.register(new ResourceLocation("dawnera", "is_alive"), (entity, args) -> entity.m_6084_());
        MobCondition.register(new ResourceLocation("dawnera", "is_baby"), (entity, args) -> {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                return livingEntity.m_6162_();
            }
            return false;
        });
        MobCondition.register(new ResourceLocation("dawnera", "is_grown_up"), (entity, args) -> {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                return !livingEntity.m_6162_();
            }
            return true;
        });
        MobCondition.register(new ResourceLocation("dawnera", "has_item"), (entity, args) -> {
            if (args.length < 2) {
                throw new RuntimeException("Invalid condition call arguments are not provided");
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                EquipmentSlot slot = EquipmentSlot.m_20747_((String)args[0]);
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(args[1]));
                return livingEntity.m_6844_(slot).m_150930_(item);
            }
            return false;
        });
        MobCondition.register(new ResourceLocation("dawnera", "has_turtle_helmet"), (entity, args) -> {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                return livingEntity.m_6844_(EquipmentSlot.HEAD).m_150930_(Items.f_42354_.m_5456_());
            }
            return false;
        });
        MobCondition.register(new ResourceLocation("dawnera", "is_on_ground"), (entity, args) -> entity.m_20096_());
        MobCondition.register(new ResourceLocation("dawnera", "is_not_on_ground"), (entity, args) -> !entity.m_20096_());
        MobCondition.register(new ResourceLocation("dawnera", "is_in_water"), (entity, args) -> entity.m_20069_());
        MobCondition.register(new ResourceLocation("dawnera", "is_not_in_water"), (entity, args) -> !entity.m_20069_());
        MobCondition.register(new ResourceLocation("dawnera", "has_panic"), (entity, args) -> {
            if (entity instanceof ScaredMob) {
                ScaredMob scaredMob = (ScaredMob)entity;
                return scaredMob.isScared();
            }
            return false;
        });
        MobCondition.register(new ResourceLocation("dawnera", "has_no_panic"), (entity, args) -> {
            if (entity instanceof ScaredMob) {
                ScaredMob scaredMob = (ScaredMob)entity;
                return !scaredMob.isScared();
            }
            return true;
        });
        MobCondition.register(new ResourceLocation("dawnera", "is_no_action"), (entity, args) -> {
            if (entity instanceof BaseAnimal) {
                BaseAnimal baseAnimal = (BaseAnimal)entity;
                return baseAnimal.actionController.isNoAction();
            }
            return true;
        });
        MobCondition.register(new ResourceLocation("dawnera", "is_no_action_or_state"), (entity, args) -> {
            if (entity instanceof BaseAnimal) {
                BaseAnimal baseAnimal = (BaseAnimal)entity;
                return baseAnimal.actionController.isNoAction();
            }
            return true;
        });
        MobCondition.register(new ResourceLocation("dawnera", "is_pregnant"), (entity, args) -> {
            if (entity instanceof BaseAnimal) {
                BaseAnimal baseAnimal = (BaseAnimal)entity;
                return baseAnimal.isPregnant();
            }
            return false;
        });
        MobCondition.register(new ResourceLocation("dawnera", "is_not_pregnant"), (entity, args) -> {
            if (entity instanceof BaseAnimal) {
                BaseAnimal baseAnimal = (BaseAnimal)entity;
                return !baseAnimal.isPregnant();
            }
            return true;
        });
        MobCondition.register(new ResourceLocation("dawnera", "is_tamed"), (entity, args) -> {
            if (entity instanceof BaseAnimal) {
                BaseAnimal baseAnimal = (BaseAnimal)entity;
                return baseAnimal.isTamed();
            }
            if (entity instanceof TamableAnimal) {
                TamableAnimal tamableAnimal = (TamableAnimal)entity;
                return tamableAnimal.m_21824_();
            }
            return false;
        });
        MobCondition.register(new ResourceLocation("dawnera", "is_not_tamed"), (entity, args) -> {
            if (entity instanceof BaseAnimal) {
                BaseAnimal baseAnimal = (BaseAnimal)entity;
                return !baseAnimal.isTamed();
            }
            if (entity instanceof TamableAnimal) {
                TamableAnimal tamableAnimal = (TamableAnimal)entity;
                return !tamableAnimal.m_21824_();
            }
            return true;
        });
        MobCondition.register(new ResourceLocation("dawnera", "is_sleeping_or_resting"), (entity, args) -> {
            if (entity instanceof BaseSleepingAnimal) {
                BaseSleepingAnimal baseSleepingAnimal = (BaseSleepingAnimal)entity;
                return baseSleepingAnimal.isSleepingOrResting();
            }
            return false;
        });
        MobCondition.register(new ResourceLocation("dawnera", "is_not_sleeping_or_resting"), (entity, args) -> {
            if (entity instanceof BaseSleepingAnimal) {
                BaseSleepingAnimal baseSleepingAnimal = (BaseSleepingAnimal)entity;
                return !baseSleepingAnimal.isSleepingOrResting();
            }
            return true;
        });
        MobCondition.register(new ResourceLocation("dawnera", "is_sleeping"), (entity, args) -> {
            if (entity instanceof BaseSleepingAnimal) {
                BaseSleepingAnimal baseSleepingAnimal = (BaseSleepingAnimal)entity;
                return baseSleepingAnimal.m_5803_();
            }
            return false;
        });
        MobCondition.register(new ResourceLocation("dawnera", "is_not_sleeping"), (entity, args) -> {
            if (entity instanceof BaseSleepingAnimal) {
                BaseSleepingAnimal baseSleepingAnimal = (BaseSleepingAnimal)entity;
                return !baseSleepingAnimal.m_5803_();
            }
            return true;
        });
        MobCondition.register(new ResourceLocation("dawnera", "is_flying"), (entity, args) -> {
            if (entity instanceof EntityDimorphodon) {
                EntityDimorphodon entityDimorphodon = (EntityDimorphodon)entity;
                return entityDimorphodon.isFlying();
            }
            return false;
        });
        MobCondition.register(new ResourceLocation("dawnera", "is_not_flying"), (entity, args) -> {
            if (entity instanceof EntityDimorphodon) {
                EntityDimorphodon entityDimorphodon = (EntityDimorphodon)entity;
                return !entityDimorphodon.isFlying();
            }
            return true;
        });
        MobCondition.register(new ResourceLocation("dawnera", "is_entity_type"), (entity, args) -> {
            if (args.length < 1) {
                throw new RuntimeException("Invalid condition call arguments are not provided");
            }
            return entity.m_6095_() == ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(args[0]));
        });
        MobCondition.register(new ResourceLocation("dawnera", "is_not_entity_type"), (entity, args) -> {
            if (args.length < 1) {
                throw new RuntimeException("Invalid condition call arguments are not provided");
            }
            return entity.m_6095_() != ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(args[0]));
        });
        MobCondition.register(new ResourceLocation("dawnera", "random_chance"), (entity, args) -> {
            if (args.length < 1) {
                throw new RuntimeException("Invalid condition call arguments are not provided");
            }
            return RandomUtils.doWithChance((float)Float.parseFloat(args[0]));
        });
        MobCondition.register(new ResourceLocation("dawnera", "distance_to_target"), (entity, args) -> {
            if (args.length < 2) {
                throw new RuntimeException("Invalid condition call arguments are not provided");
            }
            if (entity instanceof BaseAnimal) {
                BaseAnimal baseAnimal = (BaseAnimal)entity;
                String sign = args[0];
                double distance = Double.parseDouble(args[1]);
                switch (sign) {
                    case ">": {
                        return (double)baseAnimal.distanceToTarget() > distance;
                    }
                    case ">=": {
                        return (double)baseAnimal.distanceToTarget() >= distance;
                    }
                    case "<": {
                        return (double)baseAnimal.distanceToTarget() < distance;
                    }
                    case "<=": {
                        return (double)baseAnimal.distanceToTarget() <= distance;
                    }
                    case "==": {
                        return (double)baseAnimal.distanceToTarget() == distance;
                    }
                }
            }
            return false;
        });
        MobCondition.register(new ResourceLocation("dawnera", "is_air"), (entity, args) -> {
            if (args.length < 2) {
                throw new RuntimeException("Invalid condition call arguments are not provided");
            }
            if (entity instanceof BaseAnimal) {
                BaseAnimal baseAnimal = (BaseAnimal)entity;
                String sign = args[0];
                double air = Double.parseDouble(args[1]);
                switch (sign) {
                    case ">": {
                        return (double)baseAnimal.m_20146_() > air;
                    }
                    case ">=": {
                        return (double)baseAnimal.m_20146_() >= air;
                    }
                    case "<": {
                        return (double)baseAnimal.m_20146_() < air;
                    }
                    case "<=": {
                        return (double)baseAnimal.m_20146_() <= air;
                    }
                    case "==": {
                        return (double)baseAnimal.m_20146_() == air;
                    }
                }
            }
            return false;
        });
        MobCondition.register(new ResourceLocation("dawnera", "is_pack_size"), (entity, args) -> {
            if (args.length < 2) {
                throw new RuntimeException("Invalid condition call arguments are not provided");
            }
            if (entity instanceof PackMob) {
                PackMob packMob = (PackMob)entity;
                String sign = args[0];
                int size = Integer.parseInt(args[1]);
                switch (sign) {
                    case ">": {
                        return packMob.getPackSize() > size;
                    }
                    case ">=": {
                        return packMob.getPackSize() >= size;
                    }
                    case "<": {
                        return packMob.getPackSize() < size;
                    }
                    case "<=": {
                        return packMob.getPackSize() <= size;
                    }
                    case "==": {
                        return packMob.getPackSize() == size;
                    }
                }
            }
            return false;
        });
        MobCondition.register(new ResourceLocation("dawnera", "is_player"), (entity, args) -> entity.m_6095_() == EntityType.f_20532_);
        MobCondition.register(new ResourceLocation("dawnera", "is_not_player"), (entity, args) -> entity.m_6095_() != EntityType.f_20532_);
        MobCondition.register(new ResourceLocation("dawnera", "is_small"), (entity, args) -> entity.m_6095_().m_204039_(TDETags.Entities.SMALL_ANIMAL));
        MobCondition.register(new ResourceLocation("dawnera", "is_not_small"), (entity, args) -> !entity.m_6095_().m_204039_(TDETags.Entities.SMALL_ANIMAL));
        MobCondition.register(new ResourceLocation("dawnera", "is_medium"), (entity, args) -> entity.m_6095_().m_204039_(TDETags.Entities.MEDIUM_ANIMAL));
        MobCondition.register(new ResourceLocation("dawnera", "is_not_medium"), (entity, args) -> !entity.m_6095_().m_204039_(TDETags.Entities.MEDIUM_ANIMAL));
        MobCondition.register(new ResourceLocation("dawnera", "is_big"), (entity, args) -> entity.m_6095_().m_204039_(TDETags.Entities.BIG_ANIMAL));
        MobCondition.register(new ResourceLocation("dawnera", "is_not_big"), (entity, args) -> !entity.m_6095_().m_204039_(TDETags.Entities.BIG_ANIMAL));
        MobCondition.register(new ResourceLocation("dawnera", "is_giant"), (entity, args) -> entity.m_6095_().m_204039_(TDETags.Entities.GIANT_ANIMAL));
        MobCondition.register(new ResourceLocation("dawnera", "is_not_giant"), (entity, args) -> !entity.m_6095_().m_204039_(TDETags.Entities.GIANT_ANIMAL));
    }

    public static interface Predictor {
        public boolean test(Entity var1, String[] var2);
    }
}

