/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.properties.misc;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import ru.xishnikus.thedawnera.common.entity.properties.predicate.EntityTypePredicate;
import ru.xishnikus.thedawnera.common.entity.properties.predicate.ItemPredicate;

public class MobFoodRation {
    private List<EntityTypePredicate> entityList;
    private List<ItemPredicate> itemList;
    private boolean cannibalism;

    public MobFoodRation(List<EntityTypePredicate> entityList, List<ItemPredicate> itemList, boolean cannibalism) {
        this.entityList = entityList;
        this.itemList = itemList;
        this.cannibalism = cannibalism;
    }

    public boolean canBeEaten(LivingEntity mob, ItemStack itemStack) {
        for (ItemPredicate foodItem : this.itemList) {
            if (!foodItem.test(mob, itemStack)) continue;
            return true;
        }
        return false;
    }

    public boolean canBeEaten(LivingEntity mob, LivingEntity target) {
        for (EntityTypePredicate foodEntity : this.entityList) {
            if (!this.cannibalism && mob.m_6095_() == target.m_6095_()) {
                return false;
            }
            if (!foodEntity.test(mob, target)) continue;
            return true;
        }
        return false;
    }

    public static class Deserializer
    implements JsonDeserializer<MobFoodRation> {
        public MobFoodRation deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                JsonObject jsonObject = json.getAsJsonObject();
                boolean cannibalism = false;
                if (jsonObject.has("Cannibalism")) {
                    cannibalism = jsonObject.get("Cannibalism").getAsBoolean();
                }
                return new MobFoodRation(EntityTypePredicate.parseEntities(jsonObject, "Entities"), ItemPredicate.parseItems(jsonObject, "Items"), cannibalism);
            }
            throw new JsonParseException("Failed to parse mob food ration " + json);
        }
    }
}

