/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.properties.misc;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.time.LocalTime;
import java.util.LinkedList;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import ru.xishnikus.thedawnera.common.entity.properties.misc.MobCondition;
import ru.xishnikus.thedawnera.common.entity.properties.misc.MobScheduleTask;

public class MobSchedule {
    private LinkedList<MobScheduleTask> tasks;
    private Predicate<Entity> canUse;

    public MobSchedule(LinkedList<MobScheduleTask> tasks, Predicate<Entity> canUse) {
        this.tasks = tasks;
        this.canUse = canUse;
    }

    public void tick(Mob mob) {
        MobScheduleTask task;
        if (this.canUse.test((Entity)mob) && (task = this.getCurrentTask(mob)) != null) {
            task.run(mob);
        }
    }

    public LocalTime getCurrentTime(Mob mob) {
        Level level = mob.m_9236_();
        long gameTime = level.m_46468_();
        long hours = gameTime / 1000L + 6L;
        long minutes = gameTime % 1000L * 60L / 1000L;
        long hours24 = hours % 24L;
        return LocalTime.of((int)hours24, (int)minutes);
    }

    public MobScheduleTask getCurrentTask(Mob mob) {
        LocalTime currentTime = this.getCurrentTime(mob);
        for (MobScheduleTask task : this.tasks) {
            if (!task.isWithin(currentTime)) continue;
            return task;
        }
        return null;
    }

    public static class Deserializer
    implements JsonDeserializer<MobSchedule> {
        public MobSchedule deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                JsonObject jsonObject = json.getAsJsonObject();
                return new MobSchedule(MobScheduleTask.parseTasks(jsonObject, "Tasks"), MobCondition.parsePredicate(Entity.class, jsonObject, "Conditions"));
            }
            throw new JsonParseException("Failed to parse mob schedule " + json);
        }
    }
}

