/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.properties.misc;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;
import java.time.LocalTime;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.world.entity.Mob;
import ru.xishnikus.thedawnera.common.entity.properties.misc.MobAction;
import ru.xishnikus.thedawnera.common.io.json.TDEJsonUtils;

public class MobScheduleTask {
    private LocalTime from;
    private LocalTime to;
    private List<MobAction> actions;

    public MobScheduleTask(String from, String to, List<MobAction> actions) {
        this.from = LocalTime.parse(from);
        this.to = LocalTime.parse(to);
        this.actions = actions;
    }

    public void run(Mob mob) {
        for (MobAction action : this.actions) {
            action.run(mob);
        }
    }

    public boolean isWithin(LocalTime time) {
        LocalTime startTime = this.from;
        LocalTime endTime = this.to;
        if (startTime.isBefore(endTime)) {
            return !time.isBefore(startTime) && !time.isAfter(endTime);
        }
        return !time.isBefore(startTime) || !time.isAfter(endTime);
    }

    public LocalTime getFrom() {
        return this.from;
    }

    public LocalTime getTo() {
        return this.to;
    }

    public static LinkedList<MobScheduleTask> parseTasks(JsonObject jsonObject, String name) {
        LinkedList<MobScheduleTask> tasks = new LinkedList<MobScheduleTask>();
        if (jsonObject.has(name)) {
            JsonElement tasksJson = jsonObject.get(name);
            if (tasksJson.isJsonArray()) {
                JsonArray conditionsJsonArray = tasksJson.getAsJsonArray();
                for (JsonElement jsonElement : conditionsJsonArray) {
                    tasks.add((MobScheduleTask)TDEJsonUtils.GSON.fromJson(jsonElement, MobScheduleTask.class));
                }
            } else if (tasksJson.isJsonPrimitive()) {
                tasks.add((MobScheduleTask)TDEJsonUtils.GSON.fromJson(tasksJson, MobScheduleTask.class));
            }
        }
        return tasks;
    }

    public static class Deserializer
    implements JsonDeserializer<MobScheduleTask> {
        private String parseTime(JsonObject jsonObject, String name) {
            JsonPrimitive primitive;
            JsonElement element;
            if (jsonObject.has(name) && (element = jsonObject.get(name)).isJsonPrimitive() && (primitive = element.getAsJsonPrimitive()).isString()) {
                return primitive.getAsString();
            }
            throw new JsonParseException("Failed to parse mob schedule time " + name + " " + jsonObject);
        }

        public MobScheduleTask deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                JsonObject jsonObject = json.getAsJsonObject();
                return new MobScheduleTask(this.parseTime(jsonObject, "Start"), this.parseTime(jsonObject, "End"), MobAction.parseListFromJson(jsonObject, "Actions"));
            }
            throw new JsonParseException("Failed to parse mob schedule task " + json);
        }
    }
}

