/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.properties.misc;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import ru.astemir.astemirlib.common.math.RandomUtils;
import ru.xishnikus.thedawnera.common.entity.properties.misc.NumberProperty;
import ru.xishnikus.thedawnera.common.io.json.TDEJsonUtils;
import ru.xishnikus.thedawnera.common.utils.TagUtils;

public class MobSpawnData {
    private NumberProperty spawnWeight = NumberProperty.uniform(1.0);
    private NumberProperty spawnCount = NumberProperty.uniform(1.0);
    private NumberProperty randomChance = NumberProperty.uniform(-1.0);
    private Predicate<Holder<Biome>> biomePredicate = biome -> false;

    public MobSpawnData(NumberProperty spawnWeight, NumberProperty spawnCount, Predicate<Holder<Biome>> predicate) {
        this.spawnWeight = spawnWeight;
        this.spawnCount = spawnCount;
        this.biomePredicate = predicate;
    }

    public MobSpawnData() {
    }

    public void setRandomChance(NumberProperty randomChance) {
        this.randomChance = randomChance;
    }

    public NumberProperty getSpawnWeight() {
        return this.spawnWeight;
    }

    public NumberProperty getSpawnCount() {
        return this.spawnCount;
    }

    public float getRandomChance() {
        return this.randomChance.getFloat();
    }

    public boolean tryToSpawn(RandomSource random) {
        float chance = this.randomChance.getFloat();
        if (chance != -1.0f) {
            return RandomUtils.doWithChance((RandomSource)random, (float)chance);
        }
        return true;
    }

    public boolean hasBiome(Holder<Biome> biome) {
        return this.biomePredicate.test(biome);
    }

    public static class Deserializer
    implements JsonDeserializer<MobSpawnData> {
        private Predicate<Holder<Biome>> parsePredicate(JsonObject jsonObject) {
            if (jsonObject.has("ID")) {
                String id = jsonObject.get("ID").getAsString();
                ResourceLocation resourceLocation = new ResourceLocation(id);
                return b -> b.m_203373_(resourceLocation);
            }
            if (jsonObject.has("Tag")) {
                String tag = jsonObject.get("Tag").getAsString();
                TagKey<Biome> tagKey = TagUtils.biomeTag(tag);
                return b -> b.m_203656_(tagKey);
            }
            return biome -> false;
        }

        public MobSpawnData deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                JsonObject jsonObject = json.getAsJsonObject();
                NumberProperty spawnWeight = TDEJsonUtils.parseNumber(jsonObject, "SpawnWeight");
                NumberProperty spawnCount = TDEJsonUtils.parseNumber(jsonObject, "SpawnCount");
                JsonArray biomesJsonArray = jsonObject.getAsJsonArray("Biomes");
                Predicate<Holder<Biome>> predicate = null;
                for (JsonElement element : biomesJsonArray) {
                    JsonObject biomeJson = element.getAsJsonObject();
                    if (predicate == null) {
                        predicate = this.parsePredicate(biomeJson);
                        continue;
                    }
                    predicate = predicate.or(this.parsePredicate(biomeJson));
                }
                MobSpawnData spawnData = new MobSpawnData(spawnWeight, spawnCount, predicate);
                if (jsonObject.has("RandomChance")) {
                    spawnData.setRandomChance(TDEJsonUtils.parseNumber(jsonObject, "RandomChance"));
                }
                return spawnData;
            }
            return new MobSpawnData();
        }
    }
}

