/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.properties.misc;

import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import ru.astemir.astemirlib.common.math.RandomUtils;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.properties.MobProperties;
import ru.xishnikus.thedawnera.common.entity.properties.predicate.ItemPredicate;

public class MobTameMethod {
    private static Map<Type, Function<JsonObject, MobTameMethod>> registry = new HashMap<Type, Function<JsonObject, MobTameMethod>>();
    public static final MobTameMethod NO_TAMING = new MobTameMethod(Type.NO_TAMING);
    private Type type;

    public static void register(Type type, Function<JsonObject, MobTameMethod> factory) {
        registry.put(type, factory);
    }

    public static MobTameMethod fromJson(JsonObject jsonObject) {
        String id = jsonObject.get("ID").getAsString();
        return registry.get((Object)Type.byId(new ResourceLocation(id))).apply(jsonObject);
    }

    public MobTameMethod(Type type) {
        this.type = type;
    }

    public boolean isType(Type type) {
        return this.type == type;
    }

    static {
        MobTameMethod.register(Type.NO_TAMING, json -> NO_TAMING);
        MobTameMethod.register(Type.FEED_FROM_HAND, json -> {
            float chance = GsonHelper.m_13820_((JsonObject)json, (String)"Chance", (float)5.0f);
            ItemPredicate requiredItem = null;
            if (json.has("RequiredItem")) {
                requiredItem = ItemPredicate.parseItem(json, "RequiredItem");
            }
            return new FeedWithItem(chance, requiredItem);
        });
        MobTameMethod.register(Type.FEED_FROM_GROUND, json -> {
            float chance = GsonHelper.m_13820_((JsonObject)json, (String)"Chance", (float)5.0f);
            ItemPredicate requiredItem = null;
            if (json.has("RequiredItem")) {
                requiredItem = ItemPredicate.parseItem(json, "RequiredItem");
            }
            return new FeedWithItem(chance, requiredItem);
        });
    }

    public static enum Type {
        NO_TAMING(new ResourceLocation("dawnera", "no_taming")),
        FEED_FROM_HAND(new ResourceLocation("dawnera", "feed_from_hand")),
        FEED_FROM_GROUND(new ResourceLocation("dawnera", "feed_from_ground"));

        private ResourceLocation id;

        private Type(ResourceLocation id) {
            this.id = id;
        }

        public static Type byId(ResourceLocation id) {
            for (Type value : Type.values()) {
                if (!value.id.equals((Object)id)) continue;
                return value;
            }
            return NO_TAMING;
        }
    }

    public static class FeedWithItem
    extends MobTameMethod {
        private ItemPredicate requiredItem;
        private float chance;

        public FeedWithItem(float chance, ItemPredicate requiredItem) {
            super(Type.FEED_FROM_GROUND);
            this.chance = chance;
            this.requiredItem = requiredItem;
        }

        public static boolean tameEatFromGround(Player player, BaseAnimal animal, ItemStack itemStack) {
            FeedWithItem feedFromGround = (FeedWithItem)((MobProperties)animal.getProperties()).getTameMethod();
            if (feedFromGround.requiredItem != null && !feedFromGround.requiredItem.test((LivingEntity)animal, itemStack)) {
                return false;
            }
            animal.tameRandomly(player, RandomUtils.doWithChance((float)feedFromGround.chance));
            return true;
        }

        public static boolean tameEatFromHand(Player player, BaseAnimal animal, ItemStack itemStack) {
            FeedWithItem feedFromGround = (FeedWithItem)((MobProperties)animal.getProperties()).getTameMethod();
            if (feedFromGround.requiredItem != null && !feedFromGround.requiredItem.test((LivingEntity)animal, itemStack)) {
                return false;
            }
            animal.tameRandomly(player, RandomUtils.doWithChance((float)feedFromGround.chance));
            itemStack.m_41774_(1);
            return true;
        }
    }
}

