/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.properties.misc;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import ru.astemir.astemirlib.common.math.RandomUtils;
import ru.xishnikus.thedawnera.common.utils.WeightedRandom;

public abstract class NumberProperty {
    public abstract int getInt();

    public abstract float getFloat();

    public abstract double getDouble();

    public static Uniform uniform(double value) {
        return new Uniform(value);
    }

    public static Ranged ranged(double minValue, double maxValue) {
        return new Ranged(minValue, maxValue);
    }

    public static Weighted weighted(Map<Double, Float> numbers) {
        return new Weighted(numbers);
    }

    public static class Uniform
    extends NumberProperty {
        private double number;

        public Uniform(double number) {
            this.number = number;
        }

        @Override
        public int getInt() {
            return (int)this.number;
        }

        @Override
        public float getFloat() {
            return (float)this.number;
        }

        @Override
        public double getDouble() {
            return this.number;
        }
    }

    public static class Ranged
    extends NumberProperty {
        private double minValue;
        private double maxValue;

        public Ranged(double minValue, double maxValue) {
            this.minValue = minValue;
            this.maxValue = maxValue;
        }

        @Override
        public int getInt() {
            return RandomUtils.randomInt((int)((int)this.minValue), (int)((int)this.maxValue));
        }

        @Override
        public float getFloat() {
            return RandomUtils.randomFloat((float)((int)this.minValue), (float)((int)this.maxValue));
        }

        @Override
        public double getDouble() {
            return RandomUtils.randomFloat((float)((int)this.minValue), (float)((int)this.maxValue));
        }

        public double getMinValue() {
            return this.minValue;
        }

        public double getMaxValue() {
            return this.maxValue;
        }
    }

    public static class Weighted
    extends NumberProperty {
        private WeightedRandom<Double> weightedRandom = new WeightedRandom();

        public Weighted(Map<Double, Float> randomMap) {
            for (Map.Entry<Double, Float> entry : randomMap.entrySet()) {
                randomMap.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public int getInt() {
            return this.weightedRandom.random().intValue();
        }

        @Override
        public float getFloat() {
            return this.weightedRandom.random().floatValue();
        }

        @Override
        public double getDouble() {
            return this.weightedRandom.random();
        }
    }

    public static class Deserializer
    implements JsonDeserializer<NumberProperty> {
        public NumberProperty deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonPrimitive()) {
                JsonPrimitive primitive = json.getAsJsonPrimitive();
                if (primitive.isString()) {
                    String str = primitive.getAsString();
                    if (str.contains("-")) {
                        String[] split = str.split("-");
                        return NumberProperty.ranged(Double.parseDouble(split[0]), Double.parseDouble(split[1]));
                    }
                    double value = Double.parseDouble(str);
                    return NumberProperty.uniform(value);
                }
                if (primitive.isNumber()) {
                    return NumberProperty.uniform(primitive.getAsNumber().doubleValue());
                }
            } else if (json.isJsonArray()) {
                HashMap<Double, Float> numberMap = new HashMap<Double, Float>();
                for (JsonElement element : json.getAsJsonArray()) {
                    if (!element.isJsonPrimitive()) continue;
                    String str = element.getAsString();
                    if (str.contains(",")) {
                        String[] split = str.split(",");
                        numberMap.put(Double.parseDouble(split[0]), Float.valueOf(Float.parseFloat(split[1].replace("%", ""))));
                        continue;
                    }
                    double value = Double.parseDouble(str);
                    return NumberProperty.uniform(value);
                }
                return NumberProperty.weighted(numberMap);
            }
            return NumberProperty.uniform(0.0);
        }
    }
}

