/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.properties.misc;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Mob;
import oshi.util.tuples.Pair;
import ru.astemir.astemirlib.common.math.RandomUtils;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.properties.misc.MobCondition;

public class RandomSelectAction {
    private LinkedHashMap<Pair<Float, Predicate<Mob>>, String> actions = new LinkedHashMap();

    public RandomSelectAction add(float chance, String action) {
        this.actions.put((Pair<Float, Predicate<Mob>>)new Pair((Object)Float.valueOf(chance), mob -> true), action);
        return this;
    }

    public RandomSelectAction add(float chance, Predicate<Mob> condition, String action) {
        this.actions.put((Pair<Float, Predicate<Mob>>)new Pair((Object)Float.valueOf(chance), condition), action);
        return this;
    }

    public void playRandom(BaseAnimal entity, String actionControllerName) {
        String actionName = null;
        for (Map.Entry<Pair<Float, Predicate<Mob>>, String> entry : this.actions.entrySet()) {
            if (!((Predicate)entry.getKey().getB()).test(entity) || !RandomUtils.doWithChance((RandomSource)entity.m_217043_(), (float)((Float)entry.getKey().getA()).floatValue())) continue;
            actionName = entry.getValue();
            break;
        }
        if (actionName == null) {
            actionName = this.defaultAction();
        }
        entity.getActionStateMachine().getController(actionControllerName).playAction(actionName);
    }

    public void playRandom(BaseAnimal entity) {
        this.playRandom(entity, "ActionController");
    }

    private String defaultAction() {
        String actionState = null;
        float highestChance = 0.0f;
        for (Map.Entry<Pair<Float, Predicate<Mob>>, String> entry : this.actions.entrySet()) {
            float chance = ((Float)entry.getKey().getA()).floatValue();
            if (!(chance > highestChance)) continue;
            actionState = entry.getValue();
            highestChance = chance;
        }
        return actionState;
    }

    public static class Deserializer
    implements JsonDeserializer<RandomSelectAction> {
        public RandomSelectAction deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonArray()) {
                LinkedHashMap<Pair, String> map = new LinkedHashMap<Pair, String>();
                RandomSelectAction randomSelectAction = new RandomSelectAction();
                JsonArray jsonArray = json.getAsJsonArray();
                for (JsonElement element : jsonArray) {
                    if (!element.isJsonObject()) continue;
                    JsonObject actionJson = element.getAsJsonObject();
                    String str = actionJson.get("Action").getAsString();
                    Predicate<Mob> predicate = MobCondition.parsePredicate(Mob.class, actionJson, "Conditions");
                    if (!str.contains(",")) continue;
                    String[] split = str.split(",");
                    map.put(new Pair((Object)Float.valueOf(Float.parseFloat(split[1].replace("%", ""))), predicate), split[0]);
                }
                for (Map.Entry entry : map.entrySet()) {
                    randomSelectAction.add(((Float)((Pair)entry.getKey()).getA()).floatValue(), (Predicate)((Pair)entry.getKey()).getB(), (String)entry.getValue());
                }
                return randomSelectAction;
            }
            return new RandomSelectAction();
        }
    }
}

