/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.properties.predicate;

import com.google.common.base.Suppliers;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import ru.xishnikus.thedawnera.common.io.json.TDEJsonUtils;
import ru.xishnikus.thedawnera.common.utils.TagUtils;

public class BlockPredicate {
    private Supplier<Block> block;
    private TagKey<Block> tag;
    private boolean ignore;

    public BlockPredicate(Supplier<Block> block) {
        this.block = block;
    }

    public BlockPredicate(TagKey<Block> tag) {
        this.tag = tag;
    }

    public boolean test(BlockState blockState) {
        if (this.tag != null && blockState.m_204336_(this.tag)) {
            return !this.ignore;
        }
        if (this.block != null && blockState.m_60713_(this.block.get())) {
            return !this.ignore;
        }
        return false;
    }

    public BlockPredicate setIgnore(boolean ignore) {
        this.ignore = ignore;
        return this;
    }

    public static List<BlockPredicate> parseBlocks(JsonObject jsonObject, String name) {
        LinkedList<BlockPredicate> blocks = new LinkedList<BlockPredicate>();
        if (jsonObject.has(name)) {
            JsonElement blocksJson = jsonObject.get(name);
            if (blocksJson.isJsonArray()) {
                JsonArray itemsJsonArray = blocksJson.getAsJsonArray();
                for (JsonElement jsonElement : itemsJsonArray) {
                    blocks.add((BlockPredicate)TDEJsonUtils.GSON.fromJson(jsonElement, BlockPredicate.class));
                }
            } else if (blocksJson.isJsonPrimitive()) {
                blocks.add((BlockPredicate)TDEJsonUtils.GSON.fromJson(blocksJson, BlockPredicate.class));
            }
        }
        return blocks;
    }

    public static class Deserializer
    implements JsonDeserializer<BlockPredicate> {
        public BlockPredicate deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                TagKey<Block> blockKey;
                JsonObject jsonObject = json.getAsJsonObject();
                if (jsonObject.has("ID")) {
                    return new BlockPredicate((Supplier<Block>)Suppliers.memoize(() -> (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(jsonObject.get("ID").getAsString())))).setIgnore(jsonObject.has("Ignore") ? jsonObject.get("Ignore").getAsBoolean() : false);
                }
                if (jsonObject.has("Tag") && (blockKey = TagUtils.blockTag(jsonObject.get("Tag").getAsString())) != null) {
                    return new BlockPredicate(blockKey).setIgnore(jsonObject.has("Ignore") ? jsonObject.get("Ignore").getAsBoolean() : false);
                }
            }
            return null;
        }
    }
}

