/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.properties.predicate;

import com.google.common.base.Suppliers;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.registries.ForgeRegistries;
import ru.xishnikus.thedawnera.common.entity.properties.misc.MobCondition;
import ru.xishnikus.thedawnera.common.io.json.TDEJsonUtils;
import ru.xishnikus.thedawnera.common.utils.TagUtils;

public class EntityTypePredicate {
    private Supplier<EntityType> entityType;
    private TagKey<EntityType<?>> tag;
    private Predicate<Entity> condition;
    private Predicate<Entity> targetCondition;
    private boolean ignore;

    public EntityTypePredicate(Supplier<EntityType> entityType, Predicate<Entity> condition, Predicate<Entity> targetCondition) {
        this.entityType = entityType;
        this.condition = condition;
        this.targetCondition = targetCondition;
    }

    public EntityTypePredicate(TagKey<EntityType<?>> tag, Predicate<Entity> condition, Predicate<Entity> targetCondition) {
        this.tag = tag;
        this.condition = condition;
        this.targetCondition = targetCondition;
    }

    public boolean test(LivingEntity mob, LivingEntity target) {
        if (this.tag != null) {
            if (target.m_6095_().m_204039_(this.tag)) {
                if (this.targetCondition.test((Entity)target) && this.condition.test((Entity)mob)) {
                    return !this.ignore;
                }
            } else {
                return false;
            }
        }
        if (this.entityType != null) {
            if (this.entityType.get() != target.m_6095_()) {
                return false;
            }
            if (this.targetCondition.test((Entity)target) && this.condition.test((Entity)mob)) {
                return !this.ignore;
            }
        }
        return false;
    }

    public EntityTypePredicate setIgnore(boolean ignore) {
        this.ignore = ignore;
        return this;
    }

    public static List<EntityTypePredicate> parseEntities(JsonObject jsonObject, String name) {
        LinkedList<EntityTypePredicate> entities = new LinkedList<EntityTypePredicate>();
        if (jsonObject.has(name)) {
            JsonElement entitiesJson = jsonObject.get(name);
            if (entitiesJson.isJsonArray()) {
                JsonArray entitiesJsonArray = entitiesJson.getAsJsonArray();
                for (JsonElement jsonElement : entitiesJsonArray) {
                    entities.add((EntityTypePredicate)TDEJsonUtils.GSON.fromJson(jsonElement, EntityTypePredicate.class));
                }
            } else if (entitiesJson.isJsonPrimitive()) {
                entities.add((EntityTypePredicate)TDEJsonUtils.GSON.fromJson(entitiesJson, EntityTypePredicate.class));
            }
        }
        return entities;
    }

    public static class Deserializer
    implements JsonDeserializer<EntityTypePredicate> {
        public EntityTypePredicate deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                JsonObject jsonObject = json.getAsJsonObject();
                if (jsonObject.has("ID")) {
                    return new EntityTypePredicate((Supplier<EntityType>)Suppliers.memoize(() -> (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(new ResourceLocation(jsonObject.get("ID").getAsString()))), MobCondition.parsePredicate(Entity.class, jsonObject, "Conditions"), MobCondition.parsePredicate(Entity.class, jsonObject, "TargetConditions")).setIgnore(jsonObject.has("Ignore") ? jsonObject.get("Ignore").getAsBoolean() : false);
                }
                if (jsonObject.has("Tag")) {
                    TagKey<EntityType<?>> tagKey = TagUtils.entityTag(jsonObject.get("Tag").getAsString());
                    return new EntityTypePredicate(tagKey, MobCondition.parsePredicate(Entity.class, jsonObject, "Conditions"), MobCondition.parsePredicate(Entity.class, jsonObject, "TargetConditions")).setIgnore(jsonObject.has("Ignore") ? jsonObject.get("Ignore").getAsBoolean() : false);
                }
            }
            return null;
        }
    }
}

