/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.entity.properties.predicate;

import com.google.common.base.Suppliers;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import ru.xishnikus.thedawnera.common.entity.properties.misc.MobCondition;
import ru.xishnikus.thedawnera.common.io.json.TDEJsonUtils;
import ru.xishnikus.thedawnera.common.utils.TagUtils;

public class ItemPredicate {
    private Supplier<Item> item;
    private TagKey<Item> tag;
    private Predicate<Entity> condition;
    private boolean ignore;

    public ItemPredicate(Supplier<Item> item, Predicate<Entity> condition) {
        this.item = item;
        this.condition = condition;
    }

    public ItemPredicate(TagKey<Item> tag, Predicate<Entity> condition) {
        this.tag = tag;
        this.condition = condition;
    }

    public boolean test(ItemStack itemStack) {
        if (this.tag != null) {
            if (itemStack.m_204117_(this.tag)) {
                return !this.ignore;
            }
            return false;
        }
        if (this.item != null) {
            if (this.item.get() != itemStack.m_41720_()) {
                return false;
            }
            return !this.ignore;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean test(LivingEntity mob, ItemStack itemStack) {
        if (this.tag != null) {
            if (!itemStack.m_204117_(this.tag)) return false;
            if (this.condition != null) {
                if (this.condition.test((Entity)mob)) {
                    if (this.ignore) return false;
                    return true;
                }
            } else {
                if (this.ignore) return false;
                return true;
            }
        }
        if (this.item == null) return false;
        if (this.item.get() != itemStack.m_41720_()) {
            return false;
        }
        if (this.condition != null) {
            if (!this.condition.test((Entity)mob)) return false;
            if (this.ignore) return false;
            return true;
        }
        if (this.ignore) return false;
        return true;
    }

    public ItemPredicate setIgnore(boolean ignore) {
        this.ignore = ignore;
        return this;
    }

    public static ItemPredicate parseItem(JsonObject jsonObject, String name) {
        if (jsonObject.has(name)) {
            return (ItemPredicate)TDEJsonUtils.GSON.fromJson(jsonObject.get(name), ItemPredicate.class);
        }
        return null;
    }

    public static List<ItemPredicate> parseItems(JsonObject jsonObject, String name) {
        LinkedList<ItemPredicate> items = new LinkedList<ItemPredicate>();
        if (jsonObject.has(name)) {
            JsonElement itemsJson = jsonObject.get(name);
            if (itemsJson.isJsonArray()) {
                JsonArray itemsJsonArray = itemsJson.getAsJsonArray();
                for (JsonElement jsonElement : itemsJsonArray) {
                    items.add((ItemPredicate)TDEJsonUtils.GSON.fromJson(jsonElement, ItemPredicate.class));
                }
            } else if (itemsJson.isJsonPrimitive()) {
                items.add((ItemPredicate)TDEJsonUtils.GSON.fromJson(itemsJson, ItemPredicate.class));
            }
        }
        return items;
    }

    public static class Deserializer
    implements JsonDeserializer<ItemPredicate> {
        public ItemPredicate deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonObject()) {
                TagKey<Item> itemKey;
                JsonObject jsonObject = json.getAsJsonObject();
                if (jsonObject.has("ID")) {
                    return new ItemPredicate((Supplier<Item>)Suppliers.memoize(() -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(jsonObject.get("ID").getAsString()))), MobCondition.parsePredicate(Entity.class, jsonObject, "Conditions")).setIgnore(jsonObject.has("Ignore") ? jsonObject.get("Ignore").getAsBoolean() : false);
                }
                if (jsonObject.has("Tag") && (itemKey = TagUtils.itemTag(jsonObject.get("Tag").getAsString())) != null) {
                    return new ItemPredicate(itemKey, MobCondition.parsePredicate(Entity.class, jsonObject, "Conditions")).setIgnore(jsonObject.has("Ignore") ? jsonObject.get("Ignore").getAsBoolean() : false);
                }
            }
            return null;
        }
    }
}

