/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.event;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ru.astemir.astemirlib.common.event.EntityEyeHeightEvent;
import ru.astemir.astemirlib.common.event.EntityMoveEvent;
import ru.astemir.astemirlib.common.math.RandomUtils;
import ru.astemir.astemirlib.common.misc.ForgeRunLater;
import ru.astemir.astemirlib.common.world.WorldUtils;
import ru.xishnikus.thedawnera.common.TDELevelEvents;
import ru.xishnikus.thedawnera.common.advancement.TDEAdvancementCriteria;
import ru.xishnikus.thedawnera.common.effect.MobEffectBleeding;
import ru.xishnikus.thedawnera.common.effect.MobEffectFracture;
import ru.xishnikus.thedawnera.common.effect.TDEMobEffects;
import ru.xishnikus.thedawnera.common.entity.TDEEntities;
import ru.xishnikus.thedawnera.common.entity.ai.goal.vanilla.NearestHealableTargetGoal;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseRideableAnimal;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseRideableWaterAnimal;
import ru.xishnikus.thedawnera.common.entity.entity.ground.EntityDodo;
import ru.xishnikus.thedawnera.common.entity.entity.ground.EntityWorm;
import ru.xishnikus.thedawnera.common.entity.entity.water.EntityDiplocaulus;
import ru.xishnikus.thedawnera.common.io.config.TDECommonConfig;
import ru.xishnikus.thedawnera.common.item.TDEItems;
import ru.xishnikus.thedawnera.common.misc.TDETags;

@Mod.EventBusSubscriber(modid="dawnera", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EventListener {
    @SubscribeEvent
    public static void onLivingEntityTick(LivingEvent.LivingTickEvent e) {
        LivingEntity livingEntity = e.getEntity();
        EntityType entityType = livingEntity.m_6095_();
        Level level = livingEntity.m_9236_();
        if (livingEntity.m_21023_((MobEffect)TDEMobEffects.BLEEDING.get())) {
            int amplifier = livingEntity.m_21124_((MobEffect)TDEMobEffects.BLEEDING.get()).m_19564_();
            if (e.getEntity().f_19797_ % Math.max(4 - amplifier, 1) == 0) {
                TDELevelEvents.bleedingParticles(livingEntity);
            }
            if (e.getEntity().f_19797_ % Math.max(20 - amplifier * 5, 5) == 0) {
                MobEffectBleeding.affect(livingEntity, amplifier);
            }
        }
        if (entityType != TDEEntities.DODO.get() && entityType != TDEEntities.TYRANNOSAURUS.get() && !entityType.m_204039_(TDETags.Entities.LIVING_FOSSIL)) {
            return;
        }
        if (livingEntity.f_19797_ % 20 == 0) {
            for (Player player : level.m_45955_(TargetingConditions.m_148353_(), livingEntity, livingEntity.m_20191_().m_82377_(24.0, 24.0, 24.0))) {
                if (!player.m_142582_((Entity)livingEntity) || !(player instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                Vec3 vec3 = player.m_20252_(1.0f).m_82541_();
                Vec3 vec31 = new Vec3(livingEntity.m_20185_() - player.m_20185_(), livingEntity.m_20188_() - player.m_20188_(), livingEntity.m_20189_() - player.m_20189_());
                double d1 = vec3.m_82526_(vec31 = vec31.m_82541_());
                if (!(d1 > 0.5) || level.f_46443_) continue;
                TDEAdvancementCriteria.MEET_MOB.trigger(serverPlayer, (Entity)livingEntity);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityMove(EntityMoveEvent e) {
        Entity entity = e.getEntity();
        Vec3 vec3 = e.getMotion();
        if (entity.f_19797_ % 20 == 0 && (!Mth.m_14082_((double)vec3.f_82479_, (double)0.0) || vec3.f_82480_ > 0.0 || !Mth.m_14082_((double)vec3.f_82481_, (double)0.0)) && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (livingEntity.m_21023_((MobEffect)TDEMobEffects.FRACTURE.get())) {
                MobEffectFracture.affect(livingEntity, vec3);
            }
            if (livingEntity.m_21023_((MobEffect)TDEMobEffects.BLEEDING.get())) {
                MobEffectBleeding.affect(livingEntity, livingEntity.m_21124_((MobEffect)TDEMobEffects.BLEEDING.get()).m_19564_());
            }
        }
    }

    @SubscribeEvent
    public static void onJoin(EntityJoinLevelEvent e) {
        Object object;
        if (!e.getLevel().f_46443_ && (object = e.getEntity()) instanceof ServerPlayer) {
            final ServerPlayer serverPlayer = (ServerPlayer)object;
            new ForgeRunLater(){

                public void run() {
                    TDEAdvancementCriteria.JOIN_GAME.trigger(serverPlayer);
                }
            }.runTaskLater(20L);
        }
        if ((object = e.getEntity()) instanceof LightningBolt) {
            LightningBolt lightningBolt = (LightningBolt)object;
            object = e.getLevel().m_45976_(BaseAnimal.class, new AABB(lightningBolt.m_20183_()).m_82377_(8.0, 8.0, 8.0)).iterator();
            while (object.hasNext()) {
                BaseAnimal entity = (BaseAnimal)((Object)object.next());
                entity.sensedExplosionOrLightning(lightningBolt.m_20183_());
            }
        }
        if ((object = e.getEntity()) instanceof Witch) {
            Witch witch = (Witch)object;
            witch.f_21346_.m_25352_(2, new NearestHealableTargetGoal<EntityDiplocaulus>((Mob)witch, EntityDiplocaulus.class, true, mob -> !mob.m_20069_()));
        }
        if (((Boolean)TDECommonConfig.CHICKEN_ATTACK_WORMS.get()).booleanValue() && (object = e.getEntity()) instanceof Chicken) {
            Chicken chicken = (Chicken)object;
            chicken.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)chicken, 1.0, false));
            chicken.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)chicken, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)TDEItems.WORM.get()}), false));
            chicken.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)chicken, EntityWorm.class, true, false));
        }
    }

    @SubscribeEvent
    public static void onSetupEyeHeight(EntityEyeHeightEvent e) {
        Entity entity = e.getEntity();
        if (entity instanceof Player) {
            BaseAnimal entity2;
            Player player = (Player)entity;
            Entity entity3 = player.m_20202_();
            if (entity3 instanceof BaseRideableAnimal) {
                entity2 = (BaseRideableAnimal)entity3;
                e.setEyeHeight(e.getEyeHeight() * ((BaseRideableAnimal)entity2).getPassengerEyeScale());
                e.setCanceled(true);
            }
            if ((entity3 = player.m_20202_()) instanceof BaseRideableWaterAnimal) {
                entity2 = (BaseRideableWaterAnimal)entity3;
                e.setEyeHeight(e.getEyeHeight() * ((BaseRideableWaterAnimal)entity2).getPassengerEyeScale());
                e.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onBreakBlock(BlockEvent.BreakEvent e) {
        if (RandomUtils.doWithChance((RandomSource)e.getLevel().m_213780_(), (float)0.1f) && e.getLevel().m_8055_(e.getPos()).m_204336_(TDETags.Blocks.WORM_PRODUCE)) {
            EntityWorm worm = (EntityWorm)((EntityType)TDEEntities.WORM.get()).m_20615_(e.getPlayer().m_9236_());
            worm.m_20035_(e.getPos(), 0.0f, 0.0f);
            e.getLevel().m_7967_((Entity)worm);
        }
    }

    @SubscribeEvent
    public static void onHoeBlock(BlockEvent.BlockToolModificationEvent e) {
        if (e.getToolAction() == ToolActions.HOE_TILL && RandomUtils.doWithChance((RandomSource)e.getLevel().m_213780_(), (float)0.85f)) {
            EntityWorm worm = (EntityWorm)((EntityType)TDEEntities.WORM.get()).m_20615_(e.getPlayer().m_9236_());
            worm.m_20035_(e.getPos().m_7494_(), 0.0f, 0.0f);
            e.getLevel().m_7967_((Entity)worm);
        }
    }

    @SubscribeEvent
    public static void onMobDrop(LivingDropsEvent e) {
        Entity entity = e.getSource().m_7640_();
        if (entity instanceof BaseAnimal) {
            BaseAnimal baseAnimal = (BaseAnimal)entity;
            if (e.getEntity() instanceof Player) {
                return;
            }
            if (!baseAnimal.doesKilledEntityHasDrop(e.getEntity(), e.getDrops())) {
                e.setCanceled(true);
            }
        } else if (e.getSource().m_7640_() instanceof Chicken && e.getEntity() instanceof EntityWorm) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onHurt(LivingHurtEvent e) {
        Entity sourceEntity = e.getSource().m_7639_();
        Entity directEntity = e.getSource().m_7640_();
        LivingEntity livingEntity = e.getEntity();
        if (e.getSource() == livingEntity.m_269291_().m_268989_() && livingEntity.m_20202_() instanceof BaseAnimal) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPotionEffectApply(MobEffectEvent.Applicable e) {
        if (e.getEffectInstance().m_19544_() == TDEMobEffects.AMPHIBIAN_MADNESS.get() && !(e.getEntity() instanceof EntityDiplocaulus)) {
            e.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onEat(LivingEntityUseItemEvent.Finish e) {
        if (e.getItem().m_150930_(Items.f_42575_) && e.getResultStack().m_41619_()) {
            for (EntityDodo dodo : e.getEntity().m_9236_().m_45976_(EntityDodo.class, e.getEntity().m_20191_().m_82377_(5.0, 2.0, 5.0))) {
                if (dodo.m_5803_() || !dodo.m_142582_((Entity)e.getEntity())) continue;
                if (!dodo.m_9236_().f_46443_) {
                    for (int i = 0; i < 5; ++i) {
                        ((ServerLevel)dodo.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123792_, dodo.m_20208_(0.5), dodo.m_20187_(), dodo.m_20262_(0.5), 1, 0.0, 0.0, 0.0, (double)0.1f);
                    }
                }
                dodo.actionController.playAction(dodo.actionScream);
            }
            LivingEntity livingEntity = e.getEntity();
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)livingEntity;
                TDEAdvancementCriteria.EAT_MELON.trigger(player);
            }
        }
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent e) {
        Level level = e.getLevel();
        BlockPos blockPos = WorldUtils.blockPos((Vec3)e.getExplosion().getPosition());
        for (BaseAnimal entity : level.m_45976_(BaseAnimal.class, new AABB(blockPos).m_82377_(8.0, 8.0, 8.0))) {
            entity.sensedExplosionOrLightning(blockPos);
        }
    }
}

