/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.io.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.io.File;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import oshi.util.tuples.Pair;

public interface TDEConfig {
    public static ForgeConfigSpec.BooleanValue bool(ForgeConfigSpec.Builder builder, String comment, String key, boolean defaultValue) {
        return builder.comment(comment).define(key, defaultValue);
    }

    public static ForgeConfigSpec.IntValue rangedInt(ForgeConfigSpec.Builder builder, String comment, String key, int defaultValue, int minValue, int maxValue) {
        return builder.comment(comment).defineInRange(key, defaultValue, minValue, maxValue);
    }

    public static ForgeConfigSpec.DoubleValue rangedDouble(ForgeConfigSpec.Builder builder, String comment, String key, double defaultValue, double minValue, double maxValue) {
        return builder.comment(comment).defineInRange(key, defaultValue, minValue, maxValue);
    }

    public static Pair<ForgeConfigSpec.IntValue, ForgeConfigSpec.IntValue> vector(ForgeConfigSpec.Builder builder, String comment, String key, int x, int y, int minX, int minY, int maxX, int maxY) {
        builder.comment(comment);
        return new Pair((Object)builder.defineInRange(key + "X", x, minX, maxX), (Object)builder.defineInRange(key + "Y", y, minY, maxY));
    }

    public static void loadConfig(ForgeConfigSpec config, String path) {
        CommentedFileConfig file = (CommentedFileConfig)CommentedFileConfig.builder((File)new File(path)).sync().preserveInsertionOrder().autosave().writingMode(WritingMode.REPLACE).build();
        file.load();
        config.setConfig((CommentedConfig)file);
    }

    public static void register(ModConfig.Type type, ForgeConfigSpec configSpec, String name) {
        ModLoadingContext.get().registerConfig(type, (IConfigSpec)configSpec, name);
        TDEConfig.loadConfig(configSpec, FMLPaths.CONFIGDIR.get().resolve(name).toString());
    }
}

