/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.io.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import ru.xishnikus.thedawnera.common.io.json.TDEJsonUtils;

public interface JsonBuilder<T extends JsonElement> {
    public T build();

    public static class Object
    implements JsonBuilder<JsonObject> {
        private JsonObject jsonObject = new JsonObject();

        public Object add(String key, Number value) {
            this.jsonObject.addProperty(key, value);
            return this;
        }

        public Object add(String key, String value) {
            this.jsonObject.addProperty(key, value);
            return this;
        }

        public Object add(String key, Character value) {
            this.jsonObject.addProperty(key, value);
            return this;
        }

        public Object add(String key, Boolean value) {
            this.jsonObject.addProperty(key, value);
            return this;
        }

        public Object add(String key, JsonElement value) {
            this.jsonObject.add(key, value);
            return this;
        }

        public <T> Object add(String key, T value) {
            this.jsonObject.add(key, TDEJsonUtils.GSON.toJsonTree(value));
            return this;
        }

        @Override
        public JsonObject build() {
            return this.jsonObject;
        }

        public static Object create() {
            return new Object();
        }
    }

    public static class Array
    implements JsonBuilder<JsonArray> {
        private JsonArray jsonArray = new JsonArray();

        public Array add(Number value) {
            this.jsonArray.add(value);
            return this;
        }

        public Array add(String value) {
            this.jsonArray.add(value);
            return this;
        }

        public Array add(Character value) {
            this.jsonArray.add(value);
            return this;
        }

        public Array add(Boolean value) {
            this.jsonArray.add(value);
            return this;
        }

        public Array add(JsonElement value) {
            this.jsonArray.add(value);
            return this;
        }

        public <T> Array add(T value) {
            this.jsonArray.add(TDEJsonUtils.GSON.toJsonTree(value));
            return this;
        }

        public Array add(Number ... values) {
            for (Number value : values) {
                this.jsonArray.add(value);
            }
            return this;
        }

        public Array add(String ... values) {
            for (String value : values) {
                this.jsonArray.add(value);
            }
            return this;
        }

        public Array add(Character ... values) {
            for (Character value : values) {
                this.jsonArray.add(value);
            }
            return this;
        }

        public Array add(Boolean ... values) {
            for (Boolean value : values) {
                this.jsonArray.add(value);
            }
            return this;
        }

        public Array add(JsonElement ... values) {
            for (JsonElement value : values) {
                this.jsonArray.add(value);
            }
            return this;
        }

        public <T> Array add(T ... values) {
            for (T value : values) {
                this.jsonArray.add(TDEJsonUtils.GSON.toJsonTree(value));
            }
            return this;
        }

        @Override
        public JsonArray build() {
            return this.jsonArray;
        }

        public static Array create() {
            return new Array();
        }
    }

    public static class Primitive
    implements JsonBuilder<JsonPrimitive> {
        private JsonPrimitive jsonPrimitive;

        public Primitive(JsonPrimitive jsonPrimitive) {
            this.jsonPrimitive = jsonPrimitive;
        }

        @Override
        public JsonPrimitive build() {
            return this.jsonPrimitive;
        }

        public static Primitive create(Number value) {
            return new Primitive(new JsonPrimitive(value));
        }

        public static Primitive create(String value) {
            return new Primitive(new JsonPrimitive(value));
        }

        public static Primitive create(Character value) {
            return new Primitive(new JsonPrimitive(value));
        }

        public static Primitive create(Boolean value) {
            return new Primitive(new JsonPrimitive(value));
        }
    }
}

