/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.io.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.io.FileUtils;
import ru.xishnikus.thedawnera.common.io.json.TDEJsonUtils;

public class JsonModConfig {
    private ResourceLocation path;
    private File file;
    private JsonObject content;

    public JsonModConfig(ResourceLocation path) {
        this.path = path;
        this.update();
        this.save();
    }

    public JsonModConfig addProperty(String name, Number value) {
        this.content.addProperty(name, value);
        return this;
    }

    public JsonModConfig addProperty(String name, String value) {
        this.content.addProperty(name, value);
        return this;
    }

    public JsonModConfig addProperty(String name, Character value) {
        this.content.addProperty(name, value);
        return this;
    }

    public JsonModConfig addProperty(String name, Boolean value) {
        this.content.addProperty(name, value);
        return this;
    }

    public JsonModConfig add(String name, JsonElement value) {
        this.content.add(name, value);
        return this;
    }

    public <T> T get(Class<T> className) {
        return (T)TDEJsonUtils.GSON.fromJson((JsonElement)this.content, className);
    }

    public <T> T get(String name, Class<T> className, T defaultValue) {
        JsonObject jsonObject = this.content.getAsJsonObject();
        if (jsonObject.has(name)) {
            return (T)TDEJsonUtils.GSON.fromJson(jsonObject.get(name), className);
        }
        return defaultValue;
    }

    private JsonObject readFromDataFolder() {
        JsonObject jsonObject;
        InputStreamReader reader = new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("data/" + this.path.m_135827_() + "/configs/" + this.path.m_135815_()));
        try {
            jsonObject = (JsonObject)TDEJsonUtils.GSON.fromJson((Reader)reader, JsonObject.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return new JsonObject();
            }
        }
        ((Reader)reader).close();
        return jsonObject;
    }

    private void update() {
        Path absolutePath = Paths.get(FMLPaths.CONFIGDIR.get().resolve(this.path.m_135827_() + "/" + this.path.m_135815_()).toUri());
        try {
            if (!absolutePath.toFile().exists()) {
                Files.createDirectories(absolutePath.getParent(), new FileAttribute[0]);
                Files.createFile(absolutePath, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.file = absolutePath.toFile();
        this.content = this.readFromDataFolder();
    }

    public JsonModConfig save() {
        try {
            JsonObject configJson = (JsonObject)TDEJsonUtils.GSON.fromJson(FileUtils.readFileToString((File)this.file), JsonObject.class);
            boolean replace = false;
            if (configJson != null) {
                if (configJson.has("Replace")) {
                    replace = configJson.get("Replace").getAsBoolean();
                }
                if (replace) {
                    this.content = configJson;
                }
            }
            FileUtils.write((File)this.file, (CharSequence)TDEJsonUtils.GSON.toJson((JsonElement)this.content), (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public JsonObject getContent() {
        return this.content;
    }
}

