/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.io.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;
import ru.astemir.astemirlib.common.action.ActionState;
import ru.astemir.astemirlib.common.misc.ValueHolder;
import ru.xishnikus.thedawnera.common.entity.input.InputActionType;
import ru.xishnikus.thedawnera.common.entity.input.InputKey;
import ru.xishnikus.thedawnera.common.entity.input.InputMap;
import ru.xishnikus.thedawnera.common.entity.input.InputType;
import ru.xishnikus.thedawnera.common.entity.properties.ai.CustomGoalFactory;
import ru.xishnikus.thedawnera.common.entity.properties.ai.CustomTargetGoalFactory;
import ru.xishnikus.thedawnera.common.entity.properties.misc.ConditionalSelectAction;
import ru.xishnikus.thedawnera.common.entity.properties.misc.MobAIBuilder;
import ru.xishnikus.thedawnera.common.entity.properties.misc.MobAttributeName;
import ru.xishnikus.thedawnera.common.entity.properties.misc.MobFoodRation;
import ru.xishnikus.thedawnera.common.entity.properties.misc.MobSchedule;
import ru.xishnikus.thedawnera.common.entity.properties.misc.MobScheduleTask;
import ru.xishnikus.thedawnera.common.entity.properties.misc.MobSpawnData;
import ru.xishnikus.thedawnera.common.entity.properties.misc.NumberProperty;
import ru.xishnikus.thedawnera.common.entity.properties.misc.RandomSelectAction;
import ru.xishnikus.thedawnera.common.entity.properties.predicate.BlockPredicate;
import ru.xishnikus.thedawnera.common.entity.properties.predicate.EntityTypePredicate;
import ru.xishnikus.thedawnera.common.entity.properties.predicate.ItemPredicate;
import ru.xishnikus.thedawnera.common.io.json.JsonField;
import ru.xishnikus.thedawnera.common.utils.TDEReflectionUtils;

public class TDEJsonUtils {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(ConditionalSelectAction.class, (Object)new ConditionalSelectAction.Deserializer()).registerTypeAdapter(RandomSelectAction.class, (Object)new RandomSelectAction.Deserializer()).registerTypeAdapter(NumberProperty.class, (Object)new NumberProperty.Deserializer()).registerTypeAdapter(MobAIBuilder.class, (Object)new MobAIBuilder.Deserializer()).registerTypeAdapter(CustomTargetGoalFactory.class, (Object)new CustomTargetGoalFactory.Deserializer()).registerTypeAdapter(CustomGoalFactory.class, (Object)new CustomGoalFactory.Deserializer()).registerTypeAdapter(MobScheduleTask.class, (Object)new MobScheduleTask.Deserializer()).registerTypeAdapter(MobSchedule.class, (Object)new MobSchedule.Deserializer()).registerTypeAdapter(MobFoodRation.class, (Object)new MobFoodRation.Deserializer()).registerTypeAdapter(EntityTypePredicate.class, (Object)new EntityTypePredicate.Deserializer()).registerTypeAdapter(ItemPredicate.class, (Object)new ItemPredicate.Deserializer()).registerTypeAdapter(BlockPredicate.class, (Object)new BlockPredicate.Deserializer()).registerTypeAdapter(MobSpawnData.class, (Object)new MobSpawnData.Deserializer()).setPrettyPrinting().create();

    public static void loadAllJsonFields(JsonObject jsonObject, Object instance) {
        for (Field field : TDEReflectionUtils.getAllFields(instance.getClass())) {
            JsonField annotation;
            if (!field.isAnnotationPresent(JsonField.class) || !jsonObject.has((annotation = field.getAnnotation(JsonField.class)).value())) continue;
            field.setAccessible(true);
            try {
                Object value = GSON.fromJson(jsonObject.get(annotation.value()), field.getType());
                field.set(instance, value);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static InputMap parseInputMap(JsonObject json, String name) {
        JsonObject inputControlsJson;
        JsonElement buttonsJson;
        ArrayList<InputKey> keys = new ArrayList<InputKey>();
        JsonElement element = json.get(name);
        if (element.isJsonObject() && (buttonsJson = (inputControlsJson = element.getAsJsonObject()).get("Buttons")).isJsonArray()) {
            JsonArray buttonsJsonArray = buttonsJson.getAsJsonArray();
            for (JsonElement buttonJson : buttonsJsonArray) {
                if (!buttonJson.isJsonObject()) continue;
                JsonObject buttonJsonObject = buttonJson.getAsJsonObject();
                String buttonName = buttonJsonObject.get("ID").getAsString();
                InputType inputType = InputType.valueOf(buttonJsonObject.get("Type").getAsString().toUpperCase());
                InputActionType actionType = InputActionType.valueOf(buttonJsonObject.get("Action").getAsString().toUpperCase());
                InputKey.Id keyId = InputKey.Id.valueOf(buttonJsonObject.get("Button").getAsString().toUpperCase());
                int cooldown = 0;
                if (buttonJsonObject.has("Cooldown")) {
                    cooldown = buttonJsonObject.get("Cooldown").getAsInt();
                }
                keys.add(new InputKey(buttonName, inputType, actionType, keyId, cooldown));
            }
        }
        return new InputMap(keys.toArray(new InputKey[keys.size()]));
    }

    public static Map<String, List<ActionState>> parseActionStateMachine(JsonObject json, String name) {
        HashMap<String, List<ActionState>> controllersMap = new HashMap<String, List<ActionState>>();
        JsonElement element = json.get(name);
        if (element.isJsonArray()) {
            JsonArray actionStateJson = element.getAsJsonArray();
            for (JsonElement actionControllerJson : actionStateJson) {
                JsonElement actionsJson;
                if (!actionControllerJson.isJsonObject()) continue;
                JsonObject actionControllerJsonObject = actionControllerJson.getAsJsonObject();
                String controllerName = actionControllerJsonObject.get("ID").getAsString();
                List<ActionState> actions = controllersMap.containsKey(controllerName) ? (List)controllersMap.get(controllerName) : new ArrayList();
                int id = 0;
                if (actionControllerJsonObject.has("Actions") && (actionsJson = actionControllerJsonObject.get("Actions")).isJsonArray()) {
                    JsonArray actionsJsonArray = actionsJson.getAsJsonArray();
                    for (JsonElement actionJson : actionsJsonArray) {
                        if (actionJson.isJsonObject()) {
                            JsonObject actionJsonObject = actionJson.getAsJsonObject();
                            actions.add(new ActionState(id, actionJsonObject.get("ID").getAsString(), actionJsonObject.has("Length") ? actionJsonObject.get("Length").getAsFloat() : -1.0f));
                        } else if (actionJson.isJsonPrimitive()) {
                            actions.add(new ActionState(id, actionJson.getAsString(), -1));
                        }
                        ++id;
                    }
                }
                controllersMap.put(controllerName, actions);
            }
        }
        return controllersMap;
    }

    public static Map<String, RandomSelectAction> parseRandomSelectActions(JsonObject json, String name) {
        JsonElement jsonElement;
        HashMap<String, RandomSelectAction> randomSelectActionMap = new HashMap<String, RandomSelectAction>();
        if (json.has(name) && (jsonElement = json.get(name)).isJsonObject()) {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            for (String key : jsonObject.keySet()) {
                randomSelectActionMap.put(key, (RandomSelectAction)GSON.fromJson(jsonObject.get(key), RandomSelectAction.class));
            }
        }
        return randomSelectActionMap;
    }

    public static Map<String, ConditionalSelectAction> parseConditionalSelectAction(JsonObject json, String name) {
        JsonElement jsonElement;
        HashMap<String, ConditionalSelectAction> conditionalSelectActionMap = new HashMap<String, ConditionalSelectAction>();
        if (json.has(name) && (jsonElement = json.get(name)).isJsonObject()) {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            for (String key : jsonObject.keySet()) {
                conditionalSelectActionMap.put(key, (ConditionalSelectAction)GSON.fromJson(jsonObject.get(key), ConditionalSelectAction.class));
            }
        }
        return conditionalSelectActionMap;
    }

    public static Map<MobAttributeName, Double> parseAttributes(JsonObject json, String name) {
        HashMap<MobAttributeName, Double> attributes = new HashMap<MobAttributeName, Double>();
        JsonElement element = json.get(name);
        if (element.isJsonObject()) {
            JsonObject attributesJson = element.getAsJsonObject();
            for (String key : attributesJson.keySet()) {
                JsonElement attributeValue = attributesJson.get(key);
                if (!attributeValue.isJsonPrimitive()) continue;
                double value = attributesJson.get(key).getAsDouble();
                attributes.put(MobAttributeName.fromJson(key), value);
            }
        }
        return attributes;
    }

    public static BlockState parseBlockState(JsonObject json, String name) {
        JsonElement element = json.get(name);
        if (element.isJsonObject()) {
            JsonObject jsonObject = element.getAsJsonObject();
            String id = jsonObject.get("ID").getAsString();
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(id));
            BlockState state = block.m_49966_();
            if (jsonObject.has("Properties")) {
                JsonObject propertiesJson = jsonObject.get("Properties").getAsJsonObject();
                StateDefinition stateDefinition = block.m_49965_();
                for (String key : propertiesJson.keySet()) {
                    Optional optional;
                    Property property = stateDefinition.m_61081_(key);
                    if (property == null || !(optional = property.m_6215_(propertiesJson.get(key).getAsString())).isPresent()) continue;
                    return (BlockState)state.m_61124_(property, (Comparable)optional.get());
                }
            }
            return state;
        }
        if (element.isJsonPrimitive()) {
            String id = element.getAsString();
            return ((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(id))).m_49966_();
        }
        throw new RuntimeException("Invalid blockstate: " + json);
    }

    public static Block parseBlock(JsonObject jsonObject, String name) {
        return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(jsonObject.get(name).getAsString()));
    }

    public static Item parseItem(JsonObject jsonObject, String name) {
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(jsonObject.get(name).getAsString()));
    }

    public static NumberProperty parseNumber(JsonObject jsonObject, String name) {
        return (NumberProperty)GSON.fromJson(jsonObject.get(name), NumberProperty.class);
    }

    public static <T> T getHolderValueOr(ValueHolder<T> holder, T defaultValue) {
        if (!holder.isEmpty()) {
            return (T)holder.get();
        }
        return defaultValue;
    }
}

