/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import ru.astemir.astemirlib.common.math.MathUtils;
import ru.xishnikus.thedawnera.common.entity.entity.projectile.BaseArrowLike;
import ru.xishnikus.thedawnera.common.entity.entity.projectile.EntityThrownDiplorang;
import ru.xishnikus.thedawnera.common.misc.TDESoundEvents;

public class ItemDiplorang
extends Item
implements Vanishable {
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public ItemDiplorang() {
        super(new Item.Properties().m_41503_(150));
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Tool modifier", 1.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Tool modifier", (double)-2.9f, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public boolean applyForgeHandTransform(PoseStack poseStack, LocalPlayer player, HumanoidArm arm, ItemStack itemInHand, float partialTick, float equipProcess, float swingProcess) {
                if (player.m_6117_() && player.m_21211_().m_150930_((Item)ItemDiplorang.this)) {
                    int i = arm == HumanoidArm.RIGHT ? 1 : -1;
                    float ticksUsed = Minecraft.m_91087_().m_91296_() + (float)player.m_21252_();
                    float twitching = ticksUsed >= 5.0f ? MathUtils.sin((float)ticksUsed) / 100.0f : 0.0f;
                    poseStack.m_252880_((float)i * 0.56f, -0.52f + equipProcess * -0.6f, -0.72f);
                    poseStack.m_252880_(0.0f, 0.15f + Math.min(ticksUsed / 15.0f, 0.1f) + twitching, 0.0f);
                    if (i == -1) {
                        poseStack.m_252781_(Axis.f_252436_.m_252977_(-135.0f));
                    }
                    poseStack.m_252781_(Axis.f_252403_.m_252977_(Math.min(ticksUsed * 15.0f, -60.0f)));
                    poseStack.m_252781_(Axis.f_252529_.m_252977_((float)i * Math.min(ticksUsed * 15.0f, 140.0f)));
                    return true;
                }
                return super.applyForgeHandTransform(poseStack, player, arm, itemInHand, partialTick, equipProcess, swingProcess);
            }
        });
    }

    public void m_5551_(ItemStack itemStack, Level level, LivingEntity livingEntity, int duration) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            int i = this.m_8105_(itemStack) - duration;
            if (i >= 10) {
                itemStack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(livingEntity.m_7655_()));
                EntityThrownDiplorang boomerang = new EntityThrownDiplorang(level, (LivingEntity)player, itemStack);
                boomerang.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.0f, 1.0f);
                if (player.m_150110_().f_35937_) {
                    boomerang.pickup = BaseArrowLike.Pickup.CREATIVE_ONLY;
                }
                level.m_7967_((Entity)boomerang);
                level.m_6269_(null, (Entity)boomerang, (SoundEvent)TDESoundEvents.BOOMERANG_THROW.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                if (!player.m_150110_().f_35937_) {
                    player.m_150109_().m_36057_(itemStack);
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41773_() >= itemstack.m_41776_() - 1) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        if (EnchantmentHelper.m_44932_((ItemStack)itemstack) > 0 && !player.m_20070_()) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public boolean m_7579_(ItemStack itemStack, LivingEntity livingEntity, LivingEntity livingEntity2) {
        itemStack.m_41622_(1, livingEntity2, p_43414_ -> p_43414_.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public boolean m_6813_(ItemStack itemStack, Level level, BlockState blockStte, BlockPos blockPos, LivingEntity livingEntity) {
        if ((double)blockStte.m_60800_((BlockGetter)level, blockPos) != 0.0) {
            itemStack.m_41622_(2, livingEntity, p_43385_ -> p_43385_.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public boolean m_6777_(BlockState blockState, Level level, BlockPos blockPos, Player player) {
        return !player.m_7500_();
    }

    public UseAnim m_6164_(ItemStack itemStack) {
        return UseAnim.SPEAR;
    }

    public int m_8105_(ItemStack itemStack) {
        return 72000;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(equipmentSlot);
    }

    public int m_6473_() {
        return 1;
    }
}

