/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.utils;

import java.util.UUID;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;

public class AttributeUtils {
    public static boolean tryToAddTransientModifier(LivingEntity livingEntity, Attribute attribute, UUID modifierUUID, String modifierName, AttributeModifier.Operation operation, double value) {
        AttributeInstance attributeinstance = livingEntity.m_21051_(attribute);
        if (attributeinstance == null) {
            return false;
        }
        if (attributeinstance.m_22111_(modifierUUID) != null) {
            attributeinstance.m_22118_(new AttributeModifier(modifierUUID, modifierName, value, operation));
            return true;
        }
        return false;
    }

    public static boolean tryToRemoveTransientModifier(LivingEntity livingEntity, Attribute attribute, UUID modifierUUID) {
        AttributeInstance attributeinstance = livingEntity.m_21051_(attribute);
        if (attributeinstance != null && attributeinstance.m_22111_(modifierUUID) != null) {
            attributeinstance.m_22120_(modifierUUID);
            return true;
        }
        return false;
    }

    public static boolean hasAttribute(LivingEntity livingEntity, Attribute attribute) {
        return livingEntity.m_21204_().m_22171_(attribute);
    }

    public static void setAttributeValue(LivingEntity livingEntity, Attribute attribute, double value) {
        if (AttributeUtils.hasAttribute(livingEntity, attribute)) {
            livingEntity.m_21051_(attribute).m_22100_(value);
        }
    }

    public static void resetAttribute(LivingEntity livingEntity, Attribute attribute) {
        if (AttributeUtils.hasAttribute(livingEntity, attribute)) {
            AttributeUtils.setAttributeValue(livingEntity, attribute, AttributeUtils.getDefaultAttributeValue(livingEntity, attribute));
        }
    }

    public static void setMultipliedBaseAttributeValue(LivingEntity livingEntity, Attribute attribute, double multiplier) {
        if (AttributeUtils.hasAttribute(livingEntity, attribute)) {
            AttributeUtils.setAttributeValue(livingEntity, attribute, AttributeUtils.getDefaultAttributeValue(livingEntity, attribute) * multiplier);
        }
    }

    public static double getDefaultAttributeValue(LivingEntity livingEntity, Attribute attribute) {
        if (AttributeUtils.hasAttribute(livingEntity, attribute)) {
            AttributeSupplier defaultAttributes = DefaultAttributes.m_22297_((EntityType)livingEntity.m_6095_());
            return defaultAttributes.m_22253_(attribute);
        }
        return 0.0;
    }
}

