/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

public class TDEReflectionUtils {
    public static List<Field> getAllFields(Class<?> clazz) {
        ArrayList<Field> allFields = new ArrayList<Field>();
        while (clazz != null) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                allFields.add(field);
            }
            clazz = clazz.getSuperclass();
        }
        return allFields;
    }

    public static <T> T getValue(Object instance, Field field) {
        try {
            field.setAccessible(true);
            return (T)field.get(instance);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setFieldValue(Object instance, Field field, Object value) {
        try {
            field.setAccessible(true);
            field.set(instance, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends Enum<?>> T searchEnum(Class<T> enumeration, String search) {
        for (Enum each : (Enum[])enumeration.getEnumConstants()) {
            if (each.name().compareToIgnoreCase(search) != 0) continue;
            return (T)each;
        }
        return null;
    }

    public static <T> T newInstance(Class<T> className) {
        try {
            return className.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return null;
    }
}

