/*
 * Decompiled with CFR 0.152.
 */
package ru.xishnikus.thedawnera.common.utils;

import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.Event;
import ru.astemir.astemirlib.common.math.AVector3f;
import ru.astemir.astemirlib.common.math.Color;
import ru.astemir.astemirlib.common.math.RandomUtils;
import ru.xishnikus.thedawnera.common.TDELevelEvents;
import ru.xishnikus.thedawnera.common.entity.entity.base.BaseAnimal;
import ru.xishnikus.thedawnera.common.menu.DinoInventoryMenu;

public class TDEUtils {
    public static Color colorFromHSV(Color.HSV hsv) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (hsv.s == 0.0f) {
            g = b = (int)(hsv.v * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hsv.h - (float)Math.floor(hsv.h)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = hsv.v * (1.0f - hsv.s);
            float q = hsv.v * (1.0f - hsv.s * f);
            float t = hsv.v * (1.0f - hsv.s * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(hsv.v * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(hsv.v * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(hsv.v * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(hsv.v * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(hsv.v * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(hsv.v * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return new Color(0xFF000000 | r << 16 | g << 8 | b << 0);
    }

    public static boolean isBlock(BlockState blockState, Block ... blocks) {
        for (Block block : blocks) {
            if (!blockState.m_60713_(block)) continue;
            return true;
        }
        return false;
    }

    public static void openDinoInventory(BaseAnimal baseAnimal, ServerPlayer player) {
        if (player.f_36096_ != player.f_36095_) {
            player.m_6915_();
        }
        player.m_9217_();
        TDELevelEvents.openInventoryScreen((Player)player, (LivingEntity)baseAnimal, player.f_8940_, baseAnimal.getInventory().m_6643_());
        player.f_36096_ = new DinoInventoryMenu(player.f_8940_, player.m_150109_(), (Container)baseAnimal.getInventory(), baseAnimal);
        player.m_143399_(player.f_36096_);
        MinecraftForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((Player)player, player.f_36096_));
    }

    public static boolean isEntityNamedAs(Entity mob, String name) {
        if (mob.m_8077_()) {
            return ChatFormatting.m_126649_((String)mob.m_7755_().getString()).equals(name);
        }
        return false;
    }

    public static void pickSweetBerries(Entity entity, BlockPos blockPos, BlockState state) {
        int i = (Integer)state.m_61143_((Property)SweetBerryBushBlock.f_57244_);
        state.m_61124_((Property)SweetBerryBushBlock.f_57244_, (Comparable)Integer.valueOf(1));
        int j = 1 + entity.m_9236_().f_46441_.m_188503_(2) + (i == 3 ? 1 : 0);
        Block.m_49840_((Level)entity.m_9236_(), (BlockPos)blockPos, (ItemStack)new ItemStack((ItemLike)Items.f_42780_, j));
        entity.m_5496_(SoundEvents.f_12457_, 1.0f, 1.0f);
        entity.m_9236_().m_7731_(blockPos, (BlockState)state.m_61124_((Property)SweetBerryBushBlock.f_57244_, (Comparable)Integer.valueOf(1)), 2);
    }

    public static void giveItem(ItemStack itemStack, Player player) {
        boolean flag = player.m_150109_().m_36054_(itemStack);
        if (flag && itemStack.m_41619_()) {
            itemStack.m_41764_(1);
            ItemEntity entity = player.m_36176_(itemStack, false);
            if (entity != null) {
                entity.m_32065_();
            }
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((player.m_217043_().m_188501_() - player.m_217043_().m_188501_()) * 0.7f + 1.0f) * 2.0f);
            player.f_36096_.m_38946_();
        } else {
            ItemEntity itementity = player.m_36176_(itemStack, false);
            if (itementity != null) {
                itementity.m_32061_();
                itementity.m_266426_(player.m_20148_());
            }
        }
    }

    public static boolean isSameEntity(Entity a, Entity b) {
        if (a != null && b != null) {
            return a.m_20148_().equals(b.m_20148_());
        }
        return false;
    }

    public static AVector3f getDeviation(Vec3 to, Vec3 from) {
        float d1 = (float)(to.f_82479_ - from.f_82479_);
        float d2 = (float)(to.f_82481_ - from.f_82481_);
        float d3 = (float)Math.sqrt(d1 * d1 + d2 * d2);
        return new AVector3f((double)((float)Mth.m_14136_((double)(to.f_82480_ - from.f_82480_), (double)d3)), 0.0, (double)((float)Math.atan2(d2, d3)));
    }

    public static void crackGround(LivingEntity livingEntity, int radius, int min, int max, boolean particles) {
        if (!livingEntity.m_6162_()) {
            Level level = livingEntity.m_9236_();
            int id = 0;
            for (int i = -radius; i < radius; ++i) {
                for (int j = -radius; j < radius; ++j) {
                    BlockPos blockPos;
                    BlockState state;
                    if (i * i + j * j > radius * radius || RandomUtils.doWithChance((float)25.0f) || !(state = level.m_8055_(blockPos = livingEntity.m_20097_().m_7918_(i, 0, j))).m_280296_()) continue;
                    if (particles) {
                        level.m_142052_(blockPos, state);
                    }
                    level.m_6801_(id, blockPos, RandomUtils.randomInt((int)min, (int)max));
                    ++id;
                }
            }
        }
    }

    public static void affectEntitiesInRadius(LivingEntity livingEntity, AABB boundingBox, Predicate<LivingEntity> predicate, Consumer<LivingEntity> affect) {
        for (LivingEntity target : livingEntity.m_9236_().m_6443_(LivingEntity.class, boundingBox, predicate)) {
            if (livingEntity.m_20148_().equals(target.m_20148_()) || !predicate.test(target)) continue;
            affect.accept(target);
        }
    }

    public static void attackFrontEntities(BaseAnimal entity, float distance) {
        if (entity.m_6688_() != null) {
            LivingEntity controllingPassenger = entity.m_6688_();
            Vec3 direction = controllingPassenger.m_20252_(1.0f);
            Vec3 vec3 = controllingPassenger.m_146892_();
            Vec3 vec32 = vec3.m_82520_(direction.f_82479_ * (double)distance * (double)distance, direction.f_82480_ * (double)distance * (double)distance, direction.f_82481_ * (double)distance * (double)distance);
            AABB aabb = new AABB(vec3, vec32).m_82400_(3.0);
            EntityHitResult entityhitresult = ProjectileUtil.m_150175_((Level)controllingPassenger.m_9236_(), (Entity)controllingPassenger, (Vec3)vec3, (Vec3)vec32, (AABB)aabb, e -> {
                if (e instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)e;
                    return entity.m_6779_(livingEntity);
                }
                return false;
            }, (float)1.0f);
            if (entityhitresult != null) {
                entity.setLastAttackTarget((LivingEntity)entityhitresult.m_82443_());
            } else {
                for (LivingEntity target : entity.m_9236_().m_45976_(LivingEntity.class, entity.m_20191_().m_82400_(2.0))) {
                    if (!entity.m_6779_(target)) continue;
                    entity.setLastAttackTarget(target);
                    return;
                }
            }
        }
    }

    public static void shakeScreen(BaseAnimal mob, int radius, int ticks, double power) {
        if (!mob.m_6162_()) {
            for (Player nearbyPlayer : mob.m_9236_().m_45976_(Player.class, mob.m_20191_().m_82400_((double)radius))) {
                TDELevelEvents.shakeScreen(nearbyPlayer, mob.m_9236_(), mob.m_20183_(), ticks, power);
            }
        }
    }

    public static void breakNearbyBlocks(@Nullable Entity entity, Level level, BlockPos pos, float radius, Predicate<BlockState> predicate) {
        if (!level.f_46443_ && ForgeEventFactory.getMobGriefingEvent((Level)level, (Entity)entity)) {
            for (double x = (double)(-radius); x < (double)radius; x += 1.0) {
                for (double y = (double)(-radius); y < (double)radius; y += 1.0) {
                    for (double z = (double)(-radius); z < (double)radius; z += 1.0) {
                        BlockPos blockPos = pos.m_7918_((int)x, (int)y, (int)z);
                        if (!predicate.test(level.m_8055_(blockPos))) continue;
                        level.m_46953_(blockPos, false, entity);
                    }
                }
            }
        }
    }
}

